/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin.wasmgc;

import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicFactory;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicFactoryContext;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.platform.plugin.wasmgc.FieldMarker;
import org.teavm.platform.plugin.wasmgc.ResourceMethodIntrinsic;

public class WasmGCResourceMethodIntrinsicFactory
implements WasmGCIntrinsicFactory {
    @Override
    public WasmGCIntrinsic createIntrinsic(MethodReference methodRef, WasmGCIntrinsicFactoryContext context) {
        ClassReader cls = context.classes().get(methodRef.getClassName());
        if (cls == null) {
            return null;
        }
        MethodReader method = cls.getMethod(methodRef.getDescriptor());
        if (method == null) {
            return null;
        }
        AnnotationReader annot = method.getAnnotations().get(FieldMarker.class.getName());
        if (annot == null) {
            return null;
        }
        int index = annot.getValue("index").getInt();
        return new ResourceMethodIntrinsic(index);
    }
}

