/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin.wasmgc;

import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.plugin.wasmgc.ResourceMapEntry;

public final class ResourceMapHelper {
    private ResourceMapHelper() {
    }

    private static native ResourceMapEntry entry(ResourceMap<?> var0, int var1);

    private static native int entryCount(ResourceMap<?> var0);

    public static Resource get(ResourceMap<?> map, String key) {
        ResourceMapEntry entry;
        int initialIndex;
        int i;
        int count = ResourceMapHelper.entryCount(map);
        for (i = initialIndex = Integer.remainderUnsigned(key.hashCode(), count); i < count; ++i) {
            entry = ResourceMapHelper.entry(map, i);
            if (entry == null) {
                return null;
            }
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        for (i = 0; i < initialIndex; ++i) {
            entry = ResourceMapHelper.entry(map, i);
            if (entry == null) {
                return null;
            }
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean has(ResourceMap<?> map, String key) {
        return ResourceMapHelper.get(map, key) != null;
    }

    public static String[] keys(ResourceMap<?> map) {
        int count = 0;
        int entryCount = ResourceMapHelper.entryCount(map);
        for (int i = 0; i < entryCount; ++i) {
            ResourceMapEntry entry = ResourceMapHelper.entry(map, i);
            if (entry == null) continue;
            ++count;
        }
        String[] result = new String[count];
        int index = 0;
        for (int i = 0; i < entryCount; ++i) {
            ResourceMapEntry entry = ResourceMapHelper.entry(map, i);
            if (entry == null) continue;
            result[index++] = entry.getKey();
        }
        return result;
    }
}

