/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin.wasmgc;

import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.plugin.wasmgc.FieldMarker;
import org.teavm.platform.plugin.wasmgc.ResourceMapHelper;
import org.teavm.platform.plugin.wasmgc.ResourceMarker;

public class ResourceInterfaceToClassTransformer
implements ClassHolderTransformer {
    private static final String RESOURCE_CLASS = Resource.class.getName();

    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        if (context.getHierarchy().isSuperType(RESOURCE_CLASS, cls.getName(), false) && cls.hasModifier(ElementModifier.INTERFACE)) {
            cls.getModifiers().remove((Object)ElementModifier.INTERFACE);
            cls.getModifiers().add(ElementModifier.ABSTRACT);
            int index = 0;
            if (!cls.getInterfaces().isEmpty()) {
                AnnotationReader resourceAnnot;
                String parent = cls.getInterfaces().iterator().next();
                cls.getInterfaces().clear();
                cls.setParent(parent);
                ClassReader parentCls = context.getHierarchy().getClassSource().get(parent);
                if (parentCls != null && (resourceAnnot = parentCls.getAnnotations().get(ResourceMarker.class.getName())) != null) {
                    index = resourceAnnot.getValue("fieldCount").getInt();
                }
            }
            for (MethodHolder method : cls.getMethods()) {
                AnnotationHolder annot;
                String fieldName;
                method.getModifiers().remove((Object)ElementModifier.ABSTRACT);
                method.getModifiers().add(ElementModifier.NATIVE);
                if (method.getName().startsWith("get") && method.getName().length() > 3 && Character.isUpperCase(method.getName().charAt(3)) && method.getResultType() != ValueType.VOID) {
                    fieldName = Character.toLowerCase(method.getName().charAt(3)) + method.getName().substring(4);
                    annot = new AnnotationHolder(FieldMarker.class.getName());
                    annot.getValues().put("value", new AnnotationValue(fieldName));
                    annot.getValues().put("index", new AnnotationValue(index++));
                    method.getAnnotations().add(annot);
                    continue;
                }
                if (!method.getName().startsWith("is") || method.getName().length() <= 2 || !Character.isUpperCase(method.getName().charAt(2)) || method.getResultType() != ValueType.BOOLEAN) continue;
                fieldName = Character.toLowerCase(method.getName().charAt(2)) + method.getName().substring(3);
                annot = new AnnotationHolder(FieldMarker.class.getName());
                annot.getValues().put("value", new AnnotationValue(fieldName));
                annot.getValues().put("index", new AnnotationValue(index++));
                method.getAnnotations().add(annot);
            }
            if (cls.getName().equals(ResourceMap.class.getName())) {
                this.transformResourceMapMethods(cls, context.getHierarchy());
            }
            AnnotationHolder resourceAnnot = new AnnotationHolder(ResourceMarker.class.getName());
            resourceAnnot.getValues().put("fieldCount", new AnnotationValue(index));
            cls.getAnnotations().add(resourceAnnot);
        } else {
            for (MethodHolder method : cls.getMethods()) {
                if (method.getProgram() == null) continue;
                this.transformResourceUsages(method.getProgram(), context);
            }
        }
    }

    private void transformResourceMapMethods(ClassHolder cls, ClassHierarchy hierarchy) {
        for (MethodHolder method : cls.getMethods()) {
            switch (method.getName()) {
                case "has": {
                    method.getModifiers().remove((Object)ElementModifier.NATIVE);
                    ProgramEmitter pe = ProgramEmitter.create(method, hierarchy);
                    pe.invoke(ResourceMapHelper.class, "has", Boolean.TYPE, pe.var(0, ResourceMap.class), pe.var(1, String.class)).returnValue();
                    break;
                }
                case "get": {
                    method.getModifiers().remove((Object)ElementModifier.NATIVE);
                    ProgramEmitter pe = ProgramEmitter.create(method, hierarchy);
                    pe.invoke(ResourceMapHelper.class, "get", Resource.class, pe.var(0, ResourceMap.class), pe.var(1, String.class)).returnValue();
                    break;
                }
                case "keys": {
                    method.getModifiers().remove((Object)ElementModifier.NATIVE);
                    ProgramEmitter pe = ProgramEmitter.create(method, hierarchy);
                    pe.invoke(ResourceMapHelper.class, "keys", String[].class, pe.var(0, ResourceMap.class)).returnValue();
                    break;
                }
            }
        }
    }

    private void transformResourceUsages(Program program, ClassHolderTransformerContext context) {
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                InvokeInstruction invoke;
                if (instruction instanceof CastInstruction) {
                    CastInstruction cast = (CastInstruction)instruction;
                    if (cast.isWeak() || !(cast.getTargetType() instanceof ValueType.Object)) continue;
                    String className = ((ValueType.Object)cast.getTargetType()).getClassName();
                    if (!context.getHierarchy().isSuperType(RESOURCE_CLASS, className, false)) continue;
                    cast.setWeak(true);
                    continue;
                }
                if (!(instruction instanceof InvokeInstruction) || (invoke = (InvokeInstruction)instruction).getInstance() == null || invoke.getType() == InvocationType.SPECIAL || !context.getHierarchy().isSuperType(RESOURCE_CLASS, invoke.getMethod().getClassName(), false)) continue;
                invoke.setType(InvocationType.SPECIAL);
            }
        }
    }
}

