/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReader;
import org.teavm.model.ValueType;
import org.teavm.platform.plugin.ResourceAccessorType;
import org.teavm.platform.plugin.ResourceMethodDescriptor;

public class ResourceTypeDescriptor {
    private static Set<ValueType> allowedPropertyTypes = Set.of(ValueType.BOOLEAN, ValueType.BYTE, ValueType.SHORT, ValueType.INTEGER, ValueType.FLOAT, ValueType.DOUBLE, ValueType.object("java.lang.String"), ValueType.object("org.teavm.platform.metadata.ResourceArray"), ValueType.object("org.teavm.platform.metadata.ResourceMap"));
    private ClassHierarchy hierarchy;
    private ClassReader rootIface;
    private Map<String, ValueType> getters = new HashMap<String, ValueType>();
    private Map<MethodReader, ResourceMethodDescriptor> methods = new LinkedHashMap<MethodReader, ResourceMethodDescriptor>();
    private Map<String, ValueType> propertyTypes = new LinkedHashMap<String, ValueType>();

    public ResourceTypeDescriptor(ClassHierarchy hierarchy, ClassReader iface) {
        this.hierarchy = hierarchy;
        this.rootIface = iface;
        this.scanIface(this.rootIface);
    }

    public ClassReader getRootInterface() {
        return this.rootIface;
    }

    public Map<MethodReader, ResourceMethodDescriptor> getMethods() {
        return this.methods;
    }

    public Map<String, ValueType> getPropertyTypes() {
        return this.propertyTypes;
    }

    private void scanIface(ClassReader iface) {
        this.getters.clear();
        for (MethodReader methodReader : iface.getMethods()) {
            if (methodReader.getName().startsWith("get")) {
                this.scanGetter(methodReader);
                continue;
            }
            if (methodReader.getName().startsWith("is")) {
                this.scanBooleanGetter(methodReader);
                continue;
            }
            this.throwInvalidMethod(methodReader);
        }
        for (Map.Entry entry : this.getters.entrySet()) {
            String propertyName = (String)entry.getKey();
            ValueType propertyType = (ValueType)entry.getValue();
            if (!allowedPropertyTypes.contains(propertyType) && !this.isAllowedCustomType(propertyType)) {
                throw new IllegalArgumentException("Property " + this.rootIface.getName() + "." + propertyName + " has an illegal type " + String.valueOf(propertyType));
            }
            if (this.propertyTypes.containsKey(propertyName)) continue;
            this.propertyTypes.put(propertyName, propertyType);
        }
        for (String string : iface.getInterfaces()) {
            ClassReader superIface = this.hierarchy.getClassSource().get(string);
            if (superIface == null) continue;
            this.scanIface(superIface);
        }
    }

    private boolean isAllowedCustomType(ValueType type) {
        if (!(type instanceof ValueType.Object)) {
            return false;
        }
        String className = ((ValueType.Object)type).getClassName();
        ClassReader cls = this.hierarchy.getClassSource().get(className);
        return cls != null;
    }

    private void throwInvalidMethod(MethodReader method) {
        throw new IllegalArgumentException("Method " + method.getOwnerName() + "." + method.getName() + " is not likely to be either getter or setter");
    }

    private void scanGetter(MethodReader method) {
        String propertyName = this.extractPropertyName(method.getName().substring(3));
        if (propertyName == null || method.getResultType() == ValueType.VOID || method.getParameterTypes().length > 0) {
            this.throwInvalidMethod(method);
        }
        if (this.getters.put(propertyName, method.getResultType()) != null) {
            throw new IllegalArgumentException("Method " + method.getOwnerName() + "." + method.getName() + " is a duplicate getter for property " + propertyName);
        }
        this.methods.put(method, new ResourceMethodDescriptor(propertyName, ResourceAccessorType.GETTER));
    }

    private void scanBooleanGetter(MethodReader method) {
        String propertyName = this.extractPropertyName(method.getName().substring(2));
        if (propertyName == null || method.getResultType() != ValueType.BOOLEAN || method.getParameterTypes().length > 0) {
            this.throwInvalidMethod(method);
        }
        if (this.getters.put(propertyName, method.getResultType()) != null) {
            throw new IllegalArgumentException("Method " + method.getOwnerName() + "." + method.getName() + " is a duplicate getter for property " + propertyName);
        }
        this.methods.put(method, new ResourceMethodDescriptor(propertyName, ResourceAccessorType.GETTER));
    }

    private String extractPropertyName(String propertyName) {
        if (propertyName.isEmpty()) {
            return null;
        }
        char c = propertyName.charAt(0);
        if (c != Character.toUpperCase(c)) {
            return null;
        }
        if (propertyName.length() == 1) {
            return propertyName.toLowerCase();
        }
        c = propertyName.charAt(1);
        if (c == Character.toUpperCase(c)) {
            return propertyName;
        }
        return Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
    }
}

