/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.binary.DataPrimitives;
import org.teavm.backend.wasm.binary.DataStructure;
import org.teavm.backend.wasm.binary.DataType;
import org.teavm.backend.wasm.binary.DataValue;
import org.teavm.backend.wasm.generate.WasmStringPool;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.common.ServiceRepository;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.builders.ObjectResourceBuilder;
import org.teavm.platform.metadata.builders.ResourceArrayBuilder;
import org.teavm.platform.metadata.builders.ResourceBuilder;
import org.teavm.platform.metadata.builders.ResourceMapBuilder;
import org.teavm.platform.plugin.DefaultMetadataGeneratorContext;
import org.teavm.platform.plugin.ResourceTypeDescriptor;

class MetadataIntrinsic
implements WasmIntrinsic {
    private ClassReaderSource classSource;
    private ClassLoader classLoader;
    private ServiceRepository services;
    private Properties properties;
    private Map<Class<?>, ResourceTypeDescriptor> descriptors = new HashMap();
    private Map<ResourceTypeDescriptor, DataStructure> resourceTypeCache = new HashMap<ResourceTypeDescriptor, DataStructure>();
    private MethodReference constructor;
    private MethodReference targetMethod;
    private MetadataGenerator generator;

    MetadataIntrinsic(ClassReaderSource classSource, ClassLoader classLoader, ServiceRepository services, Properties properties, MethodReference constructor, MethodReference targetMethod, MetadataGenerator generator) {
        this.classSource = classSource;
        this.classLoader = classLoader;
        this.services = services;
        this.properties = properties;
        this.constructor = constructor;
        this.targetMethod = targetMethod;
        this.generator = generator;
    }

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        return methodReference.equals(this.constructor);
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        DefaultMetadataGeneratorContext metadataContext = new DefaultMetadataGeneratorContext(this.classSource, manager.getResourceProvider(), this.classLoader, this.properties, this.services);
        ResourceBuilder resource = this.generator.generateMetadata(metadataContext, this.targetMethod);
        int address = this.writeValue(manager, resource);
        return new WasmInt32Constant(address);
    }

    private int writeValue(WasmIntrinsicManager manager, Object value) {
        WasmStringPool stringPool = manager.getStringPool();
        BinaryWriter writer = manager.getBinaryWriter();
        if (value instanceof String) {
            return stringPool.getStringPointer((String)value);
        }
        if (value instanceof Boolean) {
            DataValue dataValue = DataPrimitives.BYTE.createValue();
            dataValue.setByte(0, (Boolean)value != false ? (byte)1 : 0);
            return writer.append(dataValue);
        }
        if (value instanceof Integer) {
            DataValue dataValue = DataPrimitives.INT.createValue();
            dataValue.setInt(0, (Integer)value);
            return writer.append(dataValue);
        }
        if (value instanceof Long) {
            DataValue dataValue = DataPrimitives.LONG.createValue();
            dataValue.setLong(0, (Long)value);
            return writer.append(dataValue);
        }
        if (value instanceof ResourceMapBuilder) {
            return this.writeResource(manager, (ResourceMapBuilder)value);
        }
        if (value instanceof ResourceArrayBuilder) {
            return this.writeResource(manager, (ResourceArrayBuilder)value);
        }
        if (value instanceof ObjectResourceBuilder) {
            return this.writeResource(manager, (ObjectResourceBuilder)value);
        }
        throw new IllegalArgumentException("Don't know how to write resource: " + String.valueOf(value));
    }

    private int writeResource(WasmIntrinsicManager manager, ObjectResourceBuilder resource) {
        BinaryWriter writer = manager.getBinaryWriter();
        ResourceTypeDescriptor descriptor = this.getDescriptor(manager.getClassHierarchy(), resource.getOutputClass());
        DataStructure structure = this.getDataStructure(descriptor);
        DataValue value = structure.createValue();
        int address = writer.append(value);
        ObjectIntHashMap<String> map = new ObjectIntHashMap<String>();
        String[] fieldNames = resource.fieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            map.put(fieldNames[i], i);
        }
        List<Map.Entry<String, ValueType>> entries = List.copyOf(descriptor.getPropertyTypes().entrySet());
        for (int i = 0; i < entries.size(); ++i) {
            Map.Entry<String, ValueType> entry = entries.get(i);
            String propertyName = entry.getKey();
            ValueType propertyType = entry.getValue();
            int index = map.getOrDefault(propertyName, -1);
            Object propertyValue = resource.getValue(index);
            this.writeValueTo(manager, propertyType, value, i, propertyValue);
        }
        return address;
    }

    private int writeResource(WasmIntrinsicManager manager, ResourceMapBuilder<?> resourceMap) {
        BinaryWriter writer = manager.getBinaryWriter();
        WasmStringPool stringPool = manager.getStringPool();
        return writer.writeMap(resourceMap.values.keySet().toArray(new String[0]), String::hashCode, stringPool::getStringPointer, key -> this.writeValue(manager, resourceMap.values.get(key)));
    }

    private int writeResource(WasmIntrinsicManager manager, ResourceArrayBuilder<?> resourceArray) {
        int i;
        BinaryWriter writer = manager.getBinaryWriter();
        DataValue sizeValue = DataPrimitives.ADDRESS.createValue();
        int start = writer.append(sizeValue);
        sizeValue.setAddress(0, resourceArray.values.size());
        DataValue[] arrayValues = new DataValue[resourceArray.values.size()];
        for (i = 0; i < resourceArray.values.size(); ++i) {
            arrayValues[i] = DataPrimitives.ADDRESS.createValue();
            writer.append(arrayValues[i]);
        }
        for (i = 0; i < resourceArray.values.size(); ++i) {
            arrayValues[i].setAddress(0, this.writeValue(manager, resourceArray.values.get(i)));
        }
        return start;
    }

    private void writeValueTo(WasmIntrinsicManager manager, ValueType type, DataValue target, int index, Object value) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    target.setByte(index, (Boolean)value != false ? (byte)1 : 0);
                    break;
                }
                case BYTE: {
                    target.setByte(index, (Byte)value);
                    break;
                }
                case SHORT: {
                    target.setShort(index, (Short)value);
                    break;
                }
                case CHARACTER: {
                    target.setShort(index, (short)((Character)value).charValue());
                    break;
                }
                case INTEGER: {
                    target.setInt(index, (Integer)value);
                    break;
                }
                case LONG: {
                    target.setLong(index, (Long)value);
                    break;
                }
                case FLOAT: {
                    target.setFloat(index, ((Float)value).floatValue());
                    break;
                }
                case DOUBLE: {
                    target.setDouble(index, (Double)value);
                }
            }
        } else if (type instanceof ValueType.Object) {
            String className;
            switch (className = ((ValueType.Object)type).getClassName()) {
                case "java.lang.String": {
                    target.setAddress(index, value != null ? (long)manager.getStringPool().getStringPointer((String)value) : 0L);
                    break;
                }
                case "org.teavm.platform.metadata.ResourceMap": {
                    target.setAddress(index, this.writeResource(manager, (ResourceMapBuilder)value));
                    break;
                }
                case "org.teavm.platform.metadata.ResourceArray": {
                    target.setAddress(index, this.writeResource(manager, (ResourceArrayBuilder)value));
                    break;
                }
                default: {
                    int address = this.writeResource(manager, (ObjectResourceBuilder)value);
                    target.setAddress(index, address);
                }
            }
        }
    }

    private ResourceTypeDescriptor getDescriptor(ClassHierarchy hierarchy, Class<?> cls) {
        return this.descriptors.computeIfAbsent(cls, t -> {
            ClassReader classReader = this.classSource.get(t.getName());
            return new ResourceTypeDescriptor(hierarchy, classReader);
        });
    }

    private DataStructure getDataStructure(ResourceTypeDescriptor desc) {
        return this.resourceTypeCache.computeIfAbsent(desc, t -> {
            ArrayList<String> propertyNames = new ArrayList<String>(t.getPropertyTypes().keySet());
            DataType[] propertyDataTypes = new DataType[propertyNames.size()];
            for (int i = 0; i < propertyNames.size(); ++i) {
                String propertyName = propertyNames.get(i);
                propertyDataTypes[i] = MetadataIntrinsic.getDataType(t.getPropertyTypes().get(propertyName));
            }
            return new DataStructure(4, propertyDataTypes);
        });
    }

    private static DataType getDataType(ValueType cls) {
        if (cls instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)cls).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    return DataPrimitives.BYTE;
                }
                case SHORT: 
                case CHARACTER: {
                    return DataPrimitives.SHORT;
                }
                case INTEGER: {
                    return DataPrimitives.INT;
                }
                case LONG: {
                    return DataPrimitives.LONG;
                }
                case FLOAT: {
                    return DataPrimitives.FLOAT;
                }
                case DOUBLE: {
                    return DataPrimitives.DOUBLE;
                }
            }
        }
        return DataPrimitives.ADDRESS;
    }
}

