/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.backend.javascript.spi.MethodContributor;
import org.teavm.backend.javascript.spi.MethodContributorContext;
import org.teavm.backend.javascript.templating.JavaScriptTemplate;
import org.teavm.backend.javascript.templating.JavaScriptTemplateFactory;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.MethodDependency;
import org.teavm.interop.AsyncCallback;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.plugin.AsyncCallbackWrapper;
import org.teavm.platform.plugin.AsyncCaller;

public class AsyncMethodGenerator
implements Generator,
DependencyPlugin,
MethodContributor {
    private static final MethodDescriptor completeMethod = new MethodDescriptor("complete", Object.class, Void.TYPE);
    private static final MethodDescriptor errorMethod = new MethodDescriptor("error", Throwable.class, Void.TYPE);
    private JavaScriptTemplate template;

    @Override
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) {
        if (this.template == null) {
            JavaScriptTemplateFactory templateFactory = new JavaScriptTemplateFactory(context.getClassLoader(), context.getClassSource());
            this.template = templateFactory.createFromResource("org/teavm/platform/plugin/Async.js");
        }
        MethodReference asyncRef = this.getAsyncReference(context.getClassSource(), methodRef);
        this.template.builder("asyncMethod").withContext(context).withFragment("callMethod", (w, p) -> {
            int start;
            w.appendMethod(asyncRef).append('(');
            ClassReader cls = context.getClassSource().get(methodRef.getClassName());
            MethodReader method = cls.getMethod(methodRef.getDescriptor());
            for (int i = start = method.hasModifier(ElementModifier.STATIC) ? 1 : 0; i <= methodRef.parameterCount(); ++i) {
                w.append(context.getParameterName(i));
                w.append(',').ws();
            }
            w.append("callback);").softNewLine();
        }).build().write(writer, 0);
    }

    private MethodReference getAsyncReference(ClassReaderSource classSource, MethodReference methodRef) {
        MethodReader method = classSource.resolve(methodRef);
        AnnotationReader callerAnnot = method.getAnnotations().get(AsyncCaller.class.getName());
        return MethodReference.parse(callerAnnot.getValue("value").getString());
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        MethodReference ref = method.getReference();
        MethodReference asyncRef = this.getAsyncReference(agent.getClassSource(), ref);
        MethodDependency asyncMethod = agent.linkMethod(asyncRef);
        method.addLocationListener(asyncMethod::addLocation);
        int paramCount = ref.parameterCount();
        for (int i = 0; i <= paramCount; ++i) {
            method.getVariable(i).connect(asyncMethod.getVariable(i));
        }
        asyncMethod.getVariable(paramCount + 1).propagate(agent.getType(ValueType.object(AsyncCallbackWrapper.class.getName())));
        MethodDependency completeMethod = agent.linkMethod(new MethodReference(AsyncCallbackWrapper.class, "complete", Object.class, Void.TYPE));
        if (method.getResult() != null) {
            completeMethod.getVariable(1).connect(method.getResult(), type -> agent.getClassHierarchy().isSuperType(ref.getReturnType(), type.getValueType(), false));
        }
        completeMethod.use();
        MethodDependency errorMethod = agent.linkMethod(new MethodReference(AsyncCallbackWrapper.class, "error", Throwable.class, Void.TYPE));
        errorMethod.getVariable(1).connect(method.getThrown());
        errorMethod.use();
        agent.linkMethod(new MethodReference(AsyncCallbackWrapper.class, "create", AsyncCallback.class, AsyncCallbackWrapper.class)).use();
        asyncMethod.use();
    }

    @Override
    public boolean isContributing(MethodContributorContext context, MethodReference methodRef) {
        ClassReader cls = context.getClassSource().get(methodRef.getClassName());
        if (cls == null) {
            return false;
        }
        if (!cls.getInterfaces().contains(AsyncCallback.class.getName())) {
            return false;
        }
        return methodRef.getDescriptor().equals(completeMethod) || methodRef.getDescriptor().equals(errorMethod);
    }
}

