/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.metaprogramming.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.Value;
import org.teavm.metaprogramming.impl.AliasFinder;
import org.teavm.metaprogramming.impl.CapturedValue;
import org.teavm.metaprogramming.impl.LazyValueImpl;
import org.teavm.metaprogramming.impl.MetaprogrammingImpl;
import org.teavm.metaprogramming.impl.ValueImpl;
import org.teavm.metaprogramming.impl.VariableContext;
import org.teavm.metaprogramming.impl.reflect.ReflectClassImpl;
import org.teavm.metaprogramming.impl.reflect.ReflectFieldImpl;
import org.teavm.metaprogramming.impl.reflect.ReflectMethodImpl;
import org.teavm.metaprogramming.reflect.ReflectField;
import org.teavm.metaprogramming.reflect.ReflectMethod;
import org.teavm.model.BasicBlock;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.CallLocation;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReference;
import org.teavm.model.Incoming;
import org.teavm.model.IncomingReader;
import org.teavm.model.Instruction;
import org.teavm.model.InvokeDynamicInstruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHandle;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.PhiReader;
import org.teavm.model.Program;
import org.teavm.model.ProgramReader;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.TextLocation;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.TryCatchBlockReader;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.VariableReader;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingCondition;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BinaryOperation;
import org.teavm.model.instructions.BoundCheckInstruction;
import org.teavm.model.instructions.BranchingCondition;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerDirection;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionReader;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.IntegerSubtype;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.instructions.MonitorExitInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.NumericOperandType;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.SwitchTableEntry;
import org.teavm.model.instructions.SwitchTableEntryReader;
import org.teavm.model.instructions.UnwrapArrayInstruction;

public class CompositeMethodGenerator {
    private Diagnostics diagnostics;
    Program program;
    TextLocation location;
    TextLocation forcedLocation;
    int blockIndex;
    int returnBlockIndex;
    private Variable resultVar;
    private Phi resultPhi;
    private Map<BasicBlock, BasicBlock> phiBlockMap = new HashMap<BasicBlock, BasicBlock>();
    VariableContext varContext;

    CompositeMethodGenerator(VariableContext varContext) {
        this(varContext, new Program());
        this.program.createBasicBlock();
    }

    CompositeMethodGenerator(VariableContext varContext, Program program) {
        this.diagnostics = MetaprogrammingImpl.createDiagnostics();
        this.program = program;
        this.varContext = varContext;
    }

    public void addProgram(ProgramReader template, List<CapturedValue> capturedValues) {
        BasicBlock targetBlock;
        BasicBlockReader templateBlock;
        int i;
        this.location = null;
        this.resultVar = null;
        this.resultPhi = null;
        int startBlock = this.blockIndex;
        AliasFinder aliasFinder = new AliasFinder();
        aliasFinder.findAliases(template);
        CapturedValue[] capturedValueArray = new CapturedValue[template.variableCount()];
        for (int i3 = 0; i3 < capturedValues.size(); ++i3) {
            capturedValueArray[i3 + 1] = capturedValues.get(i3);
        }
        TemplateSubstitutor substitutor = new TemplateSubstitutor(capturedValueArray, aliasFinder.getAliases(), aliasFinder.getArrayElements(), this.program.basicBlockCount() - 1, this.program.variableCount() - capturedValues.size());
        for (int i2 = 0; i2 < template.basicBlockCount(); ++i2) {
            this.program.createBasicBlock();
        }
        this.returnBlockIndex = this.program.basicBlockCount() - 1;
        for (int i2 = capturedValues.size(); i2 < template.variableCount(); ++i2) {
            VariableReader variable = template.variableAt(i2);
            Variable variableCopy = this.program.createVariable();
            variableCopy.setDebugName(variable.getDebugName());
            variableCopy.setLabel(variable.getLabel());
        }
        List outgoings = Stream.generate(ArrayList::new).limit(template.basicBlockCount()).collect(Collectors.toList());
        List outgoingVars = Stream.generate(ArrayList::new).limit(template.basicBlockCount()).collect(Collectors.toList());
        for (i = 0; i < template.basicBlockCount(); ++i) {
            templateBlock = template.basicBlockAt(i);
            this.blockIndex = i == 0 ? startBlock : substitutor.blockOffset + i;
            targetBlock = this.program.basicBlockAt(this.blockIndex);
            for (PhiReader phiReader : templateBlock.readPhis()) {
                Phi phi = new Phi();
                for (IncomingReader incomingReader : phiReader.readIncomings()) {
                    Incoming incoming = new Incoming();
                    incoming.setSource(substitutor.block(incomingReader.getSource()));
                    phi.getIncomings().add(incoming);
                    int sourceIndex = incomingReader.getSource().getIndex();
                    ((List)outgoings.get(sourceIndex)).add(incoming);
                    ((List)outgoingVars.get(sourceIndex)).add(incomingReader.getValue());
                }
                phi.setReceiver(substitutor.var(phiReader.getReceiver()));
                targetBlock.getPhis().add(phi);
            }
        }
        for (i = 0; i < template.basicBlockCount(); ++i) {
            templateBlock = template.basicBlockAt(i);
            this.blockIndex = i == 0 ? startBlock : substitutor.blockOffset + i;
            targetBlock = this.program.basicBlockAt(this.blockIndex);
            if (templateBlock.getExceptionVariable() != null) {
                targetBlock.setExceptionVariable(substitutor.var(templateBlock.getExceptionVariable()));
            }
            for (TryCatchBlockReader tryCatchBlockReader : templateBlock.readTryCatchBlocks()) {
                TryCatchBlock tryCatch = new TryCatchBlock();
                tryCatch.setExceptionType(tryCatchBlockReader.getExceptionType());
                tryCatch.setHandler(substitutor.block(tryCatchBlockReader.getHandler()));
                targetBlock.getTryCatchBlocks().add(tryCatch);
            }
            templateBlock.readAllInstructions(substitutor);
            Instruction lastInsn = targetBlock.getLastInstruction();
            lastInsn.delete();
            List list = (List)outgoings.get(i);
            for (int j = 0; j < list.size(); ++j) {
                VariableReader outgoingVar = (VariableReader)((List)outgoingVars.get(i)).get(j);
                ((Incoming)list.get(j)).setValue(substitutor.var(outgoingVar));
            }
            targetBlock.add(lastInsn);
            this.phiBlockMap.put(targetBlock, this.currentBlock());
        }
        for (i = 0; i < template.basicBlockCount(); ++i) {
            BasicBlock block = this.program.basicBlockAt(i == 0 ? startBlock : substitutor.blockOffset + i);
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    BasicBlock mappedBlock = this.phiBlockMap.get(incoming.getSource());
                    if (mappedBlock == null) continue;
                    incoming.setSource(mappedBlock);
                }
            }
        }
        this.phiBlockMap.clear();
        this.blockIndex = substitutor.blockOffset + template.basicBlockCount();
    }

    public Variable getResultVar() {
        return this.resultVar;
    }

    public BasicBlock currentBlock() {
        return this.program.basicBlockAt(this.blockIndex);
    }

    void add(Instruction insn) {
        insn.setLocation(this.forcedLocation != null ? this.forcedLocation : this.location);
        this.program.basicBlockAt(this.blockIndex).add(insn);
    }

    Variable captureValue(CapturedValue captured) {
        Object value = captured.obj;
        if (value == null) {
            NullConstantInstruction insn = new NullConstantInstruction();
            insn.setReceiver(this.program.createVariable());
            this.add(insn);
            return insn.getReceiver();
        }
        if (value instanceof Integer) {
            IntegerConstantInstruction insn = new IntegerConstantInstruction();
            insn.setReceiver(this.program.createVariable());
            insn.setConstant((Integer)value);
            this.add(insn);
            Variable result = insn.getReceiver();
            if (!captured.primitive) {
                result = this.box(result, ValueType.INTEGER);
            }
            return result;
        }
        if (value instanceof Long) {
            LongConstantInstruction insn = new LongConstantInstruction();
            insn.setReceiver(this.program.createVariable());
            insn.setConstant((Long)value);
            this.add(insn);
            Variable result = insn.getReceiver();
            if (!captured.primitive) {
                result = this.box(result, ValueType.LONG);
            }
            return result;
        }
        if (value instanceof Float) {
            FloatConstantInstruction insn = new FloatConstantInstruction();
            insn.setReceiver(this.program.createVariable());
            insn.setConstant(((Float)value).floatValue());
            this.add(insn);
            Variable result = insn.getReceiver();
            if (!captured.primitive) {
                result = this.box(result, ValueType.FLOAT);
            }
            return result;
        }
        if (value instanceof Double) {
            DoubleConstantInstruction insn = new DoubleConstantInstruction();
            insn.setReceiver(this.program.createVariable());
            insn.setConstant((Double)value);
            this.add(insn);
            Variable result = insn.getReceiver();
            if (!captured.primitive) {
                result = this.box(result, ValueType.DOUBLE);
            }
            return result;
        }
        if (value instanceof String) {
            StringConstantInstruction insn = new StringConstantInstruction();
            insn.setReceiver(this.program.createVariable());
            insn.setConstant((String)value);
            this.add(insn);
            return insn.getReceiver();
        }
        if (value instanceof ValueType) {
            ClassConstantInstruction insn = new ClassConstantInstruction();
            insn.setReceiver(this.program.createVariable());
            insn.setConstant((ValueType)value);
            this.add(insn);
            return insn.getReceiver();
        }
        if (value instanceof Class) {
            ClassConstantInstruction insn = new ClassConstantInstruction();
            insn.setReceiver(this.program.createVariable());
            insn.setConstant(ValueType.parse((Class)value));
            this.add(insn);
            return insn.getReceiver();
        }
        if (value instanceof ValueImpl) {
            Variable result = this.varContext.emitVariable((ValueImpl)value, new CallLocation(MetaprogrammingImpl.templateMethod, this.location));
            return this.coalesce(result);
        }
        if (value instanceof LazyValueImpl) {
            return this.coalesce(this.lazy((LazyValueImpl)value));
        }
        if (value instanceof ReflectFieldImpl) {
            ReflectFieldImpl reflectField = (ReflectFieldImpl)value;
            this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, this.location), "Can't reference this ReflectField {{f0}} directly except for calling special methods on it", reflectField.field.getReference());
            NullConstantInstruction insn = new NullConstantInstruction();
            insn.setReceiver(this.program.createVariable());
            this.add(insn);
            return insn.getReceiver();
        }
        if (value instanceof ReflectMethodImpl) {
            ReflectMethodImpl reflectMethod = (ReflectMethodImpl)value;
            this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, this.location), "Can't reference this ReflectMethod {{m0}} directly except for calling special methods on it", reflectMethod.method.getReference());
            NullConstantInstruction insn = new NullConstantInstruction();
            insn.setReceiver(this.program.createVariable());
            this.add(insn);
            return insn.getReceiver();
        }
        if (value.getClass().getComponentType() != null) {
            this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, this.location), "Can't reference this array directly except for fetching by constant index", new Object[0]);
            NullConstantInstruction insn = new NullConstantInstruction();
            insn.setReceiver(this.program.createVariable());
            this.add(insn);
            return insn.getReceiver();
        }
        this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, this.location), "Wrong captured value", new Object[0]);
        NullConstantInstruction insn = new NullConstantInstruction();
        insn.setReceiver(this.program.createVariable());
        this.add(insn);
        return insn.getReceiver();
    }

    Variable lazy(LazyValueImpl<?> lazyImpl) {
        CompositeMethodGenerator nestedGenerator = new CompositeMethodGenerator(this.varContext, this.program);
        nestedGenerator.blockIndex = this.blockIndex;
        nestedGenerator.location = this.location;
        nestedGenerator.forcedLocation = lazyImpl.forcedLocation;
        MetaprogrammingImpl.generator = nestedGenerator;
        Value result = lazyImpl.computation.compute();
        this.blockIndex = nestedGenerator.blockIndex;
        MetaprogrammingImpl.generator = this;
        if (result instanceof ValueImpl) {
            return ((ValueImpl)result).innerValue;
        }
        if (result instanceof LazyValueImpl) {
            return this.lazy((LazyValueImpl)result);
        }
        if (result != null) {
            throw new IllegalStateException("Unknown value type: " + result.getClass().getName());
        }
        return null;
    }

    private Variable coalesce(Variable var) {
        if (var == null) {
            NullConstantInstruction nullInsn = new NullConstantInstruction();
            nullInsn.setReceiver(this.program.createVariable());
            var = nullInsn.getReceiver();
            this.add(nullInsn);
        }
        return var;
    }

    Variable box(Variable var, ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return this.box(var, Boolean.TYPE, Boolean.class);
                }
                case BYTE: {
                    return this.box(var, Byte.TYPE, Byte.class);
                }
                case SHORT: {
                    return this.box(var, Short.TYPE, Short.class);
                }
                case CHARACTER: {
                    return this.box(var, Character.TYPE, Character.class);
                }
                case INTEGER: {
                    return this.box(var, Integer.TYPE, Integer.class);
                }
                case LONG: {
                    return this.box(var, Long.TYPE, Long.class);
                }
                case FLOAT: {
                    return this.box(var, Float.TYPE, Float.class);
                }
                case DOUBLE: {
                    return this.box(var, Double.TYPE, Double.class);
                }
            }
        }
        return var;
    }

    private Variable box(Variable var, Class<?> primitive, Class<?> wrapper) {
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(new MethodReference(wrapper, "valueOf", primitive, wrapper));
        insn.setType(InvocationType.SPECIAL);
        insn.setArguments(var);
        var = this.program.createVariable();
        insn.setReceiver(var);
        this.add(insn);
        return var;
    }

    Variable unbox(Variable var, ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return this.unbox(var, Boolean.TYPE, Boolean.class);
                }
                case BYTE: {
                    return this.unbox(var, Byte.TYPE, Byte.class);
                }
                case SHORT: {
                    return this.unbox(var, Short.TYPE, Short.class);
                }
                case CHARACTER: {
                    return this.unbox(var, Character.TYPE, Character.class);
                }
                case INTEGER: {
                    return this.unbox(var, Integer.TYPE, Integer.class);
                }
                case LONG: {
                    return this.unbox(var, Long.TYPE, Long.class);
                }
                case FLOAT: {
                    return this.unbox(var, Float.TYPE, Float.class);
                }
                case DOUBLE: {
                    return this.unbox(var, Double.TYPE, Double.class);
                }
            }
        } else if (!type.isObject(Object.class)) {
            CastInstruction castInsn = new CastInstruction();
            castInsn.setValue(var);
            castInsn.setReceiver(this.program.createVariable());
            castInsn.setTargetType(type);
            var = castInsn.getReceiver();
            this.add(castInsn);
        }
        return var;
    }

    private Variable unbox(Variable var, Class<?> primitive, Class<?> wrapper) {
        CastInstruction castInsn = new CastInstruction();
        castInsn.setValue(var);
        castInsn.setReceiver(this.program.createVariable());
        castInsn.setTargetType(ValueType.parse(wrapper));
        this.add(castInsn);
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(new MethodReference(wrapper, primitive.getName() + "Value", primitive));
        insn.setType(InvocationType.VIRTUAL);
        insn.setInstance(castInsn.getReceiver());
        var = this.program.createVariable();
        insn.setReceiver(var);
        this.add(insn);
        return var;
    }

    public Program getProgram() {
        return this.program;
    }

    private class TemplateSubstitutor
    implements InstructionReader {
        private int blockOffset;
        private int variableOffset;
        int[] variableMapping;
        CapturedValue[] capturedValues;
        AliasFinder.ArrayElement[] arrayElements;

        TemplateSubstitutor(CapturedValue[] capturedValues, int[] variableMapping, AliasFinder.ArrayElement[] arrayElements, int blockOffset, int variableOffset) {
            this.capturedValues = capturedValues;
            this.variableMapping = variableMapping;
            this.arrayElements = arrayElements;
            this.blockOffset = blockOffset;
            this.variableOffset = variableOffset;
        }

        @Override
        public void location(TextLocation location) {
            CompositeMethodGenerator.this.location = location;
        }

        @Override
        public void nop() {
        }

        public Variable var(VariableReader variable) {
            int arrayVar;
            if (variable == null) {
                return null;
            }
            int index = this.variableMapping[variable.getIndex()];
            if (this.capturedValues[index] != null) {
                return CompositeMethodGenerator.this.captureValue(this.capturedValues[index]);
            }
            AliasFinder.ArrayElement elem = this.arrayElements[index];
            if (elem != null && this.capturedValues[arrayVar = this.variableMapping[elem.array]] != null) {
                Object capturedArray = this.capturedValues[arrayVar].obj;
                boolean primitive = capturedArray.getClass().getComponentType().isPrimitive();
                return CompositeMethodGenerator.this.captureValue(new CapturedValue(Array.get(capturedArray, elem.index), primitive));
            }
            return CompositeMethodGenerator.this.program.variableAt(this.variableOffset + variable.getIndex());
        }

        public BasicBlock block(BasicBlockReader block) {
            if (block == null) {
                return null;
            }
            return CompositeMethodGenerator.this.program.basicBlockAt(this.blockOffset + block.getIndex());
        }

        @Override
        public void classConstant(VariableReader receiver, ValueType cst) {
            ClassConstantInstruction insn = new ClassConstantInstruction();
            insn.setConstant(cst);
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void nullConstant(VariableReader receiver) {
            NullConstantInstruction insn = new NullConstantInstruction();
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void integerConstant(VariableReader receiver, int cst) {
            IntegerConstantInstruction insn = new IntegerConstantInstruction();
            insn.setConstant(cst);
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void longConstant(VariableReader receiver, long cst) {
            LongConstantInstruction insn = new LongConstantInstruction();
            insn.setConstant(cst);
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void floatConstant(VariableReader receiver, float cst) {
            FloatConstantInstruction insn = new FloatConstantInstruction();
            insn.setConstant(cst);
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void doubleConstant(VariableReader receiver, double cst) {
            DoubleConstantInstruction insn = new DoubleConstantInstruction();
            insn.setConstant(cst);
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void stringConstant(VariableReader receiver, String cst) {
            StringConstantInstruction insn = new StringConstantInstruction();
            insn.setConstant(cst);
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void binary(BinaryOperation op, VariableReader receiver, VariableReader first, VariableReader second, NumericOperandType type) {
            BinaryInstruction insn = new BinaryInstruction(op, type);
            insn.setReceiver(this.var(receiver));
            insn.setFirstOperand(this.var(first));
            insn.setSecondOperand(this.var(second));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void negate(VariableReader receiver, VariableReader operand, NumericOperandType type) {
            NegateInstruction insn = new NegateInstruction(type);
            insn.setReceiver(this.var(receiver));
            insn.setOperand(this.var(operand));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void assign(VariableReader receiver, VariableReader assignee) {
            int index = this.variableMapping[assignee.getIndex()];
            if (this.capturedValues[index] != null) {
                return;
            }
            AssignInstruction insn = new AssignInstruction();
            insn.setReceiver(this.var(receiver));
            insn.setAssignee(this.var(assignee));
            if (insn.getReceiver() != insn.getAssignee()) {
                CompositeMethodGenerator.this.add(insn);
            }
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, ValueType targetType, boolean weak) {
            CastInstruction insn = new CastInstruction();
            insn.setTargetType(targetType);
            insn.setValue(this.var(value));
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, NumericOperandType sourceType, NumericOperandType targetType) {
            CastNumberInstruction insn = new CastNumberInstruction(sourceType, targetType);
            insn.setValue(this.var(value));
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, IntegerSubtype type, CastIntegerDirection targetType) {
            CastIntegerInstruction insn = new CastIntegerInstruction(type, targetType);
            insn.setValue(this.var(value));
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void jumpIf(BranchingCondition cond, VariableReader operand, BasicBlockReader consequent, BasicBlockReader alternative) {
            BranchingInstruction insn = new BranchingInstruction(cond);
            insn.setOperand(this.var(operand));
            insn.setConsequent(this.block(consequent));
            insn.setAlternative(this.block(alternative));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void jumpIf(BinaryBranchingCondition cond, VariableReader first, VariableReader second, BasicBlockReader consequent, BasicBlockReader alternative) {
            BinaryBranchingInstruction insn = new BinaryBranchingInstruction(cond);
            insn.setFirstOperand(this.var(first));
            insn.setSecondOperand(this.var(second));
            insn.setConsequent(this.block(consequent));
            insn.setAlternative(this.block(alternative));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void jump(BasicBlockReader target) {
            JumpInstruction insn = new JumpInstruction();
            insn.setTarget(this.block(target));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void choose(VariableReader condition, List<? extends SwitchTableEntryReader> table, BasicBlockReader defaultTarget) {
            SwitchInstruction insn = new SwitchInstruction();
            insn.setCondition(this.var(condition));
            insn.setDefaultTarget(this.block(defaultTarget));
            for (SwitchTableEntryReader switchTableEntryReader : table) {
                SwitchTableEntry insnEntry = new SwitchTableEntry();
                insnEntry.setCondition(switchTableEntryReader.getCondition());
                insnEntry.setTarget(this.block(switchTableEntryReader.getTarget()));
                insn.getEntries().add(insnEntry);
            }
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void exit(VariableReader valueToReturn) {
            BasicBlock target = CompositeMethodGenerator.this.program.basicBlockAt(CompositeMethodGenerator.this.returnBlockIndex);
            if (valueToReturn != null) {
                Variable valueToReturnResolved = this.var(valueToReturn);
                if (CompositeMethodGenerator.this.resultVar == null) {
                    CompositeMethodGenerator.this.resultVar = CompositeMethodGenerator.this.program.createVariable();
                    CompositeMethodGenerator.this.resultPhi = new Phi();
                    CompositeMethodGenerator.this.resultPhi.setReceiver(CompositeMethodGenerator.this.resultVar);
                    target.getPhis().add(CompositeMethodGenerator.this.resultPhi);
                }
                Incoming incoming = new Incoming();
                incoming.setSource(CompositeMethodGenerator.this.program.basicBlockAt(CompositeMethodGenerator.this.blockIndex));
                incoming.setValue(valueToReturnResolved);
                CompositeMethodGenerator.this.resultPhi.getIncomings().add(incoming);
            }
            JumpInstruction insn = new JumpInstruction();
            insn.setTarget(target);
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void raise(VariableReader exception) {
            RaiseInstruction insn = new RaiseInstruction();
            insn.setException(this.var(exception));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, VariableReader size) {
            ConstructArrayInstruction insn = new ConstructArrayInstruction();
            insn.setReceiver(this.var(receiver));
            insn.setItemType(itemType);
            insn.setSize(this.var(size));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, List<? extends VariableReader> dimensions) {
            ConstructMultiArrayInstruction insn = new ConstructMultiArrayInstruction();
            insn.setReceiver(this.var(receiver));
            insn.setItemType(itemType);
            insn.getDimensions().addAll(dimensions.stream().map(this::var).collect(Collectors.toList()));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void create(VariableReader receiver, String type) {
            ConstructInstruction insn = new ConstructInstruction();
            insn.setReceiver(this.var(receiver));
            insn.setType(type);
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void getField(VariableReader receiver, VariableReader instance, FieldReference field, ValueType fieldType) {
            GetFieldInstruction insn = new GetFieldInstruction();
            insn.setField(field);
            insn.setFieldType(fieldType);
            insn.setInstance(this.var(instance));
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void putField(VariableReader instance, FieldReference field, VariableReader value, ValueType fieldType) {
            PutFieldInstruction insn = new PutFieldInstruction();
            insn.setField(field);
            insn.setFieldType(fieldType);
            insn.setInstance(this.var(instance));
            insn.setValue(this.var(value));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void arrayLength(VariableReader receiver, VariableReader array) {
            ArrayLengthInstruction insn = new ArrayLengthInstruction();
            insn.setArray(this.var(array));
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void cloneArray(VariableReader receiver, VariableReader array) {
            CloneArrayInstruction insn = new CloneArrayInstruction();
            insn.setArray(this.var(array));
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void unwrapArray(VariableReader receiver, VariableReader array, ArrayElementType elementType) {
            int arrayIndex = this.variableMapping[array.getIndex()];
            if (this.capturedValues[arrayIndex] != null) {
                return;
            }
            UnwrapArrayInstruction insn = new UnwrapArrayInstruction(elementType);
            insn.setArray(this.var(array));
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void getElement(VariableReader receiver, VariableReader array, VariableReader index, ArrayElementType type) {
            int arrayIndex = this.variableMapping[array.getIndex()];
            AliasFinder.ArrayElement elem = this.arrayElements[receiver.getIndex()];
            if (elem != null && this.capturedValues[arrayIndex] != null) {
                AssignInstruction insn = new AssignInstruction();
                insn.setAssignee(this.var(receiver));
                insn.setReceiver(CompositeMethodGenerator.this.program.variableAt(this.variableOffset + receiver.getIndex()));
                CompositeMethodGenerator.this.add(insn);
                return;
            }
            GetElementInstruction insn = new GetElementInstruction(type);
            insn.setArray(this.var(array));
            insn.setIndex(this.var(index));
            insn.setReceiver(this.var(receiver));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void putElement(VariableReader array, VariableReader index, VariableReader value, ArrayElementType type) {
            PutElementInstruction insn = new PutElementInstruction(type);
            insn.setArray(this.var(array));
            insn.setIndex(this.var(index));
            insn.setValue(this.var(value));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void invoke(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments, InvocationType type) {
            if (type == InvocationType.VIRTUAL && instance != null) {
                if (method.getClassName().equals(Value.class.getName())) {
                    if (method.getName().equals("get")) {
                        if (receiver != null) {
                            AssignInstruction insn = new AssignInstruction();
                            insn.setReceiver(this.var(receiver));
                            insn.setAssignee(this.var(instance));
                            CompositeMethodGenerator.this.add(insn);
                        } else {
                            this.var(instance);
                        }
                        return;
                    }
                    CompositeMethodGenerator.this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, CompositeMethodGenerator.this.location), "Can't call method {{m0}} in runtime domain", method);
                } else if (method.getClassName().equals(ReflectField.class.getName()) ? this.replaceFieldGetSet(receiver, instance, method, arguments) : (method.getClassName().equals(ReflectMethod.class.getName()) ? this.replaceMethodInvocation(receiver, instance, method, arguments) : method.getClassName().equals(ReflectClass.class.getName()) && this.replaceClassInvocation(receiver, instance, method, arguments))) {
                    return;
                }
            }
            InvokeInstruction insn = new InvokeInstruction();
            insn.setInstance(this.var(instance));
            insn.setReceiver(this.var(receiver));
            insn.setMethod(method);
            insn.setType(type);
            insn.setArguments((Variable[])arguments.stream().map(this::var).toArray(Variable[]::new));
            CompositeMethodGenerator.this.add(insn);
        }

        private boolean replaceFieldGetSet(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments) {
            int instanceIndex = this.variableMapping[instance.getIndex()];
            if (this.capturedValues[instanceIndex] == null) {
                CompositeMethodGenerator.this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, CompositeMethodGenerator.this.location), "Can call {{m0}} method only on a reflected field captured by lambda from outer context", method);
                return false;
            }
            Object value = this.capturedValues[instanceIndex].obj;
            if (!(value instanceof ReflectFieldImpl)) {
                CompositeMethodGenerator.this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, CompositeMethodGenerator.this.location), "Wrong call to {{m0}} method ", method);
                return false;
            }
            ReflectFieldImpl field = (ReflectFieldImpl)value;
            switch (method.getName()) {
                case "get": {
                    Variable var = CompositeMethodGenerator.this.program.createVariable();
                    GetFieldInstruction insn = new GetFieldInstruction();
                    if (!field.field.hasModifier(ElementModifier.STATIC)) {
                        CastInstruction cast = new CastInstruction();
                        cast.setReceiver(CompositeMethodGenerator.this.program.createVariable());
                        cast.setValue(this.var(arguments.get(0)));
                        cast.setWeak(true);
                        cast.setTargetType(ValueType.object(field.field.getOwnerName()));
                        CompositeMethodGenerator.this.add(cast);
                        insn.setInstance(cast.getReceiver());
                    }
                    insn.setReceiver(var);
                    insn.setField(field.getBackingField().getReference());
                    insn.setFieldType(field.getBackingField().getType());
                    CompositeMethodGenerator.this.add(insn);
                    var = CompositeMethodGenerator.this.box(var, field.getBackingField().getType());
                    AssignInstruction assign = new AssignInstruction();
                    assign.setAssignee(var);
                    assign.setReceiver(this.var(receiver));
                    CompositeMethodGenerator.this.add(assign);
                    return true;
                }
                case "set": {
                    PutFieldInstruction insn = new PutFieldInstruction();
                    if (!field.field.hasModifier(ElementModifier.STATIC)) {
                        CastInstruction cast = new CastInstruction();
                        cast.setReceiver(CompositeMethodGenerator.this.program.createVariable());
                        cast.setValue(this.var(arguments.get(0)));
                        cast.setWeak(true);
                        cast.setTargetType(ValueType.object(field.field.getOwnerName()));
                        CompositeMethodGenerator.this.add(cast);
                        insn.setInstance(cast.getReceiver());
                    }
                    insn.setValue(CompositeMethodGenerator.this.unbox(this.var(arguments.get(1)), field.getBackingField().getType()));
                    insn.setField(field.getBackingField().getReference());
                    insn.setFieldType(field.getBackingField().getType());
                    CompositeMethodGenerator.this.add(insn);
                    return true;
                }
            }
            CompositeMethodGenerator.this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, CompositeMethodGenerator.this.location), "Can only call {{m0}} method from runtime domain", method);
            return false;
        }

        private boolean replaceMethodInvocation(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments) {
            int instanceIndex = this.variableMapping[instance.getIndex()];
            if (this.capturedValues[instanceIndex] == null) {
                CompositeMethodGenerator.this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, CompositeMethodGenerator.this.location), "Can call {{m0}} method only on a reflected field captured by lambda from outer context", method);
                return false;
            }
            Object value = this.capturedValues[instanceIndex].obj;
            if (!(value instanceof ReflectMethodImpl)) {
                CompositeMethodGenerator.this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, CompositeMethodGenerator.this.location), "Wrong call to {{m0}} method ", method);
                return false;
            }
            ReflectMethodImpl reflectMethod = (ReflectMethodImpl)value;
            switch (method.getName()) {
                case "invoke": {
                    InvokeInstruction insn = new InvokeInstruction();
                    if (!Modifier.isStatic(reflectMethod.getModifiers())) {
                        CastInstruction cast = new CastInstruction();
                        cast.setReceiver(CompositeMethodGenerator.this.program.createVariable());
                        cast.setValue(this.var(arguments.get(0)));
                        cast.setWeak(true);
                        cast.setTargetType(ValueType.object(reflectMethod.method.getOwnerName()));
                        CompositeMethodGenerator.this.add(cast);
                        insn.setInstance(cast.getReceiver());
                    }
                    insn.setType(Modifier.isStatic(reflectMethod.getModifiers()) ? InvocationType.SPECIAL : InvocationType.VIRTUAL);
                    insn.setMethod(reflectMethod.method.getReference());
                    insn.setArguments(this.emitArguments(this.var(arguments.get(1)), reflectMethod));
                    CompositeMethodGenerator.this.add(insn);
                    if (receiver != null) {
                        if (reflectMethod.method.getResultType() == ValueType.VOID) {
                            NullConstantInstruction nullInsn = new NullConstantInstruction();
                            nullInsn.setReceiver(this.var(receiver));
                            CompositeMethodGenerator.this.add(nullInsn);
                        } else {
                            Variable var = CompositeMethodGenerator.this.program.createVariable();
                            insn.setReceiver(var);
                            var = CompositeMethodGenerator.this.box(var, reflectMethod.method.getResultType());
                            AssignInstruction assign = new AssignInstruction();
                            assign.setAssignee(var);
                            assign.setReceiver(this.var(receiver));
                            CompositeMethodGenerator.this.add(assign);
                        }
                    }
                    return true;
                }
                case "construct": {
                    ConstructInstruction constructInsn = new ConstructInstruction();
                    constructInsn.setReceiver(receiver != null ? this.var(receiver) : CompositeMethodGenerator.this.program.createVariable());
                    constructInsn.setType(reflectMethod.method.getOwnerName());
                    CompositeMethodGenerator.this.add(constructInsn);
                    InvokeInstruction insn = new InvokeInstruction();
                    insn.setInstance(constructInsn.getReceiver());
                    insn.setType(InvocationType.SPECIAL);
                    insn.setMethod(reflectMethod.method.getReference());
                    insn.setArguments(this.emitArguments(this.var(arguments.get(0)), reflectMethod));
                    CompositeMethodGenerator.this.add(insn);
                    return true;
                }
            }
            CompositeMethodGenerator.this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, CompositeMethodGenerator.this.location), "Can only call {{m0}} method from runtime domain", method);
            return false;
        }

        private boolean replaceClassInvocation(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments) {
            int instanceIndex = this.variableMapping[instance.getIndex()];
            if (this.capturedValues[instanceIndex] == null) {
                CompositeMethodGenerator.this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, CompositeMethodGenerator.this.location), "Can call {{m0}} method only on a reflected class captured by lambda from outer context", method);
                return false;
            }
            Object value = this.capturedValues[instanceIndex].obj;
            if (!(value instanceof ReflectClassImpl)) {
                CompositeMethodGenerator.this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, CompositeMethodGenerator.this.location), "Wrong call to {{m0}} method ", method);
                return false;
            }
            ReflectClassImpl reflectClass = (ReflectClassImpl)value;
            switch (method.getName()) {
                case "isInstance": {
                    IsInstanceInstruction insn = new IsInstanceInstruction();
                    insn.setReceiver(receiver != null ? this.var(receiver) : CompositeMethodGenerator.this.program.createVariable());
                    insn.setValue(this.var(arguments.get(0)));
                    insn.setType(reflectClass.type);
                    CompositeMethodGenerator.this.add(insn);
                    return true;
                }
                case "cast": {
                    CastInstruction insn = new CastInstruction();
                    insn.setReceiver(receiver != null ? this.var(receiver) : CompositeMethodGenerator.this.program.createVariable());
                    insn.setValue(this.var(arguments.get(0)));
                    insn.setTargetType(reflectClass.type);
                    CompositeMethodGenerator.this.add(insn);
                    return true;
                }
                case "asJavaClass": {
                    ClassConstantInstruction insn = new ClassConstantInstruction();
                    insn.setReceiver(receiver != null ? this.var(receiver) : CompositeMethodGenerator.this.program.createVariable());
                    insn.setConstant(reflectClass.type);
                    CompositeMethodGenerator.this.add(insn);
                    return true;
                }
                case "createArray": {
                    ConstructArrayInstruction insn = new ConstructArrayInstruction();
                    insn.setItemType(reflectClass.type);
                    insn.setSize(this.var(arguments.get(0)));
                    insn.setReceiver(receiver != null ? this.var(receiver) : CompositeMethodGenerator.this.program.createVariable());
                    CompositeMethodGenerator.this.add(insn);
                    return true;
                }
                case "getArrayLength": {
                    ArrayLengthInstruction insn = new ArrayLengthInstruction();
                    insn.setArray(this.unwrapArray(reflectClass.type, this.var(arguments.get(0))));
                    insn.setReceiver(receiver != null ? this.var(receiver) : CompositeMethodGenerator.this.program.createVariable());
                    CompositeMethodGenerator.this.add(insn);
                    return true;
                }
                case "getArrayElement": {
                    GetElementInstruction insn = new GetElementInstruction(this.asArrayType(reflectClass.type));
                    insn.setArray(this.unwrapArray(reflectClass.type, this.var(arguments.get(0))));
                    insn.setIndex(this.var(arguments.get(1)));
                    insn.setReceiver(CompositeMethodGenerator.this.program.createVariable());
                    CompositeMethodGenerator.this.add(insn);
                    AssignInstruction assign = new AssignInstruction();
                    assign.setAssignee(CompositeMethodGenerator.this.box(insn.getReceiver(), ((ValueType.Array)reflectClass.type).getItemType()));
                    assign.setReceiver(receiver != null ? this.var(receiver) : CompositeMethodGenerator.this.program.createVariable());
                    CompositeMethodGenerator.this.add(assign);
                    return true;
                }
            }
            CompositeMethodGenerator.this.diagnostics.error(new CallLocation(MetaprogrammingImpl.templateMethod, CompositeMethodGenerator.this.location), "Can only call {{m0}} method from runtime domain", method);
            return false;
        }

        private Variable[] emitArguments(Variable argumentsVar, ReflectMethodImpl reflectMethod) {
            UnwrapArrayInstruction unwrapInsn = new UnwrapArrayInstruction(ArrayElementType.OBJECT);
            unwrapInsn.setArray(argumentsVar);
            unwrapInsn.setReceiver(CompositeMethodGenerator.this.program.createVariable());
            CompositeMethodGenerator.this.add(unwrapInsn);
            argumentsVar = unwrapInsn.getReceiver();
            Variable[] arguments = new Variable[reflectMethod.getParameterCount()];
            for (int i = 0; i < reflectMethod.getParameterCount(); ++i) {
                IntegerConstantInstruction indexInsn = new IntegerConstantInstruction();
                indexInsn.setConstant(i);
                indexInsn.setReceiver(CompositeMethodGenerator.this.program.createVariable());
                CompositeMethodGenerator.this.add(indexInsn);
                GetElementInstruction extractArgInsn = new GetElementInstruction(ArrayElementType.OBJECT);
                extractArgInsn.setArray(argumentsVar);
                extractArgInsn.setIndex(indexInsn.getReceiver());
                extractArgInsn.setReceiver(CompositeMethodGenerator.this.program.createVariable());
                CompositeMethodGenerator.this.add(extractArgInsn);
                arguments[i] = CompositeMethodGenerator.this.unbox(extractArgInsn.getReceiver(), reflectMethod.method.parameterType(i));
            }
            return arguments;
        }

        private Variable unwrapArray(ValueType type, Variable array) {
            CastInstruction cast = new CastInstruction();
            cast.setTargetType(type);
            cast.setValue(array);
            cast.setReceiver(CompositeMethodGenerator.this.program.createVariable());
            CompositeMethodGenerator.this.add(cast);
            UnwrapArrayInstruction unwrap = new UnwrapArrayInstruction(this.asArrayType(type));
            unwrap.setArray(cast.getReceiver());
            unwrap.setReceiver(CompositeMethodGenerator.this.program.createVariable());
            CompositeMethodGenerator.this.add(unwrap);
            return unwrap.getReceiver();
        }

        private ArrayElementType asArrayType(ValueType type) {
            if (type instanceof ValueType.Primitive) {
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: 
                    case BYTE: {
                        return ArrayElementType.BYTE;
                    }
                    case SHORT: {
                        return ArrayElementType.SHORT;
                    }
                    case CHARACTER: {
                        return ArrayElementType.CHAR;
                    }
                    case INTEGER: {
                        return ArrayElementType.INT;
                    }
                    case LONG: {
                        return ArrayElementType.LONG;
                    }
                    case FLOAT: {
                        return ArrayElementType.FLOAT;
                    }
                    case DOUBLE: {
                        return ArrayElementType.DOUBLE;
                    }
                }
            }
            return ArrayElementType.OBJECT;
        }

        @Override
        public void invokeDynamic(VariableReader receiver, VariableReader instance, MethodDescriptor method, List<? extends VariableReader> arguments, MethodHandle bootstrapMethod, List<RuntimeConstant> bootstrapArguments) {
            InvokeDynamicInstruction insn = new InvokeDynamicInstruction();
            insn.setBootstrapMethod(bootstrapMethod);
            insn.setInstance(this.var(instance));
            insn.setReceiver(this.var(receiver));
            insn.setMethod(method);
            insn.getArguments().addAll(arguments.stream().map(this::var).collect(Collectors.toList()));
            insn.getBootstrapArguments().addAll(bootstrapArguments);
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void isInstance(VariableReader receiver, VariableReader value, ValueType type) {
            IsInstanceInstruction insn = new IsInstanceInstruction();
            insn.setReceiver(this.var(receiver));
            insn.setValue(this.var(value));
            insn.setType(type);
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void initClass(String className) {
            InitClassInstruction insn = new InitClassInstruction();
            insn.setClassName(className);
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void nullCheck(VariableReader receiver, VariableReader value) {
            NullCheckInstruction insn = new NullCheckInstruction();
            insn.setReceiver(this.var(receiver));
            insn.setValue(this.var(value));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void monitorEnter(VariableReader objectRef) {
            MonitorEnterInstruction insn = new MonitorEnterInstruction();
            insn.setObjectRef(this.var(objectRef));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void monitorExit(VariableReader objectRef) {
            MonitorExitInstruction insn = new MonitorExitInstruction();
            insn.setObjectRef(this.var(objectRef));
            CompositeMethodGenerator.this.add(insn);
        }

        @Override
        public void boundCheck(VariableReader receiver, VariableReader index, VariableReader array, boolean lower) {
            BoundCheckInstruction instruction = new BoundCheckInstruction();
            instruction.setReceiver(this.var(receiver));
            instruction.setIndex(this.var(index));
            if (array != null) {
                instruction.setArray(this.var(array));
            }
            instruction.setLower(lower);
            CompositeMethodGenerator.this.add(instruction);
        }
    }
}

