/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.MethodDependency;
import org.teavm.jso.impl.JS;
import org.teavm.jso.impl.JSBodyDelegate;
import org.teavm.jso.impl.JSMethods;
import org.teavm.jso.impl.wasmgc.WasmGCExceptionWrapper;
import org.teavm.jso.impl.wasmgc.WasmGCJSConstants;
import org.teavm.jso.impl.wasmgc.WasmGCJSRuntime;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

class WasmGCJSDependencies
extends AbstractDependencyListener {
    WasmGCJSDependencies() {
    }

    @Override
    public void started(DependencyAgent agent) {
        this.reachUtilities(agent);
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        MethodReader methodReader = method.getMethod();
        if (methodReader.getOwnerName().equals(JS.class.getName())) {
            switch (methodReader.getName()) {
                case "jsArrayItem": {
                    method.getVariable(1).getArrayItem().connect(method.getResult());
                    break;
                }
                case "invoke": 
                case "apply": 
                case "construct": 
                case "get": 
                case "getPure": 
                case "set": 
                case "setPure": 
                case "global": {
                    method.getThrown().propagate(agent.getType(ValueType.object(WasmGCExceptionWrapper.class.getName())));
                }
            }
        } else if (methodReader.getOwnerName().equals("org.teavm.jso.impl.JSWrapper")) {
            if (methodReader.getName().equals("wrap")) {
                agent.linkMethod(new MethodReference("org.teavm.jso.impl.JSWrapper", "createWrapper", JSMethods.JS_OBJECT, JSMethods.OBJECT)).use();
            }
        } else if (methodReader.getAnnotations().get(JSBodyDelegate.class.getName()) != null) {
            method.getThrown().propagate(agent.getType(ValueType.object(WasmGCExceptionWrapper.class.getName())));
        } else if (methodReader.getOwnerName().equals(WasmGCJSRuntime.CharArrayData.class.getName()) && method.getMethod().getName().equals("asString")) {
            method.getResult().propagate(agent.getType(ValueType.object(String.class.getName())));
            agent.linkMethod(new MethodReference(String.class, "fromArray", char[].class, String.class)).use();
        }
    }

    private void reachUtilities(DependencyAgent agent) {
        agent.linkMethod(WasmGCJSConstants.STRING_TO_JS).propagate(1, agent.getType(ValueType.object("java.lang.String"))).use();
        MethodDependency jsToString = agent.linkMethod(WasmGCJSConstants.JS_TO_STRING);
        jsToString.getResult().propagate(agent.getType(ValueType.object("java.lang.String")));
        jsToString.use();
        agent.linkMethod(new MethodReference("org.teavm.jso.impl.wasmgc.WasmGCJSRuntime", "wrapException", JSMethods.JS_OBJECT, ValueType.object("java.lang.Throwable"))).use();
        agent.linkMethod(new MethodReference("org.teavm.jso.impl.wasmgc.WasmGCJSRuntime", "extractException", ValueType.object("java.lang.Throwable"), JSMethods.JS_OBJECT)).use();
    }
}

