/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import org.teavm.ast.Expr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.jso.impl.JSBodyEmitter;
import org.teavm.jso.impl.wasmgc.WasmGCJSFunctions;
import org.teavm.jso.impl.wasmgc.WasmGCJsoCommonGenerator;
import org.teavm.jso.impl.wasmgc.WasmGCJsoContext;
import org.teavm.model.ValueType;

class WasmGCBodyIntrinsic
implements WasmGCIntrinsic {
    private JSBodyEmitter emitter;
    private boolean inlined;
    private WasmGCJsoCommonGenerator commonGen;
    private WasmGlobal global;
    private WasmGCJSFunctions jsFunctions;

    WasmGCBodyIntrinsic(JSBodyEmitter emitter, boolean inlined, WasmGCJsoCommonGenerator commonGen, WasmGCJSFunctions jsFunctions) {
        this.emitter = emitter;
        this.inlined = inlined;
        this.commonGen = commonGen;
        this.jsFunctions = jsFunctions;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmGCJsoContext jsoContext = WasmGCJsoContext.wrap(context);
        if (this.global == null) {
            this.global = this.commonGen.addJSBody(jsoContext, this.emitter, this.inlined);
        }
        WasmCall call = new WasmCall(this.jsFunctions.getFunctionCaller(jsoContext, invocation.getArguments().size()));
        call.getArguments().add(new WasmGetGlobal(this.global));
        for (Expr arg : invocation.getArguments()) {
            call.getArguments().add(context.generate(arg));
        }
        WasmExpression result = call;
        if (invocation.getMethod().getReturnType() == ValueType.VOID) {
            result = new WasmDrop(result);
        }
        return result;
    }
}

