/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import org.teavm.backend.javascript.TeaVMJavaScriptHost;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.wasm.gc.TeaVMWasmGCHost;
import org.teavm.interop.PlatformMarker;
import org.teavm.jso.impl.DynamicGenerator;
import org.teavm.jso.impl.DynamicInjector;
import org.teavm.jso.impl.GeneratorAnnotationInstaller;
import org.teavm.jso.impl.JS;
import org.teavm.jso.impl.JSAliasRenderer;
import org.teavm.jso.impl.JSBodyGenerator;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSDependencyListener;
import org.teavm.jso.impl.JSExceptionsDependencyListener;
import org.teavm.jso.impl.JSExceptionsGenerator;
import org.teavm.jso.impl.JSExportedMethodAsFunction;
import org.teavm.jso.impl.JSMethods;
import org.teavm.jso.impl.JSObjectClassTransformer;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.jso.impl.JSWrapperDependency;
import org.teavm.jso.impl.JSWrapperGenerator;
import org.teavm.jso.impl.wasmgc.WasmGCJso;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.plugin.PlatformPlugin;
import org.teavm.vm.TeaVMPluginUtil;
import org.teavm.vm.spi.After;
import org.teavm.vm.spi.ClassFilter;
import org.teavm.vm.spi.ClassFilterContext;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMPlugin;

@After(value={PlatformPlugin.class})
public class JSOPlugin
implements TeaVMPlugin {
    @Override
    public void install(TeaVMHost host) {
        TeaVMJavaScriptHost jsHost = host.getExtension(TeaVMJavaScriptHost.class);
        TeaVMWasmGCHost wasmGCHost = host.getExtension(TeaVMWasmGCHost.class);
        if (jsHost == null && wasmGCHost == null) {
            return;
        }
        JSBodyRepository repository = new JSBodyRepository();
        host.registerService(JSBodyRepository.class, repository);
        JSObjectClassTransformer classTransformer = new JSObjectClassTransformer(repository);
        host.add(classTransformer);
        JSDependencyListener dependencyListener = new JSDependencyListener(repository);
        host.add(dependencyListener);
        host.add(new JSExceptionsDependencyListener());
        host.addClassFilter(new ClassFilter(){
            JSTypeHelper helper;

            @Override
            public boolean accept(ClassFilterContext context, ValueType type) {
                if (!(type instanceof ValueType.Object)) {
                    return true;
                }
                String className = ((ValueType.Object)type).getClassName();
                if (this.helper == null) {
                    this.helper = new JSTypeHelper(context.classes());
                }
                return !this.helper.isJavaScriptClass(className) || this.helper.isJavaScriptImplementation(className);
            }
        });
        JSWrapperDependency wrapperDependency = new JSWrapperDependency();
        host.add(wrapperDependency);
        if (!JSOPlugin.isBootstrap()) {
            TeaVMPluginUtil.handleNatives(host, JS.class);
        }
        if (jsHost != null) {
            this.installForJS(jsHost);
        }
        if (wasmGCHost != null) {
            classTransformer.setClassFilter(n -> !n.startsWith("java."));
            classTransformer.forWasmGC();
            WasmGCJso.install(host, wasmGCHost, repository);
        }
    }

    private void installForJS(TeaVMJavaScriptHost jsHost) {
        JSAliasRenderer aliasRenderer = new JSAliasRenderer();
        jsHost.add(aliasRenderer);
        jsHost.addGeneratorProvider(new GeneratorAnnotationInstaller<Generator>(new JSBodyGenerator(), DynamicGenerator.class.getName()));
        jsHost.addInjectorProvider(new GeneratorAnnotationInstaller<Injector>(new JSBodyGenerator(), DynamicInjector.class.getName()));
        jsHost.addVirtualMethods(aliasRenderer);
        jsHost.addForcedFunctionMethods(new JSExportedMethodAsFunction());
        JSExceptionsGenerator exceptionsGenerator = new JSExceptionsGenerator();
        jsHost.add(new MethodReference("org.teavm.jso.JSExceptions", "getJavaException", JSMethods.JS_OBJECT, ValueType.object("java.lang.Throwable")), exceptionsGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.JSExceptions", "getJSException", ValueType.object("java.lang.Throwable"), JSMethods.JS_OBJECT), exceptionsGenerator);
        JSWrapperGenerator wrapperGenerator = new JSWrapperGenerator();
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "directJavaToJs", JSMethods.OBJECT, JSMethods.JS_OBJECT), wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "directJsToJava", JSMethods.JS_OBJECT, JSMethods.OBJECT), wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "dependencyJavaToJs", JSMethods.OBJECT, JSMethods.JS_OBJECT), wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "dependencyJsToJava", JSMethods.JS_OBJECT, JSMethods.OBJECT), wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "marshallJavaToJs", JSMethods.OBJECT, JSMethods.JS_OBJECT), wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "unmarshallJavaFromJs", JSMethods.JS_OBJECT, JSMethods.OBJECT), wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "isJava", JSMethods.OBJECT, ValueType.BOOLEAN), wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "isJava", JSMethods.JS_OBJECT, ValueType.BOOLEAN), wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "wrapperToJs", JSMethods.JS_WRAPPER, JSMethods.JS_OBJECT), wrapperGenerator);
        jsHost.add(new MethodReference("org.teavm.jso.impl.JSWrapper", "jsToWrapper", JSMethods.JS_OBJECT, JSMethods.JS_WRAPPER), wrapperGenerator);
    }

    @PlatformMarker
    private static boolean isBootstrap() {
        return false;
    }
}

