/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc.sorting;

import java.util.function.IntBinaryOperator;

public final class QuickSort {
    static final int INSERTION_SORT_THRESHOLD = 16;
    static final int SINGLE_MEDIAN_THRESHOLD = 40;

    private QuickSort() {
    }

    public static void sort(int[] array, IntBinaryOperator comparator) {
        QuickSort.sort(array, 0, array.length, comparator);
    }

    public static void sort(int[] array, int fromIndex, int toIndex, IntBinaryOperator comparator) {
        QuickSort.sort(fromIndex, toIndex, comparator, (int i, int j) -> {
            int swap = array[i];
            array[i] = array[j];
            array[j] = swap;
            return 0;
        });
    }

    public static void sort(int fromIndex, int toIndex, IntBinaryOperator comparator, IntBinaryOperator swapper) {
        int size;
        while ((size = toIndex - fromIndex) > 16) {
            int pivot;
            int range;
            int last = toIndex - 1;
            int middle = fromIndex + last >>> 1;
            if (size <= 40) {
                range = size >> 2;
                pivot = QuickSort.median(middle - range, middle, middle + range, comparator);
            } else {
                range = size >> 3;
                int doubleRange = range << 1;
                int medianStart = QuickSort.median(fromIndex, fromIndex + range, fromIndex + doubleRange, comparator);
                int medianMiddle = QuickSort.median(middle - range, middle, middle + range, comparator);
                int medianEnd = QuickSort.median(last - doubleRange, last - range, last, comparator);
                pivot = QuickSort.median(medianStart, medianMiddle, medianEnd, comparator);
            }
            QuickSort.swap(fromIndex, pivot, swapper);
            int i = fromIndex;
            int j = toIndex;
            int p = fromIndex + 1;
            int q = last;
            while (true) {
                int rightCmp;
                int leftCmp;
                if ((leftCmp = QuickSort.compare(++i, fromIndex, comparator)) < 0) {
                    continue;
                }
                while ((rightCmp = QuickSort.compare(--j, fromIndex, comparator)) > 0) {
                }
                if (i >= j) {
                    if (i != j || rightCmp != 0) break;
                    QuickSort.swap(i, p, swapper);
                    break;
                }
                QuickSort.swap(i, j, swapper);
                if (rightCmp == 0) {
                    QuickSort.swap(i, p++, swapper);
                }
                if (leftCmp != 0) continue;
                QuickSort.swap(j, q--, swapper);
            }
            i = j + 1;
            int k = fromIndex;
            while (k < p) {
                QuickSort.swap(k++, j--, swapper);
            }
            k = last;
            while (k > q) {
                QuickSort.swap(k--, i++, swapper);
            }
            if (j - fromIndex < last - i) {
                QuickSort.sort(fromIndex, j + 1, comparator, swapper);
                fromIndex = i;
                continue;
            }
            QuickSort.sort(i, toIndex, comparator, swapper);
            toIndex = j + 1;
        }
        QuickSort.insertionSort(fromIndex, toIndex, comparator, swapper);
    }

    private static void insertionSort(int fromIndex, int toIndex, IntBinaryOperator comparator, IntBinaryOperator swapper) {
        int i = fromIndex + 1;
        block0: while (i < toIndex) {
            int previous;
            int current = i++;
            while (QuickSort.compare(previous = current - 1, current, comparator) > 0) {
                QuickSort.swap(previous, current, swapper);
                if (previous == fromIndex) continue block0;
                current = previous;
            }
        }
    }

    private static int median(int i, int j, int k, IntBinaryOperator comparator) {
        if (QuickSort.compare(i, j, comparator) < 0) {
            if (QuickSort.compare(j, k, comparator) <= 0) {
                return j;
            }
            return QuickSort.compare(i, k, comparator) < 0 ? k : i;
        }
        if (QuickSort.compare(j, k, comparator) >= 0) {
            return j;
        }
        return QuickSort.compare(i, k, comparator) < 0 ? i : k;
    }

    private static int compare(int i, int j, IntBinaryOperator comparator) {
        return comparator.applyAsInt(i, j);
    }

    private static void swap(int i, int j, IntBinaryOperator swapper) {
        swapper.applyAsInt(i, j);
    }
}

