/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.util.Iterator;
import java.util.function.IntBinaryOperator;
import org.teavm.hppc.AbstractByteCollection;
import org.teavm.hppc.AbstractIterator;
import org.teavm.hppc.AbstractLongCollection;
import org.teavm.hppc.ByteContainer;
import org.teavm.hppc.LongByteAssociativeContainer;
import org.teavm.hppc.LongByteHashMap;
import org.teavm.hppc.LongByteMap;
import org.teavm.hppc.LongCollection;
import org.teavm.hppc.LongContainer;
import org.teavm.hppc.LongLookupContainer;
import org.teavm.hppc.comparators.LongByteComparator;
import org.teavm.hppc.comparators.LongComparator;
import org.teavm.hppc.cursors.ByteCursor;
import org.teavm.hppc.cursors.LongByteCursor;
import org.teavm.hppc.cursors.LongCursor;
import org.teavm.hppc.predicates.BytePredicate;
import org.teavm.hppc.predicates.LongBytePredicate;
import org.teavm.hppc.predicates.LongPredicate;
import org.teavm.hppc.procedures.ByteProcedure;
import org.teavm.hppc.procedures.LongByteProcedure;
import org.teavm.hppc.procedures.LongProcedure;
import org.teavm.hppc.sorting.QuickSort;

public class SortedIterationLongByteHashMap
implements LongByteMap {
    public final LongByteHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationLongByteHashMap(LongByteHashMap delegate, LongComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationLongByteHashMap(LongByteHashMap delegate, LongByteComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        long[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0L) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, LongComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            long[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final LongByteComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final long[] keys;
            final byte[] values;
            {
                this.keys = SortedIterationLongByteHashMap.this.delegate.keys;
                this.values = SortedIterationLongByteHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<LongByteCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(LongContainer container) {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongBytePredicate predicate) {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public <T extends LongByteProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        byte[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends LongBytePredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        byte[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public LongCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ByteContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public byte get(long key) {
        return this.delegate.get(key);
    }

    @Override
    public byte getOrDefault(long key, byte defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public byte put(long key, byte value) {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public int putAll(LongByteAssociativeContainer container) {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends LongByteCursor> iterable) {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public byte putOrAdd(long key, byte putValue, byte incrementValue) {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public byte addTo(long key, byte additionValue) {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public byte remove(long key) {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public int indexOf(long key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public byte indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public byte indexReplace(int index, byte newValue) {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, long key, byte value) {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public byte indexRemove(int index) {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationLongByteHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<LongByteCursor> {
        private final LongByteCursor cursor = new LongByteCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected LongByteCursor fetch() {
            if (this.index < SortedIterationLongByteHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongByteHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationLongByteHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationLongByteHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (LongByteCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final SortedIterationLongByteHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationLongByteHashMap.this;
        }

        @Override
        public boolean contains(long e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationLongByteHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongByteHashMap.readOnlyException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw SortedIterationLongByteHashMap.readOnlyException();
        }

        @Override
        public int removeAll(long e) {
            throw SortedIterationLongByteHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private final SortedIterationLongByteHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationLongByteHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(byte value) {
            for (LongByteCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(byte e) {
            throw SortedIterationLongByteHashMap.readOnlyException();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            throw SortedIterationLongByteHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationLongByteHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongByteHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ByteCursor fetch() {
            if (this.index < SortedIterationLongByteHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongByteHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongByteHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected LongCursor fetch() {
            if (this.index < SortedIterationLongByteHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongByteHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongByteHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

