/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.util.Arrays;
import org.teavm.hppc.Accountable;
import org.teavm.hppc.BoundedProportionalArraySizingStrategy;
import org.teavm.hppc.RamUsageEstimator;

public class PlaModel
implements Accountable {
    private static final int INITIAL_CAPACITY = 256;
    private int epsilon;
    private double firstKey;
    private double previousKey;
    private int numPointsInHull;
    private final Point[] rect = new Point[4];
    private final PointList lower = new PointList(256);
    private final PointList upper = new PointList(256);
    private int lowerStart;
    private int upperStart;
    private final Point point1 = new Point();
    private final Point point2 = new Point();
    private final Slope slope1 = new Slope();
    private final Slope slope2 = new Slope();
    private final Slope slopeTmp = new Slope();
    private final Slope slopeMin = new Slope();
    private final Slope slopeMax = new Slope();

    public PlaModel(int epsilon) {
        this.setEpsilon(epsilon);
        for (int i = 0; i < this.rect.length; ++i) {
            this.rect[i] = new Point();
        }
        this.reset();
    }

    public void setEpsilon(int epsilon) {
        if (epsilon < 0) {
            throw new IllegalArgumentException("epsilon must be >= 0");
        }
        this.epsilon = epsilon;
    }

    private void reset() {
        this.previousKey = Double.NEGATIVE_INFINITY;
        this.numPointsInHull = 0;
        this.lower.clear();
        this.upper.clear();
    }

    public void addKey(double key, int index, SegmentConsumer segmentConsumer) {
        int end;
        int i;
        if (key <= this.previousKey) {
            throw new IllegalArgumentException("Keys must be increasing");
        }
        this.previousKey = key;
        this.point1.set(key, this.addEpsilon(index));
        this.point2.set(key, this.subtractEpsilon(index));
        if (this.numPointsInHull > 1) {
            this.slope1.set(this.rect[0], this.rect[2]);
            this.slope2.set(this.rect[1], this.rect[3]);
            boolean outside_line1 = this.slopeTmp.set(this.rect[2], this.point1).isLessThan(this.slope1);
            boolean outside_line2 = this.slopeTmp.set(this.rect[3], this.point2).isGreaterThan(this.slope2);
            if (outside_line1 || outside_line2) {
                this.produceSegment(segmentConsumer);
                this.numPointsInHull = 0;
            }
        }
        if (this.numPointsInHull == 0) {
            this.firstKey = key;
            this.rect[0].set(this.point1);
            this.rect[1].set(this.point2);
            this.upper.clear();
            this.lower.clear();
            this.upper.add(this.point1);
            this.lower.add(this.point2);
            this.lowerStart = 0;
            this.upperStart = 0;
            ++this.numPointsInHull;
            return;
        }
        if (this.numPointsInHull == 1) {
            this.rect[2].set(this.point2);
            this.rect[3].set(this.point1);
            this.upper.add(this.point1);
            this.lower.add(this.point2);
            ++this.numPointsInHull;
            return;
        }
        if (this.slopeTmp.set(this.rect[1], this.point1).isLessThan(this.slope2)) {
            this.slopeMin.set(this.point1, this.lower.get(this.lowerStart));
            int min_i = this.lowerStart;
            i = this.lowerStart + 1;
            while (i < this.lower.size()) {
                this.slopeTmp.set(this.point1, this.lower.get(i));
                if (this.slopeTmp.isGreaterThan(this.slopeMin)) break;
                this.slopeMin.set(this.slopeTmp);
                min_i = i++;
            }
            this.rect[1].set(this.lower.get(min_i));
            this.rect[3].set(this.point1);
            this.lowerStart = min_i;
            for (end = this.upper.size(); end >= this.upperStart + 2 && PlaModel.cross(this.upper.get(end - 2), this.upper.get(end - 1), this.point1) <= 0.0; --end) {
            }
            this.upper.clearFrom(end);
            this.upper.add(this.point1);
        }
        if (this.slopeTmp.set(this.rect[0], this.point2).isGreaterThan(this.slope1)) {
            this.slopeMax.set(this.point2, this.upper.get(this.upperStart));
            int max_i = this.upperStart;
            i = this.upperStart + 1;
            while (i < this.upper.size()) {
                this.slopeTmp.set(this.point2, this.upper.get(i));
                if (this.slopeTmp.isLessThan(this.slopeMax)) break;
                this.slopeMax.set(this.slopeTmp);
                max_i = i++;
            }
            this.rect[0].set(this.upper.get(max_i));
            this.rect[2].set(this.point2);
            this.upperStart = max_i;
            for (end = this.lower.size(); end >= this.lowerStart + 2 && PlaModel.cross(this.lower.get(end - 2), this.lower.get(end - 1), this.point2) >= 0.0; --end) {
            }
            this.lower.clearFrom(end);
            this.lower.add(this.point2);
        }
        ++this.numPointsInHull;
    }

    private void produceSegment(SegmentConsumer segmentConsumer) {
        long intercept;
        double slope;
        if (this.numPointsInHull == 1) {
            slope = 0.0;
            intercept = this.rect[0].y + this.rect[1].y >>> 1;
        } else {
            double intersectY;
            double intersectX;
            Point p0 = this.rect[0];
            Point p1 = this.rect[1];
            Point p2 = this.rect[2];
            Point p3 = this.rect[3];
            this.slope1.set(p0, p2);
            this.slope2.set(p1, p3);
            if (this.slope1.isEqual(this.slope2)) {
                intersectX = p0.x;
                intersectY = p0.y;
            } else {
                this.slopeTmp.set(p0, p1);
                double a = this.slope1.dx * (double)this.slope2.dy - (double)this.slope1.dy * this.slope2.dx;
                double b = (this.slopeTmp.dx * (double)this.slope2.dy - (double)this.slopeTmp.dy * this.slope2.dx) / a;
                intersectX = p0.x + b * this.slope1.dx;
                intersectY = (double)p0.y + b * (double)this.slope1.dy;
            }
            double minSlope = Slope.asDouble(p0, p2);
            double maxSlope = Slope.asDouble(p1, p3);
            slope = (minSlope + maxSlope) / 2.0;
            intercept = (long)(intersectY - (intersectX - this.firstKey) * slope);
        }
        segmentConsumer.accept(this.firstKey, slope, intercept);
    }

    public void finish(SegmentConsumer segmentConsumer) {
        this.produceSegment(segmentConsumer);
        this.reset();
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 16) + 6L * (long)Point.RAM_BYTES_ALLOCATED + this.lower.ramBytesAllocated() + this.upper.ramBytesAllocated() + 5L * (long)Slope.RAM_BYTES_ALLOCATED;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesAllocated();
    }

    private int addEpsilon(int index) {
        try {
            return Math.addExact(index, this.epsilon);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    private int subtractEpsilon(int index) {
        try {
            return Math.subtractExact(index, this.epsilon);
        }
        catch (ArithmeticException e) {
            return Integer.MIN_VALUE;
        }
    }

    private static double cross(Point o, Point a, Point b) {
        return (a.x - o.x) * (double)(b.y - o.y) - (double)(a.y - o.y) * (b.x - o.x);
    }

    private static class Point {
        static final int RAM_BYTES_ALLOCATED = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + 8;
        double x;
        long y;

        private Point() {
        }

        Point set(double x, long y) {
            this.x = x;
            this.y = y;
            return this;
        }

        Point set(Point p) {
            return this.set(p.x, p.y);
        }
    }

    private static class PointList
    implements Accountable {
        Point[] points;
        int size;
        int numAllocated;

        PointList(int initialCapacity) {
            this.points = new Point[initialCapacity];
        }

        void add(Point point) {
            if (this.size == this.points.length) {
                int newSize = BoundedProportionalArraySizingStrategy.DEFAULT_INSTANCE.grow(this.points.length, this.size, 1);
                this.points = Arrays.copyOf(this.points, newSize);
            }
            if (this.size == this.numAllocated) {
                this.points[this.numAllocated++] = new Point();
            }
            this.points[this.size++].set(point);
        }

        Point get(int index) {
            return this.points[index];
        }

        int size() {
            return this.size;
        }

        void clear() {
            this.size = 0;
        }

        void clearFrom(int end) {
            this.size = end;
        }

        @Override
        public long ramBytesAllocated() {
            return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowSizeOfArray(this.points) + (long)this.numAllocated * (long)Point.RAM_BYTES_ALLOCATED;
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesAllocated();
        }
    }

    private static class Slope {
        static final int RAM_BYTES_ALLOCATED = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + 8;
        double dx;
        long dy;

        private Slope() {
        }

        void set(Slope s) {
            this.dx = s.dx;
            this.dy = s.dy;
        }

        Slope set(Point p1, Point p2) {
            this.dx = p2.x - p1.x;
            this.dy = p2.y - p1.y;
            return this;
        }

        boolean isLessThan(Slope s) {
            return (double)this.dy * s.dx < this.dx * (double)s.dy;
        }

        boolean isGreaterThan(Slope s) {
            return (double)this.dy * s.dx > this.dx * (double)s.dy;
        }

        boolean isEqual(Slope s) {
            return Double.doubleToLongBits((double)this.dy * s.dx) == Double.doubleToLongBits(this.dx * (double)s.dy);
        }

        static double asDouble(Point p1, Point p2) {
            return (double)(p2.y - p1.y) / (p2.x - p1.x);
        }
    }

    public static interface SegmentConsumer {
        public void accept(double var1, double var3, long var5);
    }
}

