/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import org.teavm.hppc.BitMixer;
import org.teavm.hppc.ObjectContainer;
import org.teavm.hppc.ObjectHashSet;

public class ObjectIdentityHashSet<KType>
extends ObjectHashSet<KType> {
    public ObjectIdentityHashSet() {
        this(4, 0.75);
    }

    public ObjectIdentityHashSet(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectIdentityHashSet(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor);
    }

    public ObjectIdentityHashSet(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    protected int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mixPhi(System.identityHashCode(key));
    }

    @Override
    protected boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    @SafeVarargs
    public static <KType> ObjectIdentityHashSet<KType> from(KType ... elements) {
        ObjectIdentityHashSet<KType> set = new ObjectIdentityHashSet<KType>(elements.length);
        set.addAll(elements);
        return set;
    }
}

