/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.teavm.common.Graph;
import org.teavm.common.Loop;

public class LoopGraph
implements Graph {
    private Graph graph;
    private LoopImpl[] loops;
    private LoopImpl[] loopSet;
    private int[] walkIndexes;

    public LoopGraph(Graph graph) {
        this.graph = graph;
        this.findLoops();
    }

    private void findLoops() {
        int sz = this.graph.size();
        this.loops = new LoopImpl[sz];
        this.loopSet = new LoopImpl[sz];
        this.walkIndexes = new int[sz];
        LoopImpl[] createdLoops = new LoopImpl[sz];
        LoopFrame[] frames = new LoopFrame[sz];
        ArrayDeque<LoopFrame> stack = new ArrayDeque<LoopFrame>(sz * 4);
        LoopFrame rootFrame = new LoopFrame();
        stack.push(rootFrame);
        int walkIndex = 0;
        int lastSortIndex = sz - 1;
        int loopSetSize = 0;
        while (!stack.isEmpty()) {
            LoopFrame frame = (LoopFrame)stack.pop();
            if (frames[frame.index] == null) {
                frames[frame.index] = frame;
                frame.walkIndex = walkIndex++;
                stack.push(frame);
                int[] targetEdges = this.graph.outgoingEdges(frame.index);
                for (int i = 0; i < targetEdges.length; ++i) {
                    int next = targetEdges[i];
                    LoopFrame nextFrame = frames[next];
                    if (nextFrame != null) continue;
                    nextFrame = new LoopFrame();
                    nextFrame.index = next;
                    stack.push(nextFrame);
                }
                continue;
            }
            frame.sortIndex = lastSortIndex--;
            frame.done = true;
            LoopImpl bestLoop = null;
            int[] targetEdges = this.graph.outgoingEdges(frame.index);
            for (int i = 0; i < targetEdges.length; ++i) {
                int next = targetEdges[i];
                LoopFrame nextFrame = frames[next];
                LoopImpl loop = nextFrame.loop;
                if (!nextFrame.done) {
                    loop = createdLoops[next];
                    if (loop == null) {
                        loop = new LoopImpl();
                        loop.head = next;
                        loop.walkIndex = nextFrame.walkIndex;
                        createdLoops[next] = loop;
                        this.loopSet[loopSetSize++] = loop;
                    }
                } else {
                    while (loop != null && loop.head == next) {
                        loop = loop.parent;
                    }
                }
                if (loop == null) continue;
                bestLoop = this.chooseLoop(bestLoop, loop);
            }
            frame.loop = bestLoop;
        }
        this.loopSet = Arrays.copyOf(this.loopSet, loopSetSize);
        for (int i = 0; i < frames.length; ++i) {
            this.loops[i] = frames[i] != null ? frames[i].loop : null;
            this.walkIndexes[i] = frames[i] != null ? frames[i].sortIndex : -1;
        }
    }

    public static Loop commonSuperloop(Loop first, Loop second) {
        if (first == second) {
            return first;
        }
        ArrayList<Loop> firstPath = new ArrayList<Loop>();
        ArrayList<Loop> secondPath = new ArrayList<Loop>();
        while (first != null) {
            firstPath.add(first);
            first = first.getParent();
        }
        firstPath.add(null);
        while (second != null) {
            secondPath.add(second);
            second = second.getParent();
        }
        secondPath.add(null);
        Collections.reverse(firstPath);
        Collections.reverse(secondPath);
        int sz = Math.min(firstPath.size(), secondPath.size());
        for (int i = 1; i < sz; ++i) {
            if (firstPath.get(i) == secondPath.get(i)) continue;
            return (Loop)firstPath.get(i - 1);
        }
        return (Loop)firstPath.get(sz - 1);
    }

    private LoopImpl chooseLoop(LoopImpl bestLoop, LoopImpl testLoop) {
        if (bestLoop == null || bestLoop == testLoop) {
            return testLoop;
        }
        if (bestLoop.walkIndex >= testLoop.walkIndex) {
            LoopImpl loop = bestLoop;
            while (loop.getParent() != null) {
                if (loop == testLoop) {
                    return bestLoop;
                }
                if (loop.parent.walkIndex < testLoop.walkIndex) {
                    testLoop.parent = loop.parent;
                    loop.parent = testLoop;
                    break;
                }
                loop = loop.parent;
            }
            if (loop.parent == null && loop != testLoop) {
                loop.parent = testLoop;
            }
            return bestLoop;
        }
        testLoop.parent = bestLoop;
        return testLoop;
    }

    public Loop loopAt(int index) {
        return this.loops[index];
    }

    public Loop[] knownLoops() {
        return Arrays.copyOf(this.loopSet, this.loopSet.length);
    }

    @Override
    public int size() {
        return this.graph.size();
    }

    @Override
    public int[] incomingEdges(int node) {
        return this.graph.incomingEdges(node);
    }

    @Override
    public int copyIncomingEdges(int node, int[] target) {
        return this.graph.copyIncomingEdges(node, target);
    }

    @Override
    public int[] outgoingEdges(int node) {
        return this.graph.outgoingEdges(node);
    }

    @Override
    public int copyOutgoingEdges(int node, int[] target) {
        return this.graph.copyOutgoingEdges(node, target);
    }

    @Override
    public int incomingEdgesCount(int node) {
        return this.graph.incomingEdgesCount(node);
    }

    @Override
    public int outgoingEdgesCount(int node) {
        return this.graph.outgoingEdgesCount(node);
    }

    public int indexAt(int node) {
        return this.walkIndexes[node];
    }

    private static class LoopImpl
    implements Loop {
        public int head;
        public LoopImpl parent;
        public int walkIndex;

        private LoopImpl() {
        }

        @Override
        public int getHead() {
            return this.head;
        }

        @Override
        public Loop getParent() {
            return this.parent;
        }

        @Override
        public boolean isChildOf(Loop other) {
            if (other == null) {
                return true;
            }
            for (Loop loop = this; loop != null; loop = loop.getParent()) {
                if (loop != other) continue;
                return true;
            }
            return false;
        }
    }

    private static class LoopFrame {
        public int walkIndex;
        public int index;
        public int sortIndex;
        public LoopImpl loop;
        public boolean done;

        private LoopFrame() {
        }
    }
}

