/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cli.devserver;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.log.Logger;
import org.teavm.common.JsonUtil;
import org.teavm.devserver.DevServerListener;
import org.teavm.diagnostics.DefaultProblemTextConsumer;
import org.teavm.diagnostics.Problem;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.builder.BuildResult;

public class JsonCommandWriter
implements TeaVMToolLog,
DevServerListener,
Logger {
    private PrintWriter writer = new PrintWriter(System.out, false, StandardCharsets.UTF_8);

    @Override
    public void info(String text) {
        this.writeMessage("info", text, null);
    }

    @Override
    public void debug(String text) {
        this.writeMessage("debug", text, null);
    }

    @Override
    public void warning(String text) {
        this.writeMessage("warning", text, null);
    }

    @Override
    public void error(String text) {
        this.writeMessage("error", text, null);
    }

    @Override
    public void info(String text, Throwable e) {
        this.writeMessage("info", text, e);
    }

    @Override
    public void debug(String text, Throwable e) {
        this.writeMessage("debug", text, e);
    }

    @Override
    public void warning(String text, Throwable e) {
        this.writeMessage("warning", text, e);
    }

    @Override
    public void error(String text, Throwable e) {
        this.writeMessage("error", text, e);
    }

    @Override
    public String getName() {
        return "dev-server";
    }

    @Override
    public void warn(String s, Object ... objects) {
        this.writeMessage("warning", this.format(s, objects), null);
    }

    @Override
    public void warn(Throwable throwable) {
        this.writeMessage("warning", "", throwable);
    }

    @Override
    public void warn(String s, Throwable throwable) {
        this.writeMessage("warning", s, throwable);
    }

    @Override
    public void info(String s, Object ... objects) {
        this.writeMessage("info", this.format(s, objects), null);
    }

    @Override
    public void info(Throwable throwable) {
        this.writeMessage("info", "", throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public void setDebugEnabled(boolean b) {
    }

    @Override
    public void debug(String s, Object ... objects) {
        this.writeMessage("debug", this.format(s, objects), null);
    }

    @Override
    public void debug(String s, long l) {
        this.writeMessage("debug", this.format(s, new Object[]{l}), null);
    }

    @Override
    public void debug(Throwable throwable) {
        this.writeMessage("debug", "", null);
    }

    @Override
    public Logger getLogger(String s) {
        return this;
    }

    @Override
    public void ignore(Throwable throwable) {
    }

    private String format(String message, Object[] args) {
        int next;
        int index = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length && (next = message.indexOf("{}", index)) >= 0; ++i) {
            sb.append(message, index, next);
            sb.append(args[i]);
            index = next + 2;
        }
        sb.append(message, index, message.length());
        return sb.toString();
    }

    private synchronized void writeMessage(String level, String message, Throwable throwable) {
        try {
            this.writer.append("{\"type\":\"log\",\"level\":\"").append(level).append("\",\"message\":\"");
            JsonUtil.writeEscapedString(this.writer, message);
            this.writer.append("\"");
            if (throwable != null) {
                this.writer.append(",\"throwable\":\"");
                StringWriter throwableBuffer = new StringWriter();
                PrintWriter throwableWriter = new PrintWriter(throwableBuffer);
                throwable.printStackTrace(throwableWriter);
                JsonUtil.writeEscapedString(this.writer, throwableBuffer.toString());
                this.writer.append("\"");
            }
            this.writer.append("}");
            this.writer.println();
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void compilationStarted() {
        this.writer.append("{\"type\":\"compilation-started\"}");
        this.writer.println();
        this.writer.flush();
    }

    @Override
    public synchronized void compilationProgress(double progress) {
        this.writer.append("{\"type\":\"compilation-progress\",\"progress\":").append(String.valueOf(progress)).append("}");
        this.writer.println();
        this.writer.flush();
    }

    @Override
    public synchronized void compilationComplete(BuildResult result) {
        DefaultProblemTextConsumer consumer = new DefaultProblemTextConsumer();
        try {
            this.writer.append("{\"type\":\"compilation-complete\"");
            if (result != null && !result.getProblems().getProblems().isEmpty()) {
                this.writer.append(",\"problems\":[");
                for (int i = 0; i < result.getProblems().getProblems().size(); ++i) {
                    if (i > 0) {
                        this.writer.append(",");
                    }
                    Problem problem = result.getProblems().getProblems().get(i);
                    this.writer.append("{\"severity\":");
                    switch (problem.getSeverity()) {
                        case ERROR: {
                            this.writer.append("\"error\"");
                            break;
                        }
                        case WARNING: {
                            this.writer.append("\"warning\"");
                        }
                    }
                    this.writer.append(",\"location\":\"");
                    StringBuilder sb = new StringBuilder();
                    TeaVMProblemRenderer.renderCallStack(result.getCallGraph(), problem.getLocation(), sb);
                    JsonUtil.writeEscapedString(this.writer, sb.toString());
                    this.writer.append("\",\"message\":\"");
                    problem.render(consumer);
                    JsonUtil.writeEscapedString(this.writer, consumer.getText());
                    this.writer.append("\"}");
                }
                this.writer.append("]");
            }
            this.writer.append("}");
            this.writer.println();
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void compilationCancelled() {
        this.writer.append("{\"type\":\"compilation-cancelled\"}");
        this.writer.println();
        this.writer.flush();
    }
}

