/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.intimpl;

import java.util.function.IntPredicate;
import org.teavm.classlib.java.lang.TCharacter;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.util.stream.intimpl.TSimpleIntStreamImpl;

public class TStringCodePointsStream
extends TSimpleIntStreamImpl {
    private final TString string;
    private int index;

    public TStringCodePointsStream(TString string) {
        this.string = string;
    }

    @Override
    public boolean next(IntPredicate consumer) {
        while (this.index < this.string.length()) {
            char lo;
            char hi;
            if (TCharacter.isHighSurrogate(hi = this.string.charAt(this.index++)) && this.index < this.string.length() && TCharacter.isLowSurrogate(lo = this.string.charAt(this.index))) {
                ++this.index;
                if (consumer.test(TCharacter.toCodePoint(hi, lo))) continue;
                break;
            }
            if (consumer.test(hi)) continue;
            break;
        }
        return this.index < this.string.length();
    }

    @Override
    protected int estimateSize() {
        return this.string.length();
    }

    @Override
    public long count() {
        return this.string.length();
    }
}

