/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.impl;

import java.util.function.Predicate;
import org.teavm.classlib.java.util.stream.impl.TSimpleStreamImpl;

public class TSkippingStreamImpl<T>
extends TSimpleStreamImpl<T> {
    private TSimpleStreamImpl<T> sourceStream;
    private int skip;
    private int remaining;

    public TSkippingStreamImpl(TSimpleStreamImpl<T> sourceStream, int skip) {
        this.sourceStream = sourceStream;
        this.skip = skip;
        this.remaining = skip;
    }

    @Override
    public boolean next(Predicate<? super T> consumer) {
        while (this.remaining > 0) {
            if (this.sourceStream.next(e -> --this.remaining > 0)) continue;
            return false;
        }
        return this.sourceStream.next(consumer);
    }

    @Override
    protected int estimateSize() {
        int sourceSize = this.sourceStream.estimateSize();
        return sourceSize >= 0 ? Math.max(0, sourceSize - this.skip) : -1;
    }

    @Override
    public void close() {
        this.sourceStream.close();
    }
}

