/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.teavm.classlib.java.util.stream.TCollector;
import org.teavm.classlib.java.util.stream.TDoubleStream;
import org.teavm.classlib.java.util.stream.TIntStream;
import org.teavm.classlib.java.util.stream.TLongStream;
import org.teavm.classlib.java.util.stream.TStream;
import org.teavm.classlib.java.util.stream.impl.TAllMatchConsumer;
import org.teavm.classlib.java.util.stream.impl.TAnyMatchConsumer;
import org.teavm.classlib.java.util.stream.impl.TCloseHandlingStream;
import org.teavm.classlib.java.util.stream.impl.TCountingConsumer;
import org.teavm.classlib.java.util.stream.impl.TDistinctStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TDropWhileStream;
import org.teavm.classlib.java.util.stream.impl.TFilteringStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TFindFirstConsumer;
import org.teavm.classlib.java.util.stream.impl.TFlatMappingStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TFlatMappingToDoubleStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TFlatMappingToIntStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TFlatMappingToLongStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TLimitingStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TMappingStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TMappingToDoubleStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TMappingToIntStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TMappingToLongStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TPeekingStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TReducingConsumer;
import org.teavm.classlib.java.util.stream.impl.TReducingConsumer2;
import org.teavm.classlib.java.util.stream.impl.TSimpleStreamIterator;
import org.teavm.classlib.java.util.stream.impl.TSimpleStreamSpliterator;
import org.teavm.classlib.java.util.stream.impl.TSkippingStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TSortedStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TTakeWhileStream;

public abstract class TSimpleStreamImpl<T>
implements TStream<T> {
    @Override
    public TStream<T> filter(Predicate<? super T> predicate) {
        return new TFilteringStreamImpl<T>(this, predicate);
    }

    @Override
    public <R> TStream<R> map(Function<? super T, ? extends R> mapper) {
        return new TMappingStreamImpl<R, T>(this, mapper);
    }

    @Override
    public TIntStream mapToInt(ToIntFunction<? super T> mapper) {
        return new TMappingToIntStreamImpl<T>(this, mapper);
    }

    @Override
    public TLongStream mapToLong(ToLongFunction<? super T> mapper) {
        return new TMappingToLongStreamImpl<T>(this, mapper);
    }

    @Override
    public TDoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return new TMappingToDoubleStreamImpl<T>(this, mapper);
    }

    @Override
    public <R> TStream<R> flatMap(Function<? super T, ? extends TStream<? extends R>> mapper) {
        return new TFlatMappingStreamImpl(this, mapper);
    }

    @Override
    public TIntStream flatMapToInt(Function<? super T, ? extends TIntStream> mapper) {
        return new TFlatMappingToIntStreamImpl<T>(this, mapper);
    }

    @Override
    public TLongStream flatMapToLong(Function<? super T, ? extends TLongStream> mapper) {
        return new TFlatMappingToLongStreamImpl<T>(this, mapper);
    }

    @Override
    public TDoubleStream flatMapToDouble(Function<? super T, ? extends TDoubleStream> mapper) {
        return new TFlatMappingToDoubleStreamImpl<T>(this, mapper);
    }

    @Override
    public TStream<T> distinct() {
        return new TDistinctStreamImpl(this);
    }

    @Override
    public TStream<T> sorted() {
        return new TSortedStreamImpl(this, (a, b) -> ((Comparable)a).compareTo(b));
    }

    @Override
    public TStream<T> sorted(Comparator<? super T> comparator) {
        return new TSortedStreamImpl<T>(this, comparator);
    }

    @Override
    public TStream<T> peek(Consumer<? super T> action) {
        return new TPeekingStreamImpl<T>(this, action);
    }

    @Override
    public TStream<T> limit(long maxSize) {
        return new TLimitingStreamImpl(this, (int)maxSize);
    }

    @Override
    public TStream<T> takeWhile(Predicate<? super T> predicate) {
        return new TTakeWhileStream<T>(this, predicate);
    }

    @Override
    public TStream<T> dropWhile(Predicate<? super T> predicate) {
        return new TDropWhileStream<T>(this, predicate);
    }

    @Override
    public TStream<T> skip(long n) {
        return new TSkippingStreamImpl(this, (int)n);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.forEachOrdered(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        boolean hasMore;
        while (hasMore = this.next(e -> {
            action.accept(e);
            return true;
        })) {
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArray(Object[]::new);
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        int estimatedSize = this.estimateSize();
        if (estimatedSize < 0) {
            ArrayList list = new ArrayList();
            while (this.next(list::add)) {
            }
            A[] array = generator.apply(list.size());
            for (int i = 0; i < array.length; ++i) {
                array[i] = list.get(i);
            }
            return array;
        }
        A[] array = generator.apply(estimatedSize);
        ArrayFillingConsumer consumer = new ArrayFillingConsumer(array);
        while (this.next(consumer)) {
        }
        if (consumer.index < array.length) {
            array = Arrays.copyOf(array, consumer.index);
        }
        return array;
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        TReducingConsumer<T> consumer = new TReducingConsumer<T>(accumulator, identity, true);
        while (this.next(consumer)) {
        }
        return consumer.result;
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        TReducingConsumer<Object> consumer = new TReducingConsumer<Object>(accumulator, null, false);
        while (this.next(consumer)) {
        }
        return Optional.ofNullable(consumer.result);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        TReducingConsumer2<? super T, U> consumer = new TReducingConsumer2<T, U>(accumulator, identity);
        while (this.next(consumer)) {
        }
        return consumer.result;
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        boolean hasMore;
        Object collection = supplier.get();
        while (hasMore = this.next(e -> {
            accumulator.accept(collection, (Object)e);
            return true;
        })) {
        }
        return collection;
    }

    @Override
    public <R, A> R collect(TCollector<? super T, A, R> collector) {
        boolean hasMore;
        Object collection = collector.supplier().get();
        BiConsumer accumulator = collector.accumulator();
        while (hasMore = this.next(e -> {
            accumulator.accept(collection, (Object)e);
            return true;
        })) {
        }
        return collector.finisher().apply(collection);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) <= 0 ? a : b);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) >= 0 ? a : b);
    }

    @Override
    public long count() {
        TCountingConsumer consumer = new TCountingConsumer();
        while (this.next(consumer)) {
        }
        return consumer.count;
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        TAnyMatchConsumer<? super T> consumer = new TAnyMatchConsumer<T>(predicate);
        while (!consumer.matched && this.next(consumer)) {
        }
        return consumer.matched;
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        TAllMatchConsumer<? super T> consumer = new TAllMatchConsumer<T>(predicate);
        while (consumer.matched && this.next(consumer)) {
        }
        return consumer.matched;
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        TFindFirstConsumer consumer = new TFindFirstConsumer();
        while (consumer.result == null && this.next(consumer)) {
        }
        return Optional.ofNullable(consumer.result);
    }

    @Override
    public Optional<T> findAny() {
        return this.findFirst();
    }

    @Override
    public Iterator<T> iterator() {
        return new TSimpleStreamIterator(this);
    }

    @Override
    public Spliterator<T> spliterator() {
        return new TSimpleStreamSpliterator(this);
    }

    @Override
    public boolean isParallel() {
        return false;
    }

    @Override
    public TStream<T> sequential() {
        return this;
    }

    @Override
    public TStream<T> parallel() {
        return this;
    }

    @Override
    public TStream<T> unordered() {
        return this;
    }

    @Override
    public TStream<T> onClose(Runnable closeHandler) {
        return new TCloseHandlingStream(this, closeHandler);
    }

    @Override
    public void close() {
    }

    protected int estimateSize() {
        return -1;
    }

    public abstract boolean next(Predicate<? super T> var1);

    static class ArrayFillingConsumer<A, T>
    implements Predicate<T> {
        A[] array;
        int index;

        ArrayFillingConsumer(A[] array) {
            this.array = array;
        }

        @Override
        public boolean test(T t) {
            this.array[this.index++] = t;
            return true;
        }
    }
}

