/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import org.teavm.classlib.java.util.regex.TAbstractSet;
import org.teavm.classlib.java.util.regex.TLeafQuantifierSet;
import org.teavm.classlib.java.util.regex.TLeafSet;
import org.teavm.classlib.java.util.regex.TMatchResultImpl;
import org.teavm.classlib.java.util.regex.TQuantifier;

class TCompositeQuantifierSet
extends TLeafQuantifierSet {
    protected TQuantifier quantifier;

    public TCompositeQuantifierSet(TQuantifier quant, TLeafSet innerSet, TAbstractSet next, int type) {
        super(innerSet, next, type);
        this.quantifier = quant;
    }

    @Override
    public int matches(int stringIndex, CharSequence testString, TMatchResultImpl matchResult) {
        int shift;
        int i;
        int min = this.quantifier.min();
        int max = this.quantifier.max();
        for (i = 0; i < min; ++i) {
            if (stringIndex + this.leaf.charCount() > matchResult.getRightBound()) {
                matchResult.hitEnd = true;
                return -1;
            }
            shift = this.leaf.accepts(stringIndex, testString);
            if (shift < 1) {
                return -1;
            }
            stringIndex += shift;
        }
        while (i < max && stringIndex + this.leaf.charCount() <= matchResult.getRightBound() && (shift = this.leaf.accepts(stringIndex, testString)) >= 1) {
            stringIndex += shift;
            ++i;
        }
        while (i >= min) {
            shift = this.next.matches(stringIndex, testString, matchResult);
            if (shift >= 0) {
                return shift;
            }
            stringIndex -= this.leaf.charCount();
            --i;
        }
        return -1;
    }

    public void reset() {
        this.quantifier.resetCounter();
    }

    @Override
    protected String getName() {
        return this.quantifier.toString();
    }

    void setQuantifier(TQuantifier quant) {
        this.quantifier = quant;
    }
}

