/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.logging;

import java.util.function.Supplier;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.lang.TInteger;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TThrowable;
import org.teavm.classlib.java.util.THashMap;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.logging.TLevel;
import org.teavm.classlib.java.util.logging.TLogRecord;
import org.teavm.jso.JSBody;
import org.teavm.jso.impl.JS;

public class TLogger {
    public static final String GLOBAL_LOGGER_NAME = "global";
    private static TMap<String, TLogger> loggerCache = new THashMap<String, TLogger>();
    private String name;
    private TLogger parent;

    TLogger(String name) {
        this.name = name;
    }

    public static TLogger getGlobal() {
        return TLogger.getLogger(GLOBAL_LOGGER_NAME);
    }

    public static TLogger getLogger(String name) {
        TLogger logger = loggerCache.get(name);
        if (logger == null) {
            logger = new TLogger(name);
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex >= 0) {
                String parentName = name.substring(0, dotIndex);
                logger.parent = TLogger.getLogger(parentName);
            } else if (!name.isEmpty()) {
                logger.parent = TLogger.getLogger("");
            }
            loggerCache.put(name, logger);
        }
        return logger;
    }

    public static TLogger getAnonymousLogger() {
        return new TLogger(null);
    }

    public void log(TLogRecord record) {
        String message = this.format(record.getMessage(), record.getParameters());
        if (PlatformDetector.isLowLevel()) {
            System.out.print("[");
            System.out.print(record.getLevel().getName());
            System.out.print("] ");
            System.out.println(message);
            if (record.getThrown() != null) {
                record.getThrown().printStackTrace(System.out);
            }
        } else if (record.getLevel().intValue() >= TLevel.SEVERE.intValue()) {
            if (PlatformDetector.isWebAssemblyGC()) {
                JS.invoke(JS.global("console"), JS.wrap("error"), JS.wrap(message));
            } else {
                TLogger.error(message);
            }
        } else if (record.getLevel().intValue() >= TLevel.WARNING.intValue()) {
            if (PlatformDetector.isWebAssemblyGC()) {
                JS.invoke(JS.global("console"), JS.wrap("warn"), JS.wrap(message));
            } else {
                TLogger.warn(message);
            }
        } else if (PlatformDetector.isWebAssemblyGC()) {
            JS.invoke(JS.global("console"), JS.wrap("info"), JS.wrap(message));
        } else {
            TLogger.infoImpl(message);
        }
    }

    private String format(String message, Object[] params) {
        int paramStart;
        int next;
        if (params == null) {
            return message;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < message.length() && (next = message.indexOf(123, index)) >= 0 && (next = TLogger.digits(paramStart = next + 1, message)) >= 0) {
            if (message.charAt(next) != '}') {
                sb.append(message, index, next);
                index = next;
                continue;
            }
            int paramIndex = TInteger.parseInt(message.substring(paramStart, next));
            if (paramIndex >= params.length) {
                sb.append(message, index, next);
                index = next;
                continue;
            }
            sb.append(params[paramIndex]);
            index = next + 1;
        }
        return sb.toString();
    }

    private static int digits(int from, String message) {
        while (from < message.length()) {
            char c;
            if ((c = message.charAt(from++)) > '0' && c < '9') continue;
            return from;
        }
        return -1;
    }

    public void log(TLevel level, String msg, Object[] params) {
        TLogRecord record = new TLogRecord(level, msg);
        record.setParameters(params);
        this.log(record);
    }

    public void log(TLevel level, String msg) {
        this.log(new TLogRecord(level, msg));
    }

    public void log(TLevel level, String msg, TObject param1) {
        TLogRecord record = new TLogRecord(level, msg);
        record.setParameters(new Object[]{param1});
        this.log(record);
    }

    public void log(TLevel level, String msg, TThrowable thrown) {
        TLogRecord record = new TLogRecord(level, msg);
        record.setThrown(thrown);
        this.log(record);
    }

    public void log(TLevel level, Supplier<String> msgSupplier) {
        TLogRecord record = new TLogRecord(level, msgSupplier.get());
        this.log(record);
    }

    public void log(TLevel level, TThrowable thrown, Supplier<String> msgSupplier) {
        TLogRecord record = new TLogRecord(level, msgSupplier.get());
        record.setThrown(thrown);
        this.log(record);
    }

    public void logp(TLevel level, String sourceClass, String sourceMethod, String msg) {
        TLogRecord record = new TLogRecord(level, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public void logp(TLevel level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        TLogRecord record = new TLogRecord(level, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.log(record);
    }

    public void logp(TLevel level, String sourceClass, String sourceMethod, Supplier<String> msgSupplier) {
        TLogRecord record = new TLogRecord(level, msgSupplier.get());
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public void logp(TLevel level, String sourceClass, String sourceMethod, String msg, Object param1) {
        TLogRecord record = new TLogRecord(level, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(new Object[]{param1});
        this.log(record);
    }

    public void logp(TLevel level, String sourceClass, String sourceMethod, String msg, TThrowable thrown) {
        TLogRecord record = new TLogRecord(level, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setThrown(thrown);
        this.log(record);
    }

    public void logp(TLevel level, String sourceClass, String sourceMethod, TThrowable thrown, Supplier<String> msgSupplier) {
        TLogRecord record = new TLogRecord(level, msgSupplier.get());
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setThrown(thrown);
        this.log(record);
    }

    public void severe(String msg) {
        this.log(TLevel.SEVERE, msg);
    }

    public void severe(Supplier<String> msgSupplier) {
        this.severe(msgSupplier.get());
    }

    public void warning(String msg) {
        this.log(TLevel.WARNING, msg);
    }

    public void warning(Supplier<String> msgSupplier) {
        this.warning(msgSupplier.get());
    }

    public void info(String msg) {
        this.log(TLevel.INFO, msg);
    }

    public void info(Supplier<String> msgSupplier) {
        this.info(msgSupplier.get());
    }

    public void config(String msg) {
        this.log(TLevel.CONFIG, msg);
    }

    public void config(Supplier<String> msgSupplier) {
        this.config(msgSupplier.get());
    }

    public void fine(String msg) {
        this.log(TLevel.FINE, msg);
    }

    public void fine(Supplier<String> msgSupplier) {
        this.fine(msgSupplier.get());
    }

    public void finer(String msg) {
        this.log(TLevel.FINER, msg);
    }

    public void finer(Supplier<String> msgSupplier) {
        this.finer(msgSupplier.get());
    }

    public void finest(String msg) {
        this.log(TLevel.FINEST, msg);
    }

    public void finest(Supplier<String> msgSupplier) {
        this.finest(msgSupplier.get());
    }

    public void throwing(String sourceClass, String sourceMethod, TThrowable thrown) {
        TLogRecord record = new TLogRecord(TLevel.FINEST, "THROW");
        record.setThrown(thrown);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public boolean isLoggable(TLevel level) {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public TLogger getParent() {
        return this.parent;
    }

    public void setParent(TLogger parent) {
        this.parent = parent;
    }

    @JSBody(params={"message"}, script="if (console) {console.info(message);}")
    private static native void infoImpl(String var0);

    @JSBody(params={"message"}, script="if (console) {console.warn(message);}")
    private static native void warn(String var0);

    @JSBody(params={"message"}, script="if (console) {console.error(message);}")
    private static native void error(String var0);
}

