/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;

public class TAtomicLong
extends Number
implements Serializable {
    private long value;
    private volatile int version;

    public TAtomicLong() {
    }

    public TAtomicLong(long value) {
        this.value = value;
    }

    public final long get() {
        return this.value;
    }

    public final void set(long newValue) {
        this.value = newValue;
        ++this.version;
    }

    public final void lazySet(long newValue) {
        this.value = newValue;
        ++this.version;
    }

    public final long getAndSet(long newValue) {
        long result = this.value;
        this.value = newValue;
        ++this.version;
        return result;
    }

    public final boolean compareAndSet(long expect, long update) {
        if (this.value != expect) {
            return false;
        }
        this.value = update;
        ++this.version;
        return true;
    }

    public final boolean weakCompareAndSet(long expect, long update) {
        if (this.value != expect) {
            return false;
        }
        this.value = update;
        ++this.version;
        return true;
    }

    public final long getAndIncrement() {
        ++this.version;
        return this.value++;
    }

    public final long getAndDecrement() {
        ++this.version;
        return this.value--;
    }

    public final long getAndAdd(long delta) {
        ++this.version;
        long result = this.value;
        this.value += delta;
        return result;
    }

    public final long incrementAndGet() {
        ++this.version;
        return ++this.value;
    }

    public final long decrementAndGet() {
        ++this.version;
        return --this.value;
    }

    public final long addAndGet(long delta) {
        ++this.version;
        this.value += delta;
        return this.value;
    }

    public final long getAndUpdate(LongUnaryOperator updateFunction) {
        long newValue;
        long result;
        int expectedVersion;
        do {
            expectedVersion = this.version;
            result = this.value;
            newValue = updateFunction.applyAsLong(this.value);
        } while (expectedVersion != this.version);
        ++this.version;
        this.value = newValue;
        return result;
    }

    public final long updateAndGet(LongUnaryOperator updateFunction) {
        long newValue;
        int expectedVersion;
        do {
            expectedVersion = this.version;
            newValue = updateFunction.applyAsLong(this.value);
        } while (expectedVersion != this.version);
        ++this.version;
        this.value = newValue;
        return newValue;
    }

    public final long getAndAccumulate(long x, LongBinaryOperator accumulatorFunction) {
        long newValue;
        long result;
        int expectedVersion;
        do {
            expectedVersion = this.version;
            result = this.value;
            newValue = accumulatorFunction.applyAsLong(this.value, x);
        } while (expectedVersion != this.version);
        ++this.version;
        this.value = newValue;
        return result;
    }

    public final long accumulateAndGet(long x, LongBinaryOperator accumulatorFunction) {
        long newValue;
        int expectedVersion;
        do {
            expectedVersion = this.version;
            newValue = accumulatorFunction.applyAsLong(this.value, x);
        } while (expectedVersion != this.version);
        ++this.version;
        this.value = newValue;
        return newValue;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }
}

