/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent.atomic;

import java.lang.reflect.Modifier;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TIllegalAccessException;
import org.teavm.classlib.java.lang.TNoSuchFieldException;
import org.teavm.classlib.java.lang.reflect.TField;
import org.teavm.classlib.java.util.concurrent.atomic.TReflectionBasedAtomicIntegerFieldUpdater;

public abstract class TAtomicIntegerFieldUpdater<T> {
    protected TAtomicIntegerFieldUpdater() {
    }

    public static <U> TAtomicIntegerFieldUpdater<U> newUpdater(TClass<U> tclass, String fieldName) {
        try {
            TField field = tclass.getDeclaredField(fieldName);
            if (!Modifier.isVolatile(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !field.getType().equals(Integer.TYPE)) {
                throw new IllegalArgumentException();
            }
            field.checkGetAccess();
            field.checkSetAccess();
            return new TReflectionBasedAtomicIntegerFieldUpdater(field);
        }
        catch (TIllegalAccessException | TNoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract boolean compareAndSet(T var1, int var2, int var3);

    public abstract boolean weakCompareAndSet(T var1, int var2, int var3);

    public abstract void set(T var1, int var2);

    public abstract void lazySet(T var1, int var2);

    public abstract int get(T var1);

    public int getAndSet(T obj, int newValue) {
        int currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue)) {
        }
        return currentValue;
    }

    public int getAndIncrement(T obj) {
        return this.getAndAdd(obj, 1);
    }

    public int getAndDecrement(T obj) {
        return this.getAndAdd(obj, -1);
    }

    public int getAndAdd(T obj, int delta) {
        int currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), currentValue + delta)) {
        }
        return currentValue;
    }

    public int incrementAndGet(T obj) {
        return this.addAndGet(obj, 1);
    }

    public int decrementAndGet(T obj) {
        return this.addAndGet(obj, -1);
    }

    public int addAndGet(T obj, int delta) {
        int currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), currentValue + delta)) {
        }
        return currentValue + delta;
    }

    public final int getAndUpdate(T obj, IntUnaryOperator updateFunction) {
        int newValue;
        int currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue = updateFunction.applyAsInt(currentValue))) {
        }
        return currentValue;
    }

    public final int updateAndGet(T obj, IntUnaryOperator updateFunction) {
        int newValue;
        int currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue = updateFunction.applyAsInt(currentValue))) {
        }
        return newValue;
    }

    public final int getAndAccumulate(T obj, int x, IntBinaryOperator accumulatorFunction) {
        int newValue;
        int currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue = accumulatorFunction.applyAsInt(currentValue, x))) {
        }
        return currentValue;
    }

    public final int accumulateAndGet(T obj, int x, IntBinaryOperator accumulatorFunction) {
        int newValue;
        int currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue = accumulatorFunction.applyAsInt(currentValue, x))) {
        }
        return newValue;
    }
}

