/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TList;
import org.teavm.classlib.java.util.TListIterator;

public class TCopyOnWriteArrayList<E>
implements TList<E>,
RandomAccess,
Cloneable,
Serializable {
    private volatile E[] array;

    public TCopyOnWriteArrayList() {
        this.array = this.newElementArray(0);
    }

    public TCopyOnWriteArrayList(Collection<? extends E> c) {
        this.array = c.toArray();
    }

    public TCopyOnWriteArrayList(E[] array) {
        this.array = Arrays.copyOf(array, array.length);
    }

    @Override
    public boolean add(E e) {
        E[] copy = Arrays.copyOf(this.array, this.array.length + 1);
        copy[this.array.length] = e;
        this.array = copy;
        return true;
    }

    @Override
    public void add(int index, E e) {
        TCopyOnWriteArrayList.checkIndexInclusive(index, this.array.length);
        E[] copy = this.newElementArray(this.array.length + 1);
        System.arraycopy(this.array, 0, copy, 0, index);
        copy[index] = e;
        System.arraycopy(this.array, index, copy, index + 1, this.array.length - index);
        this.array = copy;
    }

    @Override
    public boolean addAll(TCollection<? extends E> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int index, TCollection<? extends E> c) {
        TCopyOnWriteArrayList.checkIndexInclusive(index, this.array.length);
        if (c.isEmpty()) {
            return false;
        }
        E[] copy = this.newElementArray(this.array.length + c.size());
        System.arraycopy(this.array, 0, copy, 0, index);
        int targetIndex = index;
        TIterator iter = c.iterator();
        while (iter.hasNext()) {
            copy[targetIndex++] = iter.next();
        }
        System.arraycopy(this.array, index, copy, targetIndex, this.array.length - index);
        this.array = copy;
        return true;
    }

    public int addAllAbsent(Collection<? extends E> c) {
        if (c.isEmpty()) {
            return 0;
        }
        E[] currentArray = this.array;
        E[] toAdd = this.newElementArray(c.size());
        int count = 0;
        for (E o : c) {
            if (this.indexOf(o) >= 0) continue;
            if (currentArray != this.array) {
                currentArray = this.array;
                break;
            }
            toAdd[count++] = o;
        }
        if (count > 0) {
            E[] copy = this.newElementArray(this.array.length + count);
            System.arraycopy(this.array, 0, copy, 0, this.array.length);
            System.arraycopy(toAdd, 0, copy, this.array.length, count);
            this.array = copy;
        }
        return count;
    }

    public boolean addIfAbsent(E e) {
        if (!this.isEmpty() && this.indexOf(e) >= 0) {
            return false;
        }
        this.add(e);
        return true;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.array = this.newElementArray(0);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("CloneNotSupportedException is not expected here");
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(TCollection<?> c) {
        return TCopyOnWriteArrayList.containsAll(c, this.array, 0, this.array.length);
    }

    private static boolean containsAll(TCollection<?> c, Object[] array, int start, int size) {
        if (size == 0) {
            return false;
        }
        TIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (TCopyOnWriteArrayList.indexOf(iter.next(), array, start, size) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        ListIterator it = l.listIterator();
        TListIterator<E> ourIt = this.listIterator();
        while (it.hasNext()) {
            Object anotherListElem;
            if (!ourIt.hasNext()) {
                return false;
            }
            Object thisListElem = it.next();
            if (Objects.equals(thisListElem, anotherListElem = ourIt.next())) continue;
            return false;
        }
        return !ourIt.hasNext();
    }

    @Override
    public E get(int index) {
        return this.array[index];
    }

    public int hashCode() {
        int hashCode = 1;
        TListIterator<E> it = this.listIterator();
        while (it.hasNext()) {
            Object obj = it.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public int indexOf(E e, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return TCopyOnWriteArrayList.indexOf(e, this.array, index, this.array.length - index);
    }

    @Override
    public int indexOf(Object o) {
        return this.indexOf(o, 0);
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public TIterator<E> iterator() {
        return this.listIterator();
    }

    public int lastIndexOf(E e, int index) {
        if (index >= this.array.length) {
            throw new IndexOutOfBoundsException();
        }
        return TCopyOnWriteArrayList.lastIndexOf(e, this.array, index, 0);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.lastIndexOf(o, this.size() - 1);
    }

    @Override
    public TListIterator<E> listIterator() {
        return new ListIteratorImpl<E>(this.array, 0);
    }

    @Override
    public TListIterator<E> listIterator(int index) {
        TCopyOnWriteArrayList.checkIndexInclusive(index, this.array.length);
        return new ListIteratorImpl<E>(this.array, index);
    }

    @Override
    public E remove(int index) {
        return this.removeRange(index, 1);
    }

    @Override
    public boolean remove(Object o) {
        int index;
        E[] currentArray;
        do {
            currentArray = this.array;
            index = this.indexOf(o);
        } while (currentArray != this.array);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(TCollection<?> c) {
        return this.removeAll(c, 0, this.array.length) != 0;
    }

    @Override
    public boolean retainAll(TCollection<?> c) {
        Objects.requireNonNull(c);
        return this.retainAll(c, 0, this.array.length) != 0;
    }

    @Override
    public E set(int index, E e) {
        int size = this.size();
        TCopyOnWriteArrayList.checkIndexExclusive(index, size);
        E[] copy = this.newElementArray(size);
        System.arraycopy(this.array, 0, copy, 0, size);
        E old = copy[index];
        copy[index] = e;
        this.array = copy;
        return old;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public TList<E> subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return TCopyOnWriteArrayList.toArray(this.array, 0, this.array.length);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return TCopyOnWriteArrayList.toArray(a, this.array, 0, this.array.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        TListIterator<E> it = this.listIterator();
        while (it.hasNext()) {
            sb.append(it.next());
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("]");
        return sb.toString();
    }

    private E[] newElementArray(int size) {
        return new Object[size];
    }

    private int removeAll(TCollection<?> c, int start, int size) {
        if (c.isEmpty() || size == 0) {
            return 0;
        }
        E[] currentArray = this.array;
        E[] data = this.newElementArray(size);
        int dataSize = 0;
        for (int i = start; i < start + size; ++i) {
            if (c.contains(this.array[i])) continue;
            if (currentArray != this.array) {
                currentArray = this.array;
                break;
            }
            data[dataSize++] = this.array[i];
        }
        if (dataSize != size) {
            E[] copy = this.newElementArray(this.array.length - (size - dataSize));
            System.arraycopy(this.array, 0, copy, 0, start);
            System.arraycopy(data, 0, copy, start, dataSize);
            System.arraycopy(this.array, start + size, copy, start + dataSize, this.array.length - (start + size));
            this.array = copy;
            return size - dataSize;
        }
        return 0;
    }

    private int retainAll(TCollection<?> c, int start, int size) {
        if (size == 0) {
            return 0;
        }
        if (c.isEmpty()) {
            E[] copy;
            if (size == this.array.length) {
                copy = this.newElementArray(0);
            } else {
                copy = this.newElementArray(this.array.length - size);
                System.arraycopy(this.array, 0, copy, 0, start);
                System.arraycopy(this.array, start + size, copy, start, this.array.length - start - size);
            }
            this.array = copy;
            return size;
        }
        E[] temp = this.newElementArray(size);
        E[] currentArray = this.array;
        int pos = 0;
        for (int i = start; i < start + size; ++i) {
            if (!c.contains(this.array[i])) continue;
            if (this.array != currentArray) {
                currentArray = this.array;
                break;
            }
            temp[pos++] = this.array[i];
        }
        if (pos == size) {
            return 0;
        }
        E[] copy = this.newElementArray(pos + this.array.length - size);
        System.arraycopy(this.array, 0, copy, 0, start);
        System.arraycopy(temp, 0, copy, start, pos);
        System.arraycopy(this.array, start + size, copy, start + pos, this.array.length - start - size);
        this.array = copy;
        return size - pos;
    }

    private E removeRange(int start, int size) {
        int sizeArr = this.size();
        TCopyOnWriteArrayList.checkIndexExclusive(start, sizeArr);
        TCopyOnWriteArrayList.checkIndexInclusive(start + size, sizeArr);
        E[] copy = this.newElementArray(sizeArr - size);
        System.arraycopy(this.array, 0, copy, 0, start);
        E old = this.array[start];
        if (sizeArr > start + size) {
            System.arraycopy(this.array, start + size, copy, start, sizeArr - (start + size));
        }
        this.array = copy;
        return old;
    }

    private static Object[] toArray(Object[] data, int start, int size) {
        Object[] result = new Object[size];
        System.arraycopy(data, start, result, 0, size);
        return result;
    }

    private static Object[] toArray(Object[] to, Object[] data, int start, int size) {
        int l = data.length;
        if (to.length < l) {
            to = (Object[])Array.newInstance(to.getClass().getComponentType(), l);
        } else if (to.length > l) {
            to[l] = null;
        }
        System.arraycopy(data, start, to, 0, size);
        return to;
    }

    private static int lastIndexOf(Object o, Object[] data, int index, int limit) {
        if (o != null) {
            while (index >= limit) {
                if (o.equals(data[index])) {
                    return index;
                }
                --index;
            }
        } else {
            while (index >= limit) {
                if (data[index] == null) {
                    return index;
                }
                --index;
            }
        }
        return -1;
    }

    private static int indexOf(Object o, Object[] data, int start, int size) {
        if (size == 0) {
            return -1;
        }
        if (o == null) {
            for (int i = start; i < start + size; ++i) {
                if (data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < start + size; ++i) {
                if (!o.equals(data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static void checkIndexInclusive(int index, int size) {
        if (index < 0 || index > size) {
            throw new TIndexOutOfBoundsException();
        }
    }

    private static void checkIndexExclusive(int index, int size) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("Index is " + index + ", size is " + size);
        }
    }

    private static class ListIteratorImpl<E>
    implements TListIterator<E> {
        private final E[] arr;
        private int current;
        private final int size;

        ListIteratorImpl(E[] data, int current) {
            this.current = current;
            this.arr = data;
            this.size = data.length;
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException("Unsupported operation add");
        }

        @Override
        public boolean hasNext() {
            return this.current < this.size;
        }

        @Override
        public boolean hasPrevious() {
            return this.current > 0;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.arr[this.current++];
            }
            throw new NoSuchElementException("pos is " + this.current + ", size is " + this.size);
        }

        @Override
        public int nextIndex() {
            return this.current;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                return this.arr[--this.current];
            }
            throw new NoSuchElementException("pos is " + (this.current - 1) + ", size is " + this.size);
        }

        @Override
        public int previousIndex() {
            return this.current - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unsupported operation remove");
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException("Unsupported operation set");
        }
    }

    private static class SubList<E>
    implements TList<E> {
        private final TCopyOnWriteArrayList<E> list;
        private E[] data;
        private int size;
        private final int start;

        SubList(TCopyOnWriteArrayList<E> list, int fromIdx, int toIdx) {
            this.list = list;
            TCopyOnWriteArrayList.checkIndexExclusive(fromIdx, list.array.length);
            TCopyOnWriteArrayList.checkIndexInclusive(toIdx, list.array.length);
            this.size = toIdx - fromIdx;
            this.data = list.array;
            this.start = fromIdx;
        }

        private void checkModifications() {
            if (this.data != this.list.array) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public TListIterator<E> listIterator(int startIdx) {
            return new SubListIterator(startIdx, this.data, this.size);
        }

        @Override
        public E set(int index, E obj) {
            TCopyOnWriteArrayList.checkIndexExclusive(index, this.size);
            this.checkModifications();
            E result = this.list.set(index + this.start, obj);
            this.data = this.list.array;
            return result;
        }

        @Override
        public E get(int index) {
            this.checkModifications();
            TCopyOnWriteArrayList.checkIndexExclusive(index, this.size);
            return this.data[index + this.start];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public E remove(int index) {
            TCopyOnWriteArrayList.checkIndexExclusive(index, this.size);
            this.checkModifications();
            E obj = this.list.remove(index + this.start);
            this.data = this.list.array;
            --this.size;
            return obj;
        }

        @Override
        public void add(int index, E object) {
            TCopyOnWriteArrayList.checkIndexInclusive(index, this.size);
            this.checkModifications();
            this.list.add(index + this.start, object);
            this.data = this.list.array;
            ++this.size;
        }

        @Override
        public boolean add(E o) {
            this.checkModifications();
            this.list.add(this.start + this.size, o);
            this.data = this.list.array;
            ++this.size;
            return true;
        }

        @Override
        public boolean addAll(TCollection<? extends E> c) {
            this.checkModifications();
            int d = this.list.size();
            this.list.addAll(this.start + this.size, c);
            this.data = this.list.array;
            this.size += this.list.size() - d;
            return true;
        }

        @Override
        public void clear() {
            this.checkModifications();
            this.list.removeRange(this.start, this.size);
            this.data = this.list.array;
            this.size = 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        @Override
        public boolean containsAll(TCollection<?> c) {
            return TCopyOnWriteArrayList.containsAll(c, this.data, this.start, this.size);
        }

        @Override
        public int indexOf(Object o) {
            int ind = TCopyOnWriteArrayList.indexOf(o, this.data, this.start, this.size);
            return ind < 0 ? -1 : ind - this.start;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public TIterator<E> iterator() {
            return new SubListIterator(0, this.data, this.size);
        }

        @Override
        public int lastIndexOf(Object o) {
            int ind = TCopyOnWriteArrayList.lastIndexOf(o, this.data, this.start + this.size - 1, this.start);
            return ind < 0 ? -1 : ind - this.start;
        }

        @Override
        public TListIterator<E> listIterator() {
            return new SubListIterator(0, this.data, this.size);
        }

        @Override
        public boolean remove(Object o) {
            boolean result;
            int i;
            E[] currentArray;
            this.checkModifications();
            do {
                currentArray = this.data;
                i = this.indexOf(o);
            } while (currentArray != this.data);
            if (i == -1) {
                return false;
            }
            boolean bl = result = this.list.remove(i + this.start) != null;
            if (result) {
                this.data = this.list.array;
                --this.size;
            }
            return result;
        }

        @Override
        public boolean removeAll(TCollection<?> c) {
            this.checkModifications();
            int removed = this.list.removeAll(c, this.start, this.size);
            if (removed > 0) {
                this.data = this.list.array;
                this.size -= removed;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(TCollection<?> c) {
            this.checkModifications();
            int removed = this.list.retainAll(c, this.start, this.size);
            if (removed > 0) {
                this.data = this.list.array;
                this.size -= removed;
                return true;
            }
            return false;
        }

        @Override
        public TList<E> subList(int fromIndex, int toIndex) {
            return new SubList<E>(this.list, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public Object[] toArray() {
            return TCopyOnWriteArrayList.toArray(this.data, this.start, this.size);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return TCopyOnWriteArrayList.toArray(a, this.data, this.start, this.size);
        }

        @Override
        public boolean addAll(int index, TCollection<? extends E> collection) {
            TCopyOnWriteArrayList.checkIndexInclusive(index, this.size);
            this.checkModifications();
            int d = this.list.size();
            boolean rt = this.list.addAll(index + this.start, collection);
            this.data = this.list.array;
            this.size += this.list.size() - d;
            return rt;
        }

        private class SubListIterator
        extends ListIteratorImpl<E> {
            int size;

            private SubListIterator(int index, E[] data, int size) {
                super(data, index + SubList.this.start);
                this.size = size;
            }

            @Override
            public int nextIndex() {
                return super.nextIndex() - SubList.this.start;
            }

            @Override
            public int previousIndex() {
                return super.previousIndex() - SubList.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() > -1;
            }
        }
    }
}

