/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.util.function.TIntConsumer;

public class TIntSummaryStatistics
implements TIntConsumer {
    private long count;
    private long sum;
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;

    public TIntSummaryStatistics() {
    }

    public TIntSummaryStatistics(long count, int min, int max, long sum) throws IllegalArgumentException {
        if (count < 0L || count > 0L && min > max) {
            throw new IllegalArgumentException();
        }
        if (count == 0L) {
            return;
        }
        this.count = count;
        this.sum = sum;
        this.min = min;
        this.max = max;
    }

    @Override
    public void accept(int value) {
        ++this.count;
        this.sum += (long)value;
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
    }

    public void combine(TIntSummaryStatistics that) {
        this.count += that.count;
        this.sum += that.sum;
        this.min = Math.min(this.min, that.min);
        this.max = Math.max(this.max, that.max);
    }

    public final long getCount() {
        return this.count;
    }

    public final long getSum() {
        return this.sum;
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public final double getAverage() {
        return this.count > 0L ? (double)this.sum / (double)this.count : 0.0;
    }

    public String toString() {
        return "IntSummaryStatistics{count=" + this.count + ", sum=" + this.sum + ", min=" + this.min + ", max=" + this.max + ", avg=" + this.getAverage() + "}";
    }
}

