/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TShortBuffer;
import org.teavm.classlib.java.nio.TShortBufferImpl;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.DataView;
import org.teavm.jso.typedarrays.Int8Array;

class TShortBufferOverDataView
extends TShortBufferImpl
implements TArrayBufferViewProvider {
    private boolean readOnly;
    private DataView data;
    private boolean littleEndian;

    TShortBufferOverDataView(int position, int limit, boolean readOnly, DataView data, boolean littleEndian) {
        super(position, limit);
        this.readOnly = readOnly;
        this.data = data;
        this.littleEndian = littleEndian;
    }

    @Override
    TShortBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        DataView slice = new DataView(this.data.getBuffer(), this.data.getByteOffset() + start * 2, capacity * 2);
        return new TShortBufferOverDataView(position, limit, readOnly, slice, this.littleEndian);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    short getElement(int index) {
        return this.data.getInt16(index * 2, this.littleEndian);
    }

    @Override
    void putElement(int index, short value) {
        this.data.setInt16(index * 2, value, this.littleEndian);
    }

    @Override
    void getImpl(int index, short[] dst, int offset, int length) {
        index *= 2;
        while (length-- > 0) {
            dst[offset++] = this.data.getInt16(index, this.littleEndian);
            index += 2;
        }
    }

    @Override
    void putImpl(int index, TShortBuffer src, int offset, int length) {
        if (src instanceof TShortBufferOverDataView) {
            TShortBufferOverDataView srcImpl = (TShortBufferOverDataView)src;
            Int8Array srcArray = new Int8Array(srcImpl.data.getBuffer(), srcImpl.data.getByteOffset() + offset * 2, length *= 2);
            Int8Array destArray = new Int8Array(this.data.getBuffer(), this.data.getByteOffset() + index * 2, length);
            destArray.set(srcArray, 0);
        } else {
            index *= 2;
            while (length-- > 0) {
                this.data.setInt16(index, src.get(offset++), this.littleEndian);
                index += 2;
            }
        }
    }

    @Override
    void putImpl(int index, short[] src, int offset, int length) {
        index *= 2;
        while (length-- > 0) {
            this.data.setInt16(index, src[offset++], this.littleEndian);
            index += 2;
        }
    }

    @Override
    boolean isArrayPresent() {
        return false;
    }

    @Override
    short[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int getArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TByteOrder order() {
        return this.littleEndian ? TByteOrder.LITTLE_ENDIAN : TByteOrder.BIG_ENDIAN;
    }

    @Override
    int capacityImpl() {
        return this.data.getByteLength() / 2;
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return this.data;
    }

    @Override
    public int elementSize() {
        return 2;
    }
}

