/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TLongBuffer;
import org.teavm.classlib.java.nio.TLongBufferImpl;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.BigInt64Array;

class TLongBufferOverTypedArray
extends TLongBufferImpl
implements TArrayBufferViewProvider {
    private boolean readOnly;
    private BigInt64Array data;
    private long[] array;

    TLongBufferOverTypedArray(int position, int limit, boolean readOnly, BigInt64Array data, long[] array) {
        super(position, limit);
        this.readOnly = readOnly;
        this.data = data;
        this.array = array;
    }

    @Override
    TLongBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        BigInt64Array slice = new BigInt64Array(this.data.getBuffer(), this.data.getByteOffset() + start * 8, capacity);
        return new TLongBufferOverTypedArray(position, limit, readOnly, slice, this.array);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    long getElement(int index) {
        return this.data.get(index);
    }

    @Override
    void putElement(int index, long value) {
        this.data.set(index, value);
    }

    @Override
    boolean isArrayPresent() {
        return this.array != null;
    }

    @Override
    long[] getArray() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int getArrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.data.getByteOffset() / 8;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.nativeOrder();
    }

    @Override
    int capacityImpl() {
        return this.data.getLength();
    }

    @Override
    void getImpl(int index, long[] dst, int offset, int length) {
        BigInt64Array slice = new BigInt64Array(this.data.getBuffer(), this.data.getByteOffset() + index * 8, length);
        BigInt64Array.fromJavaArray(dst).set(slice, offset);
    }

    @Override
    void putImpl(int index, long[] src, int offset, int length) {
        BigInt64Array slice = new BigInt64Array(BigInt64Array.fromJavaArray(src).getBuffer(), offset * 8, length);
        this.data.set(slice, index);
    }

    @Override
    void putImpl(int index, TLongBuffer src, int offset, int length) {
        if (src instanceof TLongBufferOverTypedArray) {
            TLongBufferOverTypedArray srcImpl = (TLongBufferOverTypedArray)src;
            BigInt64Array slice = new BigInt64Array(srcImpl.data.getBuffer(), srcImpl.data.getByteOffset() + index * 8, length);
            this.data.set(slice, index);
        } else {
            while (length-- > 0) {
                this.data.set(index++, src.get(offset++));
            }
        }
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return this.data;
    }

    @Override
    public int elementSize() {
        return 8;
    }
}

