/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteBufferImpl;
import org.teavm.classlib.java.nio.TLongBuffer;
import org.teavm.classlib.java.nio.TLongBufferImpl;

abstract class TLongBufferOverByteBuffer
extends TLongBufferImpl {
    TByteBufferImpl byteBuffer;
    private boolean readOnly;
    int start;
    private int capacity;

    TLongBufferOverByteBuffer(int start, int capacity, TByteBufferImpl byteBuffer, int position, int limit, boolean readOnly) {
        super(position, limit);
        this.start = start;
        this.capacity = capacity;
        this.byteBuffer = byteBuffer;
        this.readOnly = readOnly;
    }

    @Override
    boolean isArrayPresent() {
        return false;
    }

    @Override
    long[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int getArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    void getImpl(int index, long[] dst, int offset, int length) {
        while (length-- > 0) {
            dst[offset++] = this.getElement(index++);
        }
    }

    @Override
    void putImpl(int index, long[] src, int offset, int length) {
        while (length-- > 0) {
            this.putElement(index++, src[offset++]);
        }
    }

    @Override
    void putImpl(int index, TLongBuffer src, int offset, int length) {
        if (src instanceof TLongBufferOverByteBuffer && src.order() == this.order()) {
            TLongBufferOverByteBuffer srcImpl = (TLongBufferOverByteBuffer)src;
            System.arraycopy(srcImpl.byteBuffer.array, srcImpl.start + index * 8, this.byteBuffer.array, this.start + offset * 8, length * 8);
        } else {
            while (length-- > 0) {
                this.putElement(index++, src.getElement(offset++));
            }
        }
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }
}

