/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TCharBufferImpl;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.Uint16Array;

class TCharBufferOverTypedArray
extends TCharBufferImpl
implements TArrayBufferViewProvider {
    private boolean readOnly;
    private Uint16Array data;
    private char[] array;

    TCharBufferOverTypedArray(int position, int limit, boolean readOnly, Uint16Array data, char[] array) {
        super(position, limit);
        this.readOnly = readOnly;
        this.data = data;
        this.array = array;
    }

    @Override
    TCharBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        Uint16Array slice = new Uint16Array(this.data.getBuffer(), this.data.getByteOffset() + start * 2, capacity);
        return new TCharBufferOverTypedArray(position, limit, readOnly, slice, this.array);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    char getChar(int index) {
        return (char)this.data.get(index);
    }

    @Override
    void putChar(int index, char value) {
        this.data.set(index, (int)value);
    }

    @Override
    boolean isArrayPresent() {
        return this.array != null;
    }

    @Override
    char[] getArray() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int getArrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.data.getByteOffset() / 2;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.nativeOrder();
    }

    @Override
    int capacityImpl() {
        return this.data.getLength();
    }

    @Override
    void getImpl(int index, char[] dst, int offset, int length) {
        Uint16Array slice = new Uint16Array(this.data.getBuffer(), this.data.getByteOffset() + index * 2, length);
        Uint16Array.fromJavaArray(dst).set(slice, offset);
    }

    @Override
    void putImpl(int index, char[] src, int offset, int length) {
        Uint16Array slice = new Uint16Array(Uint16Array.fromJavaArray(src).getBuffer(), offset * 2, length);
        this.data.set(slice, index);
    }

    @Override
    void putImpl(int index, String src, int offset, int length) {
        while (length-- > 0) {
            this.data.set(index++, (int)src.charAt(offset++));
        }
    }

    @Override
    void putImpl(int index, TCharBuffer src, int offset, int length) {
        if (src instanceof TCharBufferOverTypedArray) {
            TCharBufferOverTypedArray srcImpl = (TCharBufferOverTypedArray)src;
            Uint16Array slice = new Uint16Array(srcImpl.data.getBuffer(), srcImpl.data.getByteOffset() + index * 2, length);
            this.data.set(slice, index);
        } else {
            while (length-- > 0) {
                this.data.set(index++, (int)src.get(offset++));
            }
        }
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return this.data;
    }

    @Override
    public int elementSize() {
        return 2;
    }
}

