/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TByteBuffer;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TCharBufferNative;
import org.teavm.classlib.java.nio.TDoubleBuffer;
import org.teavm.classlib.java.nio.TDoubleBufferNative;
import org.teavm.classlib.java.nio.TFloatBuffer;
import org.teavm.classlib.java.nio.TFloatBufferNative;
import org.teavm.classlib.java.nio.TIntBuffer;
import org.teavm.classlib.java.nio.TIntBufferNative;
import org.teavm.classlib.java.nio.TJSBufferHelper;
import org.teavm.classlib.java.nio.TLongBuffer;
import org.teavm.classlib.java.nio.TLongBufferNative;
import org.teavm.classlib.java.nio.TNativeBuffer;
import org.teavm.classlib.java.nio.TNativeBufferObjectMarker;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;
import org.teavm.classlib.java.nio.TShortBuffer;
import org.teavm.classlib.java.nio.TShortBufferNative;
import org.teavm.classlib.java.nio.file.TAddressBasedBuffer;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.Int8Array;
import org.teavm.runtime.heap.Heap;

class TByteBufferNative
extends TByteBuffer
implements TArrayBufferViewProvider,
TNativeBuffer,
TAddressBasedBuffer {
    Object gcRef;
    byte[] array;
    int arrayOffset;
    @TNativeBufferObjectMarker
    Object base;
    Address address;
    int capacity;
    boolean readOnly;
    boolean swap;

    TByteBufferNative(Object gcRef, byte[] array, int arrayOffset, Object base, Address address, int capacity, boolean readOnly) {
        this.gcRef = gcRef != null ? gcRef : this;
        this.array = array;
        this.arrayOffset = arrayOffset;
        this.base = base;
        this.address = address;
        this.capacity = capacity;
        this.readOnly = readOnly;
        this.updateSwap();
    }

    @Override
    public Address getDataAddress() {
        return this.address;
    }

    @Override
    public void release() {
        if (this.address != Address.fromInt(0)) {
            Heap.release(this.address);
            this.address = Address.fromInt(0);
        }
    }

    @Override
    void onOrderChanged() {
        this.updateSwap();
    }

    private void updateSwap() {
        this.swap = this.order != TByteOrder.nativeOrder();
    }

    @Override
    byte[] arrayImpl() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int arrayOffsetImpl() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.arrayOffset;
    }

    @Override
    boolean hasArrayImpl() {
        return this.array != null;
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }

    @Override
    void getImpl(int index, byte[] dst, int offset, int length) {
        this.copy(this.address.add(index), dst, offset, length);
    }

    @Override
    void putImpl(int index, TByteBuffer src, int offset, int length) {
        if (src instanceof TByteBufferNative) {
            TByteBufferNative srcImpl = (TByteBufferNative)src;
            TByteBufferNative.copy(srcImpl.address.add(offset), this.address.add(index), length);
        } else if (src.hasArray()) {
            this.copy(src.array(), offset + src.arrayOffset() + offset, this.address.add(index), length);
        } else {
            Address addr = this.address.add(index);
            while (length-- > 0) {
                addr.putByte(src.get(offset++));
                addr = addr.add(1);
            }
        }
    }

    @Override
    void putImpl(byte[] src, int srcOffset, int destOffset, int length) {
        this.copy(src, srcOffset, this.address.add(destOffset), length);
    }

    @Override
    public TByteBuffer slice() {
        Address newData = this.address.add(this.position);
        TByteBufferNative result = new TByteBufferNative(this.gcRef, this.array, this.arrayOffset + this.position, this.base, newData, this.remaining(), this.readOnly);
        result.position = 0;
        result.limit = result.capacity();
        result.order = TByteOrder.BIG_ENDIAN;
        return result;
    }

    @Override
    public TByteBuffer duplicate() {
        TByteBufferNative result = new TByteBufferNative(this.gcRef, this.array, this.arrayOffset + this.position, this.base, this.address, this.capacity, this.readOnly);
        result.position = this.position;
        result.limit = this.limit;
        result.mark = this.mark;
        result.order = TByteOrder.BIG_ENDIAN;
        return result;
    }

    @Override
    public TByteBuffer asReadOnlyBuffer() {
        TByteBufferNative result = new TByteBufferNative(this.gcRef, this.array, this.arrayOffset + this.position, this.base, this.address, this.capacity, true);
        result.position = this.position;
        result.limit = this.limit;
        result.mark = this.mark;
        result.order = TByteOrder.BIG_ENDIAN;
        return result;
    }

    @Override
    public byte get() {
        if (this.position >= this.limit) {
            throw new TBufferUnderflowException();
        }
        return this.address.add(this.position++).getByte();
    }

    @Override
    public TByteBuffer put(byte b) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.address.add(this.position++).putByte(b);
        return this;
    }

    @Override
    public byte get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.address.add(index).getByte();
    }

    @Override
    public TByteBuffer put(int index, byte b) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.address.add(index).putByte(b);
        return this;
    }

    @Override
    public TByteBuffer compact() {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        int sz = this.remaining();
        if (this.position > 0) {
            TByteBufferNative.copy(this.address.add(this.position), this.address, sz);
        }
        this.position = sz;
        this.limit = this.capacity();
        this.mark = -1;
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.base == null;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public char getChar() {
        if (this.position + 1 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        char result = this.address.add(this.position).getChar();
        this.position += 2;
        return this.swap ? Character.reverseBytes(result) : result;
    }

    @Override
    public TByteBuffer putChar(char value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 1 >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.address.add(this.position).putChar(this.swap ? Character.reverseBytes(value) : value);
        this.position += 2;
        return this;
    }

    @Override
    public char getChar(int index) {
        if (index < 0 || index + 1 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        char result = this.address.add(index).getChar();
        return this.swap ? Character.reverseBytes(result) : result;
    }

    @Override
    public TByteBuffer putChar(int index, char value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index + 1 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.address.add(index).putChar(this.swap ? Character.reverseBytes(value) : value);
        return this;
    }

    @Override
    public TCharBuffer asCharBuffer() {
        int sz = this.remaining() / 2;
        return new TCharBufferNative(this.gcRef, null, 0, sz, this.readOnly, this.base, this.address.add(this.position), sz, this.swap);
    }

    @Override
    public short getShort() {
        if (this.position + 1 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        short result = this.address.add(this.position).getShort();
        this.position += 2;
        return this.swap ? Short.reverseBytes(result) : result;
    }

    @Override
    public TByteBuffer putShort(short value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 1 >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.address.add(this.position).putShort(this.swap ? Short.reverseBytes(value) : value);
        this.position += 2;
        return this;
    }

    @Override
    public short getShort(int index) {
        if (index < 0 || index + 1 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        short result = this.address.add(index).getShort();
        return this.swap ? Short.reverseBytes(result) : result;
    }

    @Override
    public TByteBuffer putShort(int index, short value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index + 1 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.address.add(index).putShort(this.swap ? Short.reverseBytes(value) : value);
        return this;
    }

    @Override
    public TShortBuffer asShortBuffer() {
        int sz = this.remaining() / 2;
        return new TShortBufferNative(this.gcRef, null, 0, sz, this.readOnly, this.base, this.address.add(this.position), sz, this.swap);
    }

    @Override
    public int getInt() {
        if (this.position + 3 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        int result = this.address.add(this.position).getInt();
        this.position += 4;
        return this.swap ? Integer.reverseBytes(result) : result;
    }

    @Override
    public TByteBuffer putInt(int value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 3 >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.address.add(this.position).putInt(this.swap ? Integer.reverseBytes(value) : value);
        this.position += 4;
        return this;
    }

    @Override
    public int getInt(int index) {
        if (index < 0 || index + 3 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        int result = this.address.add(index).getInt();
        return this.swap ? Integer.reverseBytes(result) : result;
    }

    @Override
    public TByteBuffer putInt(int index, int value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index + 3 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.address.add(index).putInt(this.swap ? Integer.reverseBytes(value) : value);
        return this;
    }

    @Override
    public TIntBuffer asIntBuffer() {
        int sz = this.remaining() / 4;
        return new TIntBufferNative(this.gcRef, null, 0, sz, this.readOnly, this.base, this.address.add(this.position), sz, this.swap);
    }

    @Override
    public float getFloat() {
        if (this.position + 3 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        Address address = this.address.add(this.position);
        float result = this.swap ? Float.intBitsToFloat(Integer.reverseBytes(address.getInt())) : address.getFloat();
        this.position += 4;
        return result;
    }

    @Override
    public TByteBuffer putFloat(float value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 3 >= this.limit) {
            throw new TBufferOverflowException();
        }
        Address address = this.address.add(this.position);
        if (this.swap) {
            address.putInt(Integer.reverseBytes(Float.floatToRawIntBits(value)));
        } else {
            address.putFloat(value);
        }
        this.position += 4;
        return this;
    }

    @Override
    public TByteBuffer putFloat(int index, float value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index + 3 >= this.limit) {
            throw new TBufferOverflowException();
        }
        Address address = this.address.add(index);
        if (this.swap) {
            address.putInt(Integer.reverseBytes(Float.floatToRawIntBits(value)));
        } else {
            address.putFloat(value);
        }
        return this;
    }

    @Override
    public float getFloat(int index) {
        if (index + 3 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        Address address = this.address.add(index);
        return this.swap ? Float.intBitsToFloat(Integer.reverseBytes(address.getInt())) : address.getFloat();
    }

    @Override
    public double getDouble() {
        if (this.position + 7 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        Address address = this.address.add(this.position);
        double result = this.swap ? Double.longBitsToDouble(Long.reverseBytes(address.getLong())) : address.getDouble();
        this.position += 8;
        return result;
    }

    @Override
    public TByteBuffer putDouble(double value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 7 >= this.limit) {
            throw new TBufferOverflowException();
        }
        Address address = this.address.add(this.position);
        if (this.swap) {
            address.putLong(Long.reverseBytes(Double.doubleToRawLongBits(value)));
        } else {
            address.putDouble(value);
        }
        this.position += 8;
        return this;
    }

    @Override
    public double getDouble(int index) {
        if (index + 7 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        Address address = this.address.add(index);
        return this.swap ? Double.longBitsToDouble(Long.reverseBytes(address.getLong())) : address.getDouble();
    }

    @Override
    public TByteBuffer putDouble(int index, double value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index + 7 >= this.limit) {
            throw new TBufferOverflowException();
        }
        Address address = this.address.add(index);
        if (this.swap) {
            address.putLong(Long.reverseBytes(Double.doubleToRawLongBits(value)));
        } else {
            address.putDouble(value);
        }
        return this;
    }

    @Override
    public long getLong() {
        if (this.position + 7 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        long result = this.address.add(this.position).getLong();
        this.position += 8;
        return this.swap ? Long.reverseBytes(result) : result;
    }

    @Override
    public TByteBuffer putLong(long value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 7 >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.address.add(this.position).putLong(this.swap ? Long.reverseBytes(value) : value);
        this.position += 8;
        return this;
    }

    @Override
    public long getLong(int index) {
        if (index < 0 || index + 7 >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + (this.limit - 7) + ")");
        }
        long result = this.address.add(index).getLong();
        this.position += 8;
        return this.swap ? Long.reverseBytes(result) : result;
    }

    @Override
    public TByteBuffer putLong(int index, long value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index + 3 >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + (this.limit - 3) + ")");
        }
        this.address.add(index).putLong(this.swap ? Long.reverseBytes(value) : value);
        return this;
    }

    @Override
    public TLongBuffer asLongBuffer() {
        int sz = this.remaining() / 8;
        return new TLongBufferNative(this.gcRef, null, 0, sz, this.readOnly, this.base, this.address.add(this.position), sz, this.swap);
    }

    @Override
    public TFloatBuffer asFloatBuffer() {
        int sz = this.remaining() / 4;
        return new TFloatBufferNative(this.gcRef, null, 0, sz, this.readOnly, this.base, this.address.add(this.position), sz, this.swap);
    }

    @Override
    public TDoubleBuffer asDoubleBuffer() {
        int sz = this.remaining() / 8;
        return new TDoubleBufferNative(this.gcRef, null, 0, sz, this.readOnly, this.base, this.address.add(this.position), sz, this.swap);
    }

    void copy(byte[] from, int fromOffset, Address to, int count) {
        TByteBufferNative.copy(Address.ofData(from).add(fromOffset), to, count);
    }

    void copy(Address from, byte[] to, int toOffset, int count) {
        TByteBufferNative.copy(from, Address.ofData(to).add(toOffset), count);
    }

    static void copy(Address from, Address to, int count) {
        Address.moveMemoryBlock(from, to, count);
    }

    static TByteOrder oppositeOrder(TByteOrder order) {
        return order == TByteOrder.BIG_ENDIAN ? TByteOrder.LITTLE_ENDIAN : TByteOrder.BIG_ENDIAN;
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return new Int8Array(TJSBufferHelper.WasmGC.getLinearMemory(), this.address.toInt(), this.capacity);
    }

    @Override
    public int elementSize() {
        return 1;
    }
}

