/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.lang.annotation.Annotation;
import org.teavm.classlib.java.lang.reflect.BaseAnnotationDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class WasmGCAnnotationDependencyListener
extends BaseAnnotationDependencyListener {
    public WasmGCAnnotationDependencyListener() {
        super(true, false);
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        super.methodReached(agent, method);
        MethodReference methodRef = method.getMethod().getReference();
        if (methodRef.getClassName().equals("java.lang.Class") && methodRef.getName().equals("getDeclaredAnnotationsImpl")) {
            method.getResult().propagate(agent.getType(ValueType.arrayOf(ValueType.object(Annotation.class.getName()))));
            this.reachGetAnnotations(agent, method.getVariable(0), method.getResult().getArrayItem());
        }
    }

    private void reachGetAnnotations(DependencyAgent agent, DependencyNode inputNode, DependencyNode outputNode) {
        inputNode.getClassValueNode().addConsumer(type -> {
            if (!(type.getValueType() instanceof ValueType.Object)) {
                return;
            }
            String className = ((ValueType.Object)type.getValueType()).getClassName();
            ClassReader cls = agent.getClassSource().get(className);
            if (cls == null) {
                return;
            }
            this.annotHelper.propagateAnnotationImplementations(agent, cls.getAnnotations().all(), outputNode);
        });
    }
}

