/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.lang.annotation.Annotation;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.impl.reflection.Flags;
import org.teavm.classlib.impl.reflection.MethodCaller;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TIllegalAccessException;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.annotation.TAnnotation;
import org.teavm.classlib.java.lang.reflect.TAccessibleObject;
import org.teavm.classlib.java.lang.reflect.TInvocationTargetException;
import org.teavm.classlib.java.lang.reflect.TMember;
import org.teavm.classlib.java.lang.reflect.TModifier;
import org.teavm.platform.Platform;

public class TMethod
extends TAccessibleObject
implements TMember {
    private TClass<?> declaringClass;
    private String name;
    private int flags;
    private int accessLevel;
    private TClass<?> returnType;
    private TClass<?>[] parameterTypes;
    private MethodCaller caller;
    private Object[] declaredAnnotations;

    public TMethod(TClass<?> declaringClass, String name, int flags, int accessLevel, TClass<?> returnType, TClass<?>[] parameterTypes, MethodCaller caller, Annotation[] declaredAnnotations) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.flags = flags;
        this.accessLevel = accessLevel;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.caller = caller;
        this.declaredAnnotations = declaredAnnotations;
    }

    @Override
    public TClass<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return Flags.getModifiers(this.flags, this.accessLevel);
    }

    public TClass<?> getReturnType() {
        return this.returnType;
    }

    public TClass<?>[] getParameterTypes() {
        return (TClass[])this.parameterTypes.clone();
    }

    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TModifier.toString(this.getModifiers(), (this.getDeclaringClass().getModifiers() & 0x200) != 0));
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(this.getReturnType().getName()).append(' ').append(this.getDeclaringClass().getName()).append('.').append(this.name).append('(');
        TClass<?>[] parameterTypes = this.getParameterTypes();
        if (parameterTypes.length > 0) {
            sb.append(parameterTypes[0].getName());
            for (int i = 1; i < parameterTypes.length; ++i) {
                sb.append(',').append(parameterTypes[i].getName());
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public Object invoke(Object obj, Object ... args) throws TIllegalAccessException, TIllegalArgumentException, TInvocationTargetException {
        if (this.caller == null) {
            throw new TIllegalAccessException();
        }
        if (args.length != this.parameterTypes.length) {
            throw new TIllegalArgumentException();
        }
        if ((this.flags & 0x200) == 0) {
            if (!this.declaringClass.isInstance((TObject)obj)) {
                throw new TIllegalArgumentException();
            }
        } else if (PlatformDetector.isJavaScript()) {
            Platform.initClass(this.declaringClass.getPlatformClass());
        }
        for (int i = 0; i < args.length; ++i) {
            if (!this.parameterTypes[i].isPrimitive() && args[i] != null && !this.parameterTypes[i].isInstance((TObject)args[i])) {
                throw new TIllegalArgumentException();
            }
            if (!this.parameterTypes[i].isPrimitive() || args[i] != null) continue;
            throw new TIllegalArgumentException();
        }
        return this.caller.call(obj, args);
    }

    public boolean isBridge() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isVarArgs() {
        return (this.flags & 0x2000) != 0;
    }

    @Override
    public TAnnotation[] getDeclaredAnnotations() {
        return this.declaredAnnotations != null ? (TAnnotation[])this.declaredAnnotations.clone() : new TAnnotation[]{};
    }
}

