/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.lang.reflect.Array;
import java.util.Set;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.backend.javascript.templating.JavaScriptTemplate;
import org.teavm.backend.javascript.templating.JavaScriptTemplateFactory;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ArrayNativeGenerator
implements Generator {
    private JavaScriptTemplate template;

    public ArrayNativeGenerator(JavaScriptTemplateFactory templateFactory) {
        this.template = templateFactory.createFromResource("org/teavm/classlib/java/lang/reflect/Array.js");
    }

    @Override
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) {
        if (methodRef.getName().equals("newInstanceImpl")) {
            this.generateNewInstance(context, writer);
            return;
        }
        this.template.builder(methodRef.getName()).withContext(context).build().write(writer, 0);
    }

    private void generateNewInstance(GeneratorContext context, SourceWriter writer) {
        MethodDependencyInfo dependency = context.getDependency().getMethod(new MethodReference(Array.class, "newInstance", Class.class, Integer.TYPE, Object.class));
        this.template.builder("newInstanceImpl").withContext(context).withFragment("primitiveArrays", (w, p) -> {
            w.append("switch").ws().append("(").append(context.getParameterName(1)).append(")").appendBlockStart();
            String length = context.getParameterName(2);
            Set<ValueType> types = Set.of(dependency.getResult().getTypes());
            if (types.contains("[Z")) {
                this.writeArrayClause(w, "$rt_booleanArrayCls", "$rt_createBooleanArray", length);
            }
            if (types.contains("[B")) {
                this.writeArrayClause(w, "$rt_byteArrayCls", "$rt_createByteArray", length);
            }
            if (types.contains("[C")) {
                this.writeArrayClause(w, "$rt_charArrayCls", "$rt_createCharArray", length);
            }
            if (types.contains("[S")) {
                this.writeArrayClause(w, "$rt_shortArrayCls", "$rt_createShortArray", length);
            }
            if (types.contains("[I")) {
                this.writeArrayClause(w, "$rt_intArrayCls", "$rt_createIntArray", length);
            }
            if (types.contains("[J")) {
                this.writeArrayClause(w, "$rt_longArrayCls", "$rt_createLongArray", length);
            }
            if (types.contains("~F")) {
                this.writeArrayClause(w, "$rt_floatArrayCls", "$rt_createFloatArray", length);
            }
            if (types.contains("~D")) {
                this.writeArrayClause(w, "$rt_doubleArrayCls", "$rt_createDoubleArray", length);
            }
            w.appendBlockEnd();
        }).build().write(writer, 0);
    }

    private void writeArrayClause(SourceWriter writer, String test, String construct, String length) {
        writer.append("case ").appendFunction(test).append(":").ws().append("return ").appendFunction(construct).append("(").append(length).append(");").softNewLine();
    }
}

