/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.io.TUnsupportedEncodingException;
import org.teavm.classlib.java.lang.StringNativeDependency;
import org.teavm.classlib.java.lang.TCharSequence;
import org.teavm.classlib.java.lang.TCharacter;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TStringBuffer;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.classlib.java.lang.TStringIndexOutOfBoundsException;
import org.teavm.classlib.java.nio.TByteBuffer;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.charset.TCharset;
import org.teavm.classlib.java.nio.charset.impl.TUTF8Charset;
import org.teavm.classlib.java.util.TArrays;
import org.teavm.classlib.java.util.TComparator;
import org.teavm.classlib.java.util.TFormatter;
import org.teavm.classlib.java.util.TLocale;
import org.teavm.classlib.java.util.regex.TPattern;
import org.teavm.classlib.java.util.stream.TIntStream;
import org.teavm.classlib.java.util.stream.intimpl.TStringCharsStream;
import org.teavm.classlib.java.util.stream.intimpl.TStringCodePointsStream;
import org.teavm.dependency.PluggableDependency;
import org.teavm.interop.NoSideEffects;

public class TString
extends TObject
implements TSerializable,
TComparable<TString>,
TCharSequence {
    private static final char[] EMPTY_CHARS = new char[0];
    private static final TString EMPTY = new TString();
    public static final TComparator<TString> CASE_INSENSITIVE_ORDER = (o1, o2) -> o1.compareToIgnoreCase((TString)o2);
    private transient int hashCode;

    public TString() {
        this.initWithEmptyChars();
    }

    @NoSideEffects
    private native void initWithEmptyChars();

    public TString(TString other) {
        this.borrowChars(other);
    }

    @NoSideEffects
    private native void borrowChars(TString var1);

    public TString(char[] characters) {
        this.initWithCharArray(characters, 0, characters.length);
    }

    public TString(Object nativeString) {
    }

    private native Object nativeString();

    public TString(char[] value, int offset, int count) {
        Objects.checkFromIndexSize(offset, count, value.length);
        this.initWithCharArray(value, offset, count);
    }

    @NoSideEffects
    private native void initWithCharArray(char[] var1, int var2, int var3);

    static TString fromArray(char[] characters) {
        TString s = new TString();
        s.takeCharArray(characters);
        return s;
    }

    @NoSideEffects
    private native void takeCharArray(char[] var1);

    public TString(byte[] bytes, int offset, int length, TString charsetName) throws TUnsupportedEncodingException {
        this.initWithBytes(bytes, offset, length, TCharset.forName(charsetName.toString()));
    }

    public TString(byte[] bytes, int offset, int length, TCharset charset) {
        this.initWithBytes(bytes, offset, length, charset);
    }

    public TString(byte[] bytes, int offset, int length) {
        this.initWithBytes(bytes, offset, length, TUTF8Charset.INSTANCE);
    }

    public TString(byte[] bytes) {
        this.initWithBytes(bytes, 0, bytes.length, TUTF8Charset.INSTANCE);
    }

    public TString(byte[] bytes, TString charsetName) throws TUnsupportedEncodingException {
        this.initWithBytes(bytes, 0, bytes.length, TCharset.forName(charsetName.toString()));
    }

    public TString(byte[] bytes, TCharset charset) {
        this.initWithBytes(bytes, 0, bytes.length, charset);
    }

    public TString(int[] codePoints, int offset, int count) {
        char[] characters = new char[count * 2];
        int charCount = 0;
        for (int i = 0; i < count; ++i) {
            int codePoint;
            if ((codePoint = codePoints[offset++]) >= 65536) {
                characters[charCount++] = TCharacter.highSurrogate(codePoint);
                characters[charCount++] = TCharacter.lowSurrogate(codePoint);
                continue;
            }
            characters[charCount++] = (char)codePoint;
        }
        if (charCount < characters.length) {
            characters = TArrays.copyOf(characters, charCount);
        }
        this.takeCharArray(characters);
    }

    private void initWithBytes(byte[] bytes, int offset, int length, TCharset charset) {
        char[] characters;
        TCharBuffer buffer = charset.decode(TByteBuffer.wrap(bytes, offset, length));
        if (buffer.hasArray() && buffer.position() == 0 && buffer.limit() == buffer.capacity()) {
            characters = buffer.array();
        } else {
            characters = new char[buffer.remaining()];
            buffer.get(characters);
        }
        this.takeCharArray(characters);
    }

    public TString(TStringBuffer sb) {
        this.initWithCharArray(sb.buffer, 0, sb.length());
    }

    public TString(TStringBuilder sb) {
        this.initWithCharArray(sb.buffer, 0, sb.length());
    }

    private TString(int length) {
        this.takeCharArray(new char[length]);
    }

    private static TString allocate(int size) {
        return new TString(size);
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.charactersLength()) {
            throw new TStringIndexOutOfBoundsException();
        }
        return this.charactersGet(index);
    }

    public int codePointAt(int index) {
        return TCharacter.codePointAt(this, index);
    }

    public int codePointBefore(int index) {
        return TCharacter.codePointBefore(this, index);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        return TCharacter.codePointCount(this, beginIndex, endIndex);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        return TCharacter.offsetByCodePoints(this, index, codePointOffset);
    }

    @Override
    public int length() {
        return this.charactersLength();
    }

    @NoSideEffects
    private native int charactersLength();

    @NoSideEffects
    private native char charactersGet(int var1);

    @Override
    public boolean isEmpty() {
        return this.charactersLength() == 0;
    }

    public boolean isBlank() {
        for (int i = 0; i < this.charactersLength(); ++i) {
            if (this.charactersGet(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0 || srcBegin > srcEnd || srcEnd > this.length() || dstBegin < 0 || dstBegin + (srcEnd - srcBegin) > dst.length) {
            throw new TIndexOutOfBoundsException();
        }
        this.copyCharsToArray(srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    @NoSideEffects
    private native void copyCharsToArray(int var1, char[] var2, int var3, int var4);

    public boolean contentEquals(TStringBuffer buffer) {
        if (this.charactersLength() != buffer.length()) {
            return false;
        }
        for (int i = 0; i < this.charactersLength(); ++i) {
            if (this.charactersGet(i) == buffer.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean contentEquals(TCharSequence charSeq) {
        if (this == charSeq) {
            return true;
        }
        if (this.charactersLength() != charSeq.length()) {
            return false;
        }
        for (int i = 0; i < this.charactersLength(); ++i) {
            if (this.charactersGet(i) == charSeq.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TString anotherString) {
        if (this == anotherString) {
            return 0;
        }
        int l = TMath.min(this.length(), anotherString.length());
        for (int i = 0; i < l; ++i) {
            char b;
            char a = this.charAt(i);
            if (a - (b = anotherString.charAt(i)) == 0) continue;
            return a - b;
        }
        return this.length() - anotherString.length();
    }

    public int compareToIgnoreCase(TString anotherString) {
        if (this == anotherString) {
            return 0;
        }
        int l = TMath.min(this.length(), anotherString.length());
        for (int i = 0; i < l; ++i) {
            char b;
            char a = TCharacter.toLowerCase(this.charAt(i));
            if (a - (b = TCharacter.toLowerCase(anotherString.charAt(i))) == 0) continue;
            return a - b;
        }
        return this.length() - anotherString.length();
    }

    public boolean startsWith(TString prefix, int toffset) {
        if (toffset + prefix.length() > this.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (prefix.charAt(i) == this.charAt(toffset++)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(TString prefix) {
        if (this == prefix) {
            return true;
        }
        return this.startsWith(prefix, 0);
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
        if (toffset < 0 || ooffset < 0 || toffset + len > this.length() || ooffset + len > other.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char a = this.charAt(toffset++);
            char b = other.charAt(ooffset++);
            if (ignoreCase) {
                a = TCharacter.toLowerCase(a);
                b = TCharacter.toLowerCase(b);
            }
            if (a == b) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(int toffset, TString other, int ooffset, int len) {
        if (toffset < 0 || ooffset < 0 || toffset + len > this.length() || ooffset + len > other.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.charAt(toffset++) == other.charAt(ooffset++)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(TString suffix) {
        if (this == suffix) {
            return true;
        }
        if (suffix.length() > this.length()) {
            return false;
        }
        int j = 0;
        for (int i = this.length() - suffix.length(); i < this.length(); ++i) {
            if (this.charAt(i) == suffix.charAt(j++)) continue;
            return false;
        }
        return true;
    }

    public int indexOf(int ch, int fromIndex) {
        fromIndex = Math.max(0, fromIndex);
        if (ch < 65536) {
            char bmpChar = (char)ch;
            for (int i = fromIndex; i < this.charactersLength(); ++i) {
                if (this.charactersGet(i) != bmpChar) continue;
                return i;
            }
            return -1;
        }
        char hi = TCharacter.highSurrogate(ch);
        char lo = TCharacter.lowSurrogate(ch);
        for (int i = fromIndex; i < this.charactersLength() - 1; ++i) {
            if (this.charactersGet(i) != hi || this.charactersGet(i + 1) != lo) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int lastIndexOf(int ch, int fromIndex) {
        fromIndex = Math.min(fromIndex, this.length() - 1);
        if (ch < 65536) {
            char bmpChar = (char)ch;
            for (int i = fromIndex; i >= 0; --i) {
                if (this.charactersGet(i) != bmpChar) continue;
                return i;
            }
            return -1;
        }
        char hi = TCharacter.highSurrogate(ch);
        char lo = TCharacter.lowSurrogate(ch);
        for (int i = fromIndex; i >= 1; --i) {
            if (this.charactersGet(i) != lo || this.charactersGet(i - 1) != hi) continue;
            return i - 1;
        }
        return -1;
    }

    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.length() - 1);
    }

    public int indexOf(TString str, int fromIndex) {
        fromIndex = Math.max(0, fromIndex);
        int toIndex = this.length() - str.length();
        block0: for (int i = fromIndex; i <= toIndex; ++i) {
            for (int j = 0; j < str.length(); ++j) {
                if (this.charAt(i + j) != str.charAt(j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public int indexOf(TString str) {
        return this.indexOf(str, 0);
    }

    public int lastIndexOf(TString str, int fromIndex) {
        block0: for (int i = fromIndex = Math.min(fromIndex, this.length() - str.length()); i >= 0; --i) {
            for (int j = 0; j < str.length(); ++j) {
                if (this.charAt(i + j) != str.charAt(j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public int lastIndexOf(TString str) {
        return this.lastIndexOf(str, this.length());
    }

    public TString substring(int beginIndex, int endIndex) {
        int length = this.charactersLength();
        if (beginIndex == endIndex) {
            return EMPTY;
        }
        if (beginIndex == 0 && endIndex == length) {
            return this;
        }
        if (PlatformDetector.isJavaScript()) {
            if (beginIndex < 0 || beginIndex > endIndex || endIndex > length) {
                throw new TStringIndexOutOfBoundsException();
            }
            return new TString(TString.substringJS(this.nativeString(), beginIndex, endIndex));
        }
        return new TString(this.fastCharArray(), beginIndex, endIndex - beginIndex);
    }

    @NoSideEffects
    private static native Object substringJS(Object var0, int var1, int var2);

    public TString substring(int beginIndex) {
        return this.substring(beginIndex, this.length());
    }

    @Override
    public TCharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public TString concat(TString str) {
        int i;
        if (str.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return str;
        }
        char[] buffer = new char[this.length() + str.length()];
        int index = 0;
        for (i = 0; i < this.length(); ++i) {
            buffer[index++] = this.charAt(i);
        }
        for (i = 0; i < str.length(); ++i) {
            buffer[index++] = str.charAt(i);
        }
        return TString.fromArray(buffer);
    }

    public TString replace(char oldChar, char newChar) {
        if (oldChar == newChar) {
            return this;
        }
        char[] buffer = new char[this.length()];
        for (int i = 0; i < this.length(); ++i) {
            buffer[i] = this.charAt(i) == oldChar ? newChar : this.charAt(i);
        }
        return TString.fromArray(buffer);
    }

    public boolean contains(TCharSequence s) {
        int sz = this.length() - s.length();
        block0: for (int i = 0; i <= sz; ++i) {
            for (int j = 0; j < s.length(); ++j) {
                if (this.charAt(i + j) != s.charAt(j)) continue block0;
            }
            return true;
        }
        return false;
    }

    public String replace(TCharSequence target, TCharSequence replacement) {
        int i;
        if (target == replacement) {
            return (String)((Object)this);
        }
        if (target.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < this.length(); ++i2) {
                sb.append(replacement);
                sb.append(this.charAt(i2));
            }
            sb.append(replacement);
            return sb.toString();
        }
        if (target.length() == 1 && replacement.length() == 1) {
            return (String)((Object)this.replace(target.charAt(0), replacement.charAt(0)));
        }
        StringBuilder sb = new StringBuilder();
        int sz = this.length() - target.length();
        block1: for (i = 0; i <= sz; ++i) {
            for (int j = 0; j < target.length(); ++j) {
                if (this.charAt(i + j) == target.charAt(j)) continue;
                sb.append(this.charAt(i));
                continue block1;
            }
            sb.append(replacement);
            i += target.length() - 1;
        }
        sb.append(this.substring(i));
        return sb.toString();
    }

    public TString trim() {
        int lower;
        int upper = this.length() - 1;
        for (lower = 0; lower <= upper && this.charAt(lower) <= ' '; ++lower) {
        }
        while (lower <= upper && this.charAt(upper) <= ' ') {
            --upper;
        }
        return this.substring(lower, upper + 1);
    }

    public TString strip() {
        int lower;
        if (PlatformDetector.isJavaScript()) {
            Object result = TString.stripJS(this.nativeString());
            return result != this.nativeString() ? new TString(result) : this;
        }
        int upper = this.length() - 1;
        for (lower = 0; lower <= upper && Character.isWhitespace(this.charAt(lower)); ++lower) {
        }
        while (lower <= upper && Character.isWhitespace(this.charAt(upper))) {
            --upper;
        }
        return this.substring(lower, upper + 1);
    }

    private static native Object stripJS(Object var0);

    public TString stripLeading() {
        int lower;
        if (PlatformDetector.isJavaScript()) {
            Object result = TString.stripLeadingJS(this.nativeString());
            return result != this.nativeString() ? new TString(result) : this;
        }
        for (lower = 0; lower < this.length() && Character.isWhitespace(this.charAt(lower)); ++lower) {
        }
        return this.substring(lower, this.length());
    }

    private static native Object stripLeadingJS(Object var0);

    public TString stripTrailing() {
        int upper;
        if (PlatformDetector.isJavaScript()) {
            Object result = TString.stripTrailingJS(this.nativeString());
            return result != this.nativeString() ? new TString(result) : this;
        }
        for (upper = this.length() - 1; 0 <= upper && Character.isWhitespace(this.charAt(upper)); --upper) {
        }
        return this.substring(0, upper + 1);
    }

    private static native Object stripTrailingJS(Object var0);

    @Override
    public String toString() {
        return (String)((Object)this);
    }

    public char[] toCharArray() {
        char[] array = new char[this.charactersLength()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.charAt(i);
        }
        return array;
    }

    @Override
    public TIntStream chars() {
        return new TStringCharsStream(this);
    }

    @Override
    public TIntStream codePoints() {
        return new TStringCodePointsStream(this);
    }

    public static String valueOf(Object obj) {
        return obj != null ? obj.toString() : "null";
    }

    public static TString valueOf(char[] data) {
        return new TString(data);
    }

    public static TString valueOf(char[] data, int offset, int count) {
        return new TString(data, offset, count);
    }

    public static TString copyValueOf(char[] data) {
        return TString.valueOf(data);
    }

    public static TString copyValueOf(char[] data, int offset, int count) {
        return TString.valueOf(data, offset, count);
    }

    public static String valueOf(boolean b) {
        return b ? "true" : "false";
    }

    public static String valueOf(char c) {
        return new String(new char[]{c});
    }

    public static String valueOf(int i) {
        return new TStringBuilder().append(i).toString();
    }

    public static String valueOf(long l) {
        return new TStringBuilder().append(l).toString();
    }

    public static String valueOf(float f) {
        return new TStringBuilder().append(f).toString();
    }

    public static String valueOf(double d) {
        return new TStringBuilder().append(d).toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TString)) {
            return false;
        }
        TString str = (TString)other;
        if (PlatformDetector.isJavaScript()) {
            return this.nativeString() == str.nativeString();
        }
        if (str.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (this.charAt(i) == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(TString other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.length() != other.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (TCharacter.toLowerCase(this.charAt(i)) == TCharacter.toLowerCase(other.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public byte[] getBytes(TString charsetName) throws TUnsupportedEncodingException {
        try {
            return this.getBytes(TCharset.forName(charsetName.toString()));
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException x) {
            throw new TUnsupportedEncodingException();
        }
    }

    public byte[] getBytes() {
        return this.getBytes(TUTF8Charset.INSTANCE);
    }

    public byte[] getBytes(TCharset charset) {
        TByteBuffer buffer = charset.encode(TCharBuffer.wrap(this.fastCharArray()));
        if (buffer.hasArray() && buffer.position() == 0 && buffer.limit() == buffer.capacity()) {
            return buffer.array();
        }
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    @NoSideEffects
    private native char[] fastCharArray();

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            for (int i = 0; i < this.charactersLength(); ++i) {
                this.hashCode = 31 * this.hashCode + this.charactersGet(i);
            }
        }
        return this.hashCode;
    }

    public TString toLowerCase() {
        if (PlatformDetector.isJavaScript()) {
            Object lowerCase = TString.toLowerCaseJS(this.nativeString());
            return lowerCase != this.nativeString() ? new TString(lowerCase) : this;
        }
        if (this.isEmpty()) {
            return this;
        }
        boolean hasCharsToTransform = false;
        boolean hasSurrogates = false;
        for (int i = 0; i < this.charactersLength(); ++i) {
            char c = this.charactersGet(i);
            if (Character.toLowerCase(c) != c) {
                hasCharsToTransform = true;
                break;
            }
            if (!Character.isSurrogate(c)) continue;
            hasSurrogates = true;
        }
        if (!hasCharsToTransform) {
            return this;
        }
        return hasSurrogates ? this.toLowerCaseCodePoints() : this.toLowerCaseChars();
    }

    @NoSideEffects
    private static native Object toLowerCaseJS(Object var0);

    @NoSideEffects
    private static native Object toLowerCaseJS(Object var0, Object var1);

    private TString toLowerCaseChars() {
        char[] chars = new char[this.charactersLength()];
        for (int i = 0; i < this.charactersLength(); ++i) {
            chars[i] = TCharacter.toLowerCase(this.charactersGet(i));
        }
        return new TString(chars);
    }

    private TString toLowerCaseCodePoints() {
        int[] codePoints = new int[this.charactersLength()];
        int codePointCount = 0;
        int length = this.charactersLength();
        for (int i = 0; i < this.charactersLength(); ++i) {
            if (i == length - 1 || !TCharacter.isHighSurrogate(this.charactersGet(i)) || !TCharacter.isLowSurrogate(this.charactersGet(i + 1))) {
                codePoints[codePointCount++] = TCharacter.toLowerCase(this.charactersGet(i));
                continue;
            }
            codePoints[codePointCount++] = TCharacter.toLowerCase(TCharacter.toCodePoint(this.charactersGet(i), this.charactersGet(i + 1)));
            ++i;
        }
        return new TString(codePoints, 0, codePointCount);
    }

    public TString toLowerCase(TLocale locale) {
        if (PlatformDetector.isJavaScript()) {
            Object upperCase = TString.toLowerCaseJS(this.nativeString(), locale.toLanguageTag().nativeString());
            return upperCase != this.nativeString() ? new TString(upperCase) : this;
        }
        return this.toLowerCase();
    }

    public TString toUpperCase() {
        if (PlatformDetector.isJavaScript()) {
            Object upperCase = TString.toUpperCaseJS(this.nativeString());
            return upperCase != this.nativeString() ? new TString(upperCase) : this;
        }
        if (this.isEmpty()) {
            return this;
        }
        boolean hasCharsToTransform = false;
        boolean hasSurrogates = false;
        for (int i = 0; i < this.charactersLength(); ++i) {
            char c = this.charactersGet(i);
            if (Character.toUpperCase(c) != c) {
                hasCharsToTransform = true;
                break;
            }
            if (!Character.isSurrogate(c)) continue;
            hasSurrogates = true;
        }
        if (!hasCharsToTransform) {
            return this;
        }
        return hasSurrogates ? this.toUpperCaseCodePoints() : this.toUpperCaseChars();
    }

    @NoSideEffects
    private static native Object toUpperCaseJS(Object var0);

    @NoSideEffects
    private static native Object toUpperCaseJS(Object var0, Object var1);

    private TString toUpperCaseChars() {
        char[] chars = new char[this.charactersLength()];
        for (int i = 0; i < this.charactersLength(); ++i) {
            chars[i] = TCharacter.toUpperCase(this.charactersGet(i));
        }
        return new TString(chars);
    }

    private TString toUpperCaseCodePoints() {
        int[] codePoints = new int[this.charactersLength()];
        int codePointCount = 0;
        for (int i = 0; i < this.charactersLength(); ++i) {
            if (i == this.charactersLength() - 1 || !TCharacter.isHighSurrogate(this.charactersGet(i)) || !TCharacter.isLowSurrogate(this.charactersGet(i + 1))) {
                codePoints[codePointCount++] = TCharacter.toUpperCase(this.charactersGet(i));
                continue;
            }
            codePoints[codePointCount++] = TCharacter.toUpperCase(TCharacter.toCodePoint(this.charactersGet(i), this.charactersGet(i + 1)));
            ++i;
        }
        return new TString(codePoints, 0, codePointCount);
    }

    public TString toUpperCase(TLocale locale) {
        if (PlatformDetector.isJavaScript()) {
            Object upperCase = TString.toUpperCaseJS(this.nativeString(), locale.toLanguageTag().nativeString());
            return upperCase != this.nativeString() ? new TString(upperCase) : this;
        }
        return this.toUpperCase();
    }

    @NoSideEffects
    @PluggableDependency(value=StringNativeDependency.class)
    public native TString intern();

    public boolean matches(String regex) {
        return TPattern.matches(regex, this.toString());
    }

    public String[] split(String regex) {
        return TPattern.compile(regex).split(this.toString());
    }

    public String[] split(String regex, int limit) {
        return TPattern.compile(regex).split(this.toString(), limit);
    }

    public String replaceAll(String regex, String replacement) {
        return TPattern.compile(regex).matcher(this.toString()).replaceAll(replacement);
    }

    public String replaceFirst(String regex, String replacement) {
        return TPattern.compile(regex).matcher(this.toString()).replaceFirst(replacement);
    }

    public static String format(String format, Object ... args) {
        return new TFormatter().format(format, args).toString();
    }

    public static String format(Locale l, String format, Object ... args) {
        return new TFormatter(l).format(format, args).toString();
    }

    public String formatted(Object ... args) {
        return TString.format((String)((Object)this), args);
    }

    public static TString join(CharSequence delimiter, CharSequence ... elements) {
        int i;
        if (elements.length == 0) {
            return EMPTY;
        }
        int resultLength = 0;
        for (CharSequence element : elements) {
            resultLength += element.length();
        }
        char[] chars = new char[resultLength += (elements.length - 1) * delimiter.length()];
        int index = 0;
        CharSequence firstElement = elements[0];
        for (i = 0; i < firstElement.length(); ++i) {
            chars[index++] = firstElement.charAt(i);
        }
        for (i = 1; i < elements.length; ++i) {
            for (int j = 0; j < delimiter.length(); ++j) {
                chars[index++] = delimiter.charAt(j);
            }
            CharSequence element = elements[i];
            for (int j = 0; j < element.length(); ++j) {
                chars[index++] = element.charAt(j);
            }
        }
        return TString.fromArray(chars);
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        Iterator<? extends CharSequence> iter = elements.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(iter.next());
        while (iter.hasNext()) {
            sb.append(delimiter);
            sb.append(iter.next());
        }
        return sb.toString();
    }

    public TString repeat(int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        if (count == 1) {
            return this;
        }
        if (this.charactersLength() == 0 || count == 0) {
            return EMPTY;
        }
        char[] chars = new char[this.charactersLength() * count];
        int j = 0;
        for (int i = 0; i < count; ++i) {
            this.getChars(0, this.length(), chars, j);
            j += this.length();
        }
        return TString.fromArray(chars);
    }

    public TString translateEscapes() {
        for (int i = 0; i < this.length(); ++i) {
            char c = this.charAt(i);
            if (c != '\\') continue;
            return this.translateEscapesImpl();
        }
        return this;
    }

    private TString translateEscapesImpl() {
        char[] chars = new char[this.length()];
        int j = 0;
        for (int i = 0; i < this.length(); ++i) {
            char c = this.charAt(i);
            if (c == '\\') {
                if (++i == this.length()) break;
                switch (this.charAt(i)) {
                    case 'b': {
                        chars[j++] = 8;
                        break;
                    }
                    case 't': {
                        chars[j++] = 9;
                        break;
                    }
                    case 'n': {
                        chars[j++] = 10;
                        break;
                    }
                    case 'f': {
                        chars[j++] = 12;
                        break;
                    }
                    case 'r': {
                        chars[j++] = 13;
                        break;
                    }
                    case 's': {
                        chars[j++] = 32;
                        break;
                    }
                    case '\"': {
                        chars[j++] = 34;
                        break;
                    }
                    case '\'': {
                        chars[j++] = 39;
                        break;
                    }
                    case '\\': {
                        chars[j++] = 92;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        int value = 0;
                        int max = Math.min(3, this.length() - i);
                        for (int k = 0; k < max && (c = this.charAt(i)) >= '0' && c <= '7'; ++k) {
                            value = (value << 3) + (c - 48);
                            ++i;
                        }
                        chars[j++] = (char)value;
                        break;
                    }
                }
                continue;
            }
            chars[j++] = c;
        }
        return new TString(chars, 0, j);
    }

    public TString stripIndent() {
        int bestIndentation = Integer.MAX_VALUE;
        int i = 0;
        block0: while (i < this.length()) {
            char c;
            int currentIndentation = 0;
            while (Character.isWhitespace(c = this.charAt(i)) && c != '\n' && c != '\r') {
                ++currentIndentation;
                if (++i != this.length()) continue;
                break block0;
            }
            if (currentIndentation == 0) {
                return this;
            }
            bestIndentation = Math.min(bestIndentation, currentIndentation);
            while (i < this.length()) {
                if ((c = this.charAt(i++)) == '\r') {
                    if (i >= this.length() || this.charAt(i) != '\n') continue block0;
                    ++i;
                    continue block0;
                }
                if (c != '\n') continue;
                continue block0;
            }
        }
        if (bestIndentation == Integer.MAX_VALUE) {
            return EMPTY;
        }
        char[] result = new char[this.length()];
        int outIndex = 0;
        i = 0;
        block3: while (i < this.length()) {
            i += bestIndentation;
            while (i < this.length()) {
                char c;
                if ((c = this.charAt(i++)) == '\r') {
                    if (i < this.length() && this.charAt(i) == '\n') {
                        ++i;
                    }
                    result[outIndex++] = 10;
                    continue block3;
                }
                if (c == '\n') {
                    result[outIndex++] = 10;
                    continue block3;
                }
                result[outIndex++] = c;
            }
        }
        return new TString(result, 0, outIndex);
    }
}

