/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.util.ArrayDeque;
import java.util.Queue;
import org.teavm.backend.wasm.runtime.gc.WasmGCSupport;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.lang.ObjectDependencyPlugin;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TCloneNotSupportedException;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TIllegalMonitorStateException;
import org.teavm.classlib.java.lang.TInteger;
import org.teavm.classlib.java.lang.TInterruptedException;
import org.teavm.classlib.java.lang.TThread;
import org.teavm.classlib.java.lang.TThreadInterruptHandler;
import org.teavm.classlib.java.lang.TThrowable;
import org.teavm.dependency.PluggableDependency;
import org.teavm.interop.Address;
import org.teavm.interop.Async;
import org.teavm.interop.AsyncCallback;
import org.teavm.interop.DelegateTo;
import org.teavm.interop.NoSideEffects;
import org.teavm.interop.Rename;
import org.teavm.interop.Structure;
import org.teavm.interop.Superclass;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.browser.TimerHandler;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformObject;
import org.teavm.platform.PlatformRunnable;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.EventQueue;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;

@Superclass(value="")
public class TObject {
    Monitor monitor;

    static void monitorEnterSync(TObject o) {
        if (Thread.currentThread() == null) {
            return;
        }
        if (o.monitor == null) {
            TObject.createMonitor(o);
        }
        if (o.monitor.owner == null) {
            o.monitor.owner = TThread.currentThread();
        } else if (o.monitor.owner != TThread.currentThread()) {
            throw new IllegalStateException("Can't enter monitor from another thread synchronously");
        }
        ++o.monitor.count;
    }

    static void monitorExitSync(TObject o) {
        if (Thread.currentThread() == null) {
            return;
        }
        if (o.isEmptyMonitor() || o.monitor.owner != TThread.currentThread()) {
            throw new TIllegalMonitorStateException();
        }
        if (--o.monitor.count == 0) {
            o.monitor.owner = null;
        }
        o.isEmptyMonitor();
    }

    static void monitorEnter(TObject o) {
        TObject.monitorEnter(o, 1);
    }

    static void monitorEnter(TObject o, int count) {
        if (o.monitor == null) {
            TObject.createMonitor(o);
        }
        if (o.monitor.owner == null) {
            o.monitor.owner = TThread.currentThread();
        }
        if (o.monitor.owner != TThread.currentThread()) {
            TObject.monitorEnterWait(o, count);
        } else {
            o.monitor.count += count;
        }
    }

    private static void createMonitor(TObject o) {
        if (PlatformDetector.isLowLevel()) {
            int hashCode = TObject.hashCodeLowLevel(o);
            o.monitor = new Monitor();
            o.monitor.id = hashCode;
        } else {
            o.monitor = new Monitor();
        }
    }

    @Async
    static native void monitorEnterWait(TObject var0, int var1);

    static void monitorEnterWait(TObject o, int count, AsyncCallback<Void> callback) {
        TThread thread = TThread.currentThread();
        if (o.monitor == null) {
            TObject.createMonitor(o);
            TThread.setCurrentThread(thread);
            o.monitor.count += count;
            callback.complete(null);
            return;
        }
        if (o.monitor.owner == null) {
            o.monitor.owner = thread;
            TThread.setCurrentThread(thread);
            o.monitor.count += count;
            callback.complete(null);
            return;
        }
        Monitor monitor = o.monitor;
        if (monitor.enteringThreads == null) {
            monitor.enteringThreads = new ArrayDeque<PlatformRunnable>();
        }
        monitor.enteringThreads.add(() -> {
            TThread.setCurrentThread(thread);
            o.monitor.owner = thread;
            o.monitor.count += count;
            callback.complete(null);
        });
    }

    static void monitorExit(TObject o) {
        TObject.monitorExit(o, 1);
    }

    static void monitorExit(TObject o, int count) {
        if (o.isEmptyMonitor() || o.monitor.owner != TThread.currentThread()) {
            throw new TIllegalMonitorStateException();
        }
        Monitor monitor = o.monitor;
        monitor.count -= count;
        if (monitor.count > 0) {
            return;
        }
        monitor.owner = null;
        if (monitor.enteringThreads != null && !monitor.enteringThreads.isEmpty()) {
            if (PlatformDetector.isLowLevel() || PlatformDetector.isWebAssemblyGC()) {
                EventQueue.offer(() -> TObject.waitForOtherThreads(o));
            } else {
                Platform.postpone(() -> TObject.waitForOtherThreads(o));
            }
        } else {
            o.isEmptyMonitor();
        }
    }

    private static void waitForOtherThreads(TObject o) {
        if (o.isEmptyMonitor() || o.monitor.owner != null) {
            return;
        }
        Monitor monitor = o.monitor;
        if (monitor.enteringThreads != null && !monitor.enteringThreads.isEmpty()) {
            Queue<PlatformRunnable> enteringThreads = monitor.enteringThreads;
            PlatformRunnable r = enteringThreads.remove();
            monitor.enteringThreads = null;
            r.run();
        }
    }

    final boolean isEmptyMonitor() {
        Monitor monitor = this.monitor;
        if (monitor == null) {
            return true;
        }
        if (monitor.owner == null && (monitor.enteringThreads == null || monitor.enteringThreads.isEmpty()) && (monitor.notifyListeners == null || monitor.notifyListeners.isEmpty())) {
            this.deleteMonitor();
            return true;
        }
        return false;
    }

    private void deleteMonitor() {
        if (PlatformDetector.isLowLevel()) {
            int id = this.monitor.id;
            TObject.setHashCodeLowLevel(this, id);
        } else if (PlatformDetector.isWebAssemblyGC()) {
            this.setWasmGCIdentity(this.monitor.id);
        } else {
            this.monitor = null;
        }
    }

    static boolean holdsLock(TObject o) {
        return o.monitor != null && o.monitor.owner == TThread.currentThread();
    }

    @Rename(value="fakeInit")
    public TObject() {
    }

    @Rename(value="<init>")
    private void init() {
    }

    @Rename(value="getClass")
    public final TClass<?> getClass0() {
        return TClass.getClass(Platform.getPlatformObject(this).getPlatformClass());
    }

    public int hashCode() {
        return this.identity();
    }

    public boolean equals(Object obj) {
        return this.equals0((TObject)obj);
    }

    @Rename(value="equals")
    public boolean equals0(TObject other) {
        return this == other;
    }

    public String toString() {
        return this.getClass().getName() + "@" + TInteger.toHexString(this.identity());
    }

    private String obfuscatedToString() {
        return "<java_object>@" + Integer.toHexString(this.identity());
    }

    final int identity() {
        if (PlatformDetector.isWebAssemblyGC()) {
            int identity = this.wasmGCIdentity();
            if (identity < 0) {
                Monitor monitor = this.monitor;
                if (monitor != null) {
                    if (monitor.id < 0) {
                        monitor.id = WasmGCSupport.nextObjectId() & 0x7FFFFFF;
                    }
                    return monitor.id;
                }
                identity = WasmGCSupport.nextObjectId() & 0x7FFFFFF;
                this.setWasmGCIdentity(identity);
            }
            return identity;
        }
        if (PlatformDetector.isLowLevel()) {
            Monitor monitor = this.monitor;
            if (monitor == null) {
                int hashCode = TObject.hashCodeLowLevel(this);
                if (hashCode == 0) {
                    hashCode = TObject.identityLowLevel();
                    TObject.setHashCodeLowLevel(this, hashCode);
                }
                return hashCode;
            }
            int hashCode = monitor.id;
            if (hashCode == 0) {
                monitor.id = hashCode = TObject.identityLowLevel();
            }
            return hashCode;
        }
        PlatformObject platformThis = Platform.getPlatformObject(this);
        if (platformThis.getId() == 0) {
            platformThis.setId(Platform.nextObjectId());
        }
        return Platform.getPlatformObject(this).getId();
    }

    private native int wasmGCIdentity();

    private native void setWasmGCIdentity(int var1);

    @NoSideEffects
    @Unmanaged
    @DelegateTo(value="hashCodeLowLevelImpl")
    private static native int hashCodeLowLevel(TObject var0);

    @Unmanaged
    private static int hashCodeLowLevelImpl(RuntimeObject obj) {
        return obj.hashCode;
    }

    @NoSideEffects
    @Unmanaged
    @DelegateTo(value="setHashCodeLowLevelImpl")
    private static native void setHashCodeLowLevel(TObject var0, int var1);

    @Unmanaged
    private static void setHashCodeLowLevelImpl(RuntimeObject obj, int value) {
        obj.hashCode = value;
    }

    @Unmanaged
    private static int identityLowLevel() {
        int result;
        if ((result = RuntimeObject.nextId++) == 0 && (result = RuntimeObject.nextId++) == Integer.MIN_VALUE) {
            result = 1;
        }
        return result;
    }

    @NoSideEffects
    @DelegateTo(value="identityOrMonitorLowLevel")
    private native int identityOrMonitor();

    private static int identityOrMonitorLowLevel(RuntimeObject object) {
        return object.hashCode;
    }

    @NoSideEffects
    @DelegateTo(value="setIdentityLowLevel")
    native void setIdentity(int var1);

    private static void setIdentityLowLevel(RuntimeObject object, int id) {
        object.hashCode = id;
    }

    @DelegateTo(value="cloneLowLevel")
    @PluggableDependency(value=ObjectDependencyPlugin.class)
    protected Object clone() throws TCloneNotSupportedException {
        if (PlatformDetector.isWebAssemblyGC()) {
            return this.cloneObject();
        }
        if (!(this instanceof TCloneable) && Platform.getPlatformObject(this).getPlatformClass().getMetadata().getArrayItem() == null) {
            throw new TCloneNotSupportedException();
        }
        Object result = Platform.clone(this);
        Platform.getPlatformObject(result).setId(Platform.nextObjectId());
        return result;
    }

    private native TObject cloneObject();

    private static RuntimeObject cloneLowLevel(RuntimeObject self) {
        int size;
        RuntimeObject copy;
        RuntimeClass cls = RuntimeClass.getClass(self);
        int skip = Structure.sizeOf(RuntimeObject.class);
        if (cls.itemType == null) {
            copy = (RuntimeObject)Allocator.allocate(cls).toStructure();
            size = cls.size;
        } else {
            RuntimeArray array = (RuntimeArray)self;
            copy = (RuntimeObject)Allocator.allocateArray(cls, array.size).toStructure();
            int itemSize = (cls.itemType.flags & 2) == 0 ? Address.sizeOf() : cls.itemType.size;
            Address headerSize = Address.align(Address.fromInt(Structure.sizeOf(RuntimeArray.class)), itemSize);
            size = itemSize * array.size + headerSize.toInt();
        }
        if (size > skip) {
            Address.moveMemoryBlock(self.toAddress().add(skip), copy.toAddress().add(skip), size - skip);
        }
        return copy;
    }

    @Rename(value="notify")
    public final void notify0() {
        if (!TObject.holdsLock(this)) {
            throw new TIllegalMonitorStateException();
        }
        Queue<NotifyListener> listeners = this.monitor.notifyListeners;
        if (listeners == null) {
            return;
        }
        while (!listeners.isEmpty()) {
            NotifyListener listener = listeners.remove();
            if (listener.expired()) continue;
            if (PlatformDetector.isLowLevel() || PlatformDetector.isWebAssemblyGC()) {
                EventQueue.offer(listener);
                break;
            }
            Platform.postpone(listener);
            break;
        }
        if (listeners.isEmpty()) {
            this.monitor.notifyListeners = null;
        }
    }

    @Rename(value="notifyAll")
    public final void notifyAll0() {
        if (!TObject.holdsLock(this)) {
            throw new TIllegalMonitorStateException();
        }
        Queue<NotifyListener> listeners = this.monitor.notifyListeners;
        if (listeners == null) {
            return;
        }
        while (!listeners.isEmpty()) {
            NotifyListener listener = listeners.remove();
            if (listener.expired()) continue;
            if (PlatformDetector.isLowLevel() || PlatformDetector.isWebAssemblyGC()) {
                EventQueue.offer(listener);
                continue;
            }
            Platform.postpone(listener);
        }
        this.monitor.notifyListeners = null;
    }

    @Rename(value="wait")
    public final void wait0(long timeout) throws TInterruptedException {
        try {
            this.wait(timeout, 0);
        }
        catch (InterruptedException ex) {
            throw new TInterruptedException();
        }
    }

    @Rename(value="wait")
    private void wait0(long timeout, int nanos) throws TInterruptedException {
        if (!TObject.holdsLock(this)) {
            throw new TIllegalMonitorStateException();
        }
        this.waitImpl(timeout, nanos);
    }

    @Async
    private native void waitImpl(long var1, int var3) throws TInterruptedException;

    final void waitImpl(long timeout, int nanos, AsyncCallback<Void> callback) {
        Monitor monitor = this.monitor;
        NotifyListenerImpl listener = new NotifyListenerImpl(this, callback, monitor.count);
        if (monitor.notifyListeners == null) {
            monitor.notifyListeners = new ArrayDeque<NotifyListener>();
        }
        monitor.notifyListeners.add(listener);
        TThread.currentThread().interruptHandler = listener;
        if (timeout > 0L || nanos > 0) {
            int timeoutToSchedule = timeout >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeout;
            listener.timerId = PlatformDetector.isLowLevel() || PlatformDetector.isWebAssemblyGC() ? EventQueue.offer(listener, (long)timeoutToSchedule + System.currentTimeMillis()) : Platform.schedule(listener, timeoutToSchedule);
        }
        TObject.monitorExit(this, monitor.count);
    }

    @Rename(value="wait")
    public final void wait0() throws TInterruptedException {
        try {
            this.wait(0L);
        }
        catch (InterruptedException ex) {
            throw new TInterruptedException();
        }
    }

    protected void finalize() throws TThrowable {
    }

    static class Monitor {
        static final int MASK = Integer.MIN_VALUE;
        Queue<PlatformRunnable> enteringThreads;
        Queue<NotifyListener> notifyListeners;
        TThread owner = TThread.currentThread();
        int count;
        int id;

        Monitor() {
        }
    }

    static interface NotifyListener
    extends PlatformRunnable,
    EventQueue.Event {
        public boolean expired();
    }

    static class NotifyListenerImpl
    implements NotifyListener,
    TimerHandler,
    PlatformRunnable,
    TThreadInterruptHandler {
        final TObject obj;
        final AsyncCallback<Void> callback;
        final TThread currentThread = TThread.currentThread();
        int timerId = -1;
        boolean expired;
        boolean performed;
        int lockCount;

        NotifyListenerImpl(TObject obj, AsyncCallback<Void> callback, int lockCount) {
            this.obj = obj;
            this.callback = callback;
            this.lockCount = lockCount;
        }

        @Override
        public boolean expired() {
            boolean result = this.expired;
            this.expired = true;
            return result;
        }

        @Override
        public void onTimer() {
            if (PlatformDetector.isLowLevel() || PlatformDetector.isWebAssemblyGC()) {
                EventQueue.offer(() -> {
                    if (!this.expired()) {
                        this.run();
                    }
                });
            } else {
                Platform.postpone(() -> {
                    if (!this.expired()) {
                        this.run();
                    }
                });
            }
        }

        @Override
        public void run() {
            if (this.performed) {
                return;
            }
            this.performed = true;
            if (this.timerId >= 0) {
                if (PlatformDetector.isLowLevel() || PlatformDetector.isWebAssemblyGC()) {
                    EventQueue.kill(this.timerId);
                } else {
                    Platform.killSchedule(this.timerId);
                }
                this.timerId = -1;
            }
            TThread.setCurrentThread(this.currentThread);
            TObject.monitorEnterWait(this.obj, this.lockCount, this.callback);
        }

        @Override
        public void interrupted() {
            if (this.performed) {
                return;
            }
            this.performed = true;
            if (this.timerId >= 0) {
                if (PlatformDetector.isLowLevel() || PlatformDetector.isWebAssemblyGC()) {
                    EventQueue.kill(this.timerId);
                } else {
                    Platform.killSchedule(this.timerId);
                }
                this.timerId = -1;
            }
            if (PlatformDetector.isLowLevel() || PlatformDetector.isWebAssemblyGC()) {
                EventQueue.offer(() -> this.callback.error(new TInterruptedException()));
            } else {
                Platform.postpone(() -> this.callback.error(new TInterruptedException()));
            }
        }
    }
}

