/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.impl.reflection.ClassList;
import org.teavm.classlib.impl.reflection.ClassSupport;
import org.teavm.classlib.impl.reflection.FieldInfo;
import org.teavm.classlib.impl.reflection.FieldInfoList;
import org.teavm.classlib.impl.reflection.FieldReader;
import org.teavm.classlib.impl.reflection.FieldWriter;
import org.teavm.classlib.impl.reflection.Flags;
import org.teavm.classlib.impl.reflection.JSClass;
import org.teavm.classlib.impl.reflection.JSField;
import org.teavm.classlib.impl.reflection.JSMethodMember;
import org.teavm.classlib.impl.reflection.MethodCaller;
import org.teavm.classlib.impl.reflection.MethodInfo;
import org.teavm.classlib.impl.reflection.MethodInfoList;
import org.teavm.classlib.java.lang.ClassDependencyListener;
import org.teavm.classlib.java.lang.ClassGenerator;
import org.teavm.classlib.java.lang.TClassCastException;
import org.teavm.classlib.java.lang.TClassLoader;
import org.teavm.classlib.java.lang.TClassNotFoundException;
import org.teavm.classlib.java.lang.TIllegalAccessException;
import org.teavm.classlib.java.lang.TInstantiationException;
import org.teavm.classlib.java.lang.TNoSuchFieldException;
import org.teavm.classlib.java.lang.TNoSuchMethodException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TPackage;
import org.teavm.classlib.java.lang.TSecurityException;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.annotation.TAnnotation;
import org.teavm.classlib.java.lang.reflect.TAnnotatedElement;
import org.teavm.classlib.java.lang.reflect.TConstructor;
import org.teavm.classlib.java.lang.reflect.TField;
import org.teavm.classlib.java.lang.reflect.TMethod;
import org.teavm.classlib.java.lang.reflect.TModifier;
import org.teavm.classlib.java.lang.reflect.TType;
import org.teavm.dependency.PluggableDependency;
import org.teavm.interop.Address;
import org.teavm.interop.DelegateTo;
import org.teavm.interop.NoSideEffects;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.JSObject;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.core.JSObjects;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformClass;
import org.teavm.platform.PlatformObject;
import org.teavm.platform.PlatformSequence;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;

public final class TClass<T>
extends TObject
implements TAnnotatedElement,
TType {
    private static Map<String, TClass<?>> nameMap;
    String name;
    String simpleName;
    String canonicalName;
    private PlatformClass platformClass;
    private TAnnotation[] annotationsCache;
    private TAnnotation[] declaredAnnotationsCache;
    private Map<TClass<?>, TAnnotation> annotationsByType;
    private TField[] declaredFields;
    private TField[] fields;
    private TConstructor<T>[] declaredConstructors;
    private TMethod[] declaredMethods;
    private static boolean reflectionInitialized;

    private TClass(PlatformClass platformClass) {
        this.platformClass = platformClass;
        platformClass.setJavaClass(Platform.getPlatformObject(this));
    }

    public static TClass<?> getClass(PlatformClass cls) {
        if (cls == null) {
            return null;
        }
        TClass result = (TClass)((Object)Platform.asJavaClass(cls.getJavaClass()));
        if (result == null) {
            result = new TClass(cls);
        }
        return result;
    }

    @Override
    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    private String obfuscatedToString() {
        return "javaClass@" + this.identity();
    }

    public PlatformClass getPlatformClass() {
        return this.platformClass;
    }

    @DelegateTo(value="isInstanceLowLevel")
    public boolean isInstance(TObject obj) {
        if (PlatformDetector.isWebAssemblyGC()) {
            return obj != null && this.isAssignableFrom((TClass)((Object)obj.getClass()));
        }
        return Platform.isInstance(Platform.getPlatformObject(obj), this.platformClass);
    }

    @Unmanaged
    private boolean isInstanceLowLevel(RuntimeObject obj) {
        return obj != null && this.isAssignableFromLowLevel(RuntimeClass.getClass(obj));
    }

    @DelegateTo(value="isAssignableFromLowLevel")
    public boolean isAssignableFrom(TClass<?> obj) {
        return Platform.isAssignable(obj.getPlatformClass(), this.platformClass);
    }

    @Unmanaged
    private boolean isAssignableFromLowLevel(RuntimeClass other) {
        return ((RuntimeClass)Address.ofObject((Object)this).toStructure()).isSupertypeOf.apply(other);
    }

    public String getName() {
        if (PlatformDetector.isWebAssemblyGC()) {
            TClass<?> componentType;
            String componentName;
            Object result = this.getNameImpl();
            if (result == null && this.isArray() && (componentName = (componentType = this.getComponentType()).getName()) != null) {
                result = componentType.isArray() ? "[" + componentName : "[L" + componentName + ";";
                this.setNameImpl((String)result);
            }
            return result;
        }
        if (PlatformDetector.isLowLevel()) {
            Object result = TClass.getNameCache(this);
            if (result == null) {
                TClass<?> componentType;
                String componentName;
                result = Platform.getName(this.platformClass);
                if (result == null && this.isArray() && (componentName = (componentType = this.getComponentType()).getName()) != null) {
                    result = componentType.isArray() ? "[" + componentName : "[L" + componentName + ";";
                }
                TClass.setNameCache(this, (String)result);
            }
            return result;
        }
        if (this.name == null) {
            this.name = Platform.getName(this.platformClass);
        }
        return this.name;
    }

    @PluggableDependency(value=ClassDependencyListener.class)
    private native String getNameImpl();

    private native void setNameImpl(String var1);

    public String getSimpleName() {
        Object simpleName = TClass.getSimpleNameCache(this);
        if (simpleName == null) {
            if (this.isArray()) {
                simpleName = this.getComponentType().getSimpleName() + "[]";
            } else if (this.getEnclosingClass() != null) {
                Object object = simpleName = PlatformDetector.isWebAssemblyGC() ? TClass.getSimpleNameCache(this) : Platform.getSimpleName(this.platformClass);
                if (simpleName == null) {
                    simpleName = "";
                }
            } else {
                String name = PlatformDetector.isWebAssemblyGC() ? this.getName() : Platform.getName(this.platformClass);
                int lastDollar = name.lastIndexOf(36);
                if (lastDollar != -1) {
                    if ((name = name.substring(lastDollar + 1)).charAt(0) >= '0' && name.charAt(0) <= '9') {
                        name = "";
                    }
                } else {
                    int lastDot = name.lastIndexOf(46);
                    if (lastDot != -1) {
                        name = name.substring(lastDot + 1);
                    }
                }
                simpleName = name;
            }
            TClass.setSimpleNameCache(this, (String)simpleName);
        }
        return simpleName;
    }

    @DelegateTo(value="getSimpleNameCacheLowLevel")
    private static String getSimpleNameCache(TClass<?> self) {
        return self.simpleName;
    }

    @Unmanaged
    @PluggableDependency(value=ClassDependencyListener.class)
    private static RuntimeObject getSimpleNameCacheLowLevel(RuntimeClass self) {
        return self.simpleNameCache;
    }

    @DelegateTo(value="setSimpleNameCacheLowLevel")
    private static void setSimpleNameCache(TClass<?> self, String value) {
        self.simpleName = value;
    }

    @Unmanaged
    private static void setSimpleNameCacheLowLevel(RuntimeClass self, RuntimeObject object) {
        self.simpleNameCache = object;
    }

    @DelegateTo(value="getNameCacheLowLevel")
    private static String getNameCache(TClass<?> self) {
        return self.name;
    }

    @Unmanaged
    @PluggableDependency(value=ClassDependencyListener.class)
    private static RuntimeObject getNameCacheLowLevel(RuntimeClass self) {
        return self.nameCache;
    }

    @DelegateTo(value="setNameCacheLowLevel")
    private static void setNameCache(TClass<?> self, String value) {
        self.name = value;
    }

    @Unmanaged
    private static void setNameCacheLowLevel(RuntimeClass self, RuntimeObject object) {
        self.nameCache = object;
    }

    public String getCanonicalName() {
        Object result = this.getCanonicalNameCache();
        if (result == null) {
            if (this.isArray()) {
                String componentName = this.getComponentType().getCanonicalName();
                if (componentName == null) {
                    return null;
                }
                result = componentName + "[]";
            } else if (this.getEnclosingClass() != null) {
                if (this.getDeclaringClass() == null || this.isSynthetic()) {
                    return null;
                }
                String enclosingName = this.getDeclaringClass().getCanonicalName();
                if (enclosingName == null) {
                    return null;
                }
                result = enclosingName + "." + this.getSimpleName();
            } else {
                result = this.getName();
            }
            this.setCanonicalNameCache((String)result);
        }
        return result;
    }

    private boolean isSynthetic() {
        if (PlatformDetector.isWebAssemblyGC()) {
            return (this.getWasmGCFlags() & 0x4000) != 0;
        }
        if (PlatformDetector.isJavaScript()) {
            return (this.platformClass.getMetadata().getAccessLevel() & 0x20) != 0;
        }
        return (RuntimeClass.getClass((RuntimeObject)((RuntimeObject)Address.ofObject((Object)this).toStructure())).flags & 0x4000) != 0;
    }

    @DelegateTo(value="getCanonicalNameCacheLowLevel")
    private String getCanonicalNameCache() {
        return this.canonicalName;
    }

    @Unmanaged
    @PluggableDependency(value=ClassDependencyListener.class)
    private RuntimeObject getCanonicalNameCacheLowLevel() {
        return ((RuntimeClass)Address.ofObject((Object)this).toStructure()).canonicalName;
    }

    @DelegateTo(value="setCanonicalNameCacheLowLevel")
    private void setCanonicalNameCache(String value) {
        this.canonicalName = value;
    }

    @Unmanaged
    private void setCanonicalNameCacheLowLevel(RuntimeObject object) {
        ((RuntimeClass)Address.ofObject((Object)this).toStructure()).canonicalName = object;
    }

    public boolean isPrimitive() {
        if (PlatformDetector.isWebAssemblyGC()) {
            return (this.getWasmGCFlags() & 0x40000) != 0;
        }
        return Platform.isPrimitive(this.platformClass);
    }

    public boolean isArray() {
        if (PlatformDetector.isWebAssemblyGC()) {
            return this.getComponentType() != null;
        }
        return Platform.getArrayItem(this.platformClass) != null;
    }

    public boolean isEnum() {
        if (PlatformDetector.isWebAssemblyGC()) {
            return (this.getWasmGCFlags() & 0x1000) != 0;
        }
        return Platform.isEnum(this.platformClass);
    }

    public boolean isInterface() {
        if (PlatformDetector.isWebAssemblyGC()) {
            return (this.getWasmGCFlags() & 0x200) != 0;
        }
        return (this.platformClass.getMetadata().getFlags() & 2) != 0;
    }

    public boolean isAnnotation() {
        if (PlatformDetector.isWebAssemblyGC()) {
            return (this.getWasmGCFlags() & 0x2000) != 0;
        }
        return (this.platformClass.getMetadata().getFlags() & 0x10) != 0;
    }

    public boolean isLocalClass() {
        if (PlatformDetector.isWebAssemblyGC()) {
            return (this.getWasmGCFlags() & 0x4000) != 0 && this.getEnclosingClass() != null;
        }
        return (this.platformClass.getMetadata().getFlags() & 0x20) != 0 && this.getEnclosingClass() != null;
    }

    public boolean isMemberClass() {
        return this.getDeclaringClass() != null;
    }

    private native int getWasmGCFlags();

    @PluggableDependency(value=ClassGenerator.class)
    public TClass<?> getComponentType() {
        return TClass.getClass(Platform.getArrayItem(this.platformClass));
    }

    public TField[] getDeclaredFields() throws TSecurityException {
        block7: {
            if (this.isPrimitive() || this.isArray()) {
                return new TField[0];
            }
            if (this.declaredFields != null) break block7;
            TClass.initReflection();
            if (PlatformDetector.isJavaScript()) {
                JSClass jsClass = (JSClass)this.getPlatformClass().getMetadata();
                JSArray<JSField> jsFields = jsClass.getFields();
                this.declaredFields = new TField[jsFields.getLength()];
                for (int i = 0; i < jsFields.getLength(); ++i) {
                    JSField jsField = jsFields.get(i);
                    this.declaredFields[i] = new TField(this, jsField.getName(), jsField.getModifiers(), jsField.getAccessLevel(), TClass.getClass(jsField.getType()), FieldReader.forJs(jsField.getGetter()), FieldWriter.forJs(jsField.getSetter()), !JSObjects.isUndefined(jsField.getAnnotations()) ? Platform.annotationsFromJS(jsField.getAnnotations()) : null);
                }
            } else {
                FieldInfoList infoList = this.getDeclaredFieldsImpl();
                if (infoList == null) {
                    this.declaredFields = new TField[0];
                } else {
                    this.declaredFields = new TField[infoList.count()];
                    for (int i = 0; i < this.declaredFields.length; ++i) {
                        FieldInfo fieldInfo = infoList.get(i);
                        this.declaredFields[i] = new TField(this, fieldInfo.name(), fieldInfo.modifiers(), fieldInfo.accessLevel(), (TClass)((Object)fieldInfo.type()), fieldInfo.reader(), fieldInfo.writer(), fieldInfo.annotations());
                    }
                }
            }
        }
        return (TField[])this.declaredFields.clone();
    }

    private native FieldInfoList getDeclaredFieldsImpl();

    private static void initReflection() {
        if (!reflectionInitialized) {
            reflectionInitialized = true;
            TClass.createMetadata();
        }
    }

    @GeneratedBy(value=ClassGenerator.class)
    @NoSideEffects
    private static native void createMetadata();

    public TField[] getFields() throws TSecurityException {
        if (this.isPrimitive() || this.isArray()) {
            return new TField[0];
        }
        if (this.fields == null) {
            ArrayList<TField> fieldList = new ArrayList<TField>();
            TClass<T> cls = this;
            if (cls.isInterface()) {
                TClass.getFieldsOfInterfaces(cls, fieldList, new HashSet());
            } else {
                while (cls != null) {
                    for (TField field : cls.getDeclaredFields()) {
                        if (!Modifier.isPublic(field.getModifiers())) continue;
                        fieldList.add(field);
                    }
                    cls = cls.getSuperclass();
                }
            }
            this.fields = fieldList.toArray(new TField[fieldList.size()]);
        }
        return (TField[])this.fields.clone();
    }

    public TField getDeclaredField(String name) throws TNoSuchFieldException {
        for (TField field : this.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw new TNoSuchFieldException();
    }

    public TField getField(String name) throws TNoSuchFieldException {
        TField result = this.findField(name, new HashSet<String>());
        if (result == null) {
            throw new TNoSuchFieldException();
        }
        return result;
    }

    private TField findField(String name, Set<String> visited) {
        TField field;
        if (!visited.add(name)) {
            return null;
        }
        for (TField tField : this.getDeclaredFields()) {
            if (!TModifier.isPublic(tField.getModifiers()) || !tField.getName().equals(name)) continue;
            return tField;
        }
        for (TAnnotatedElement tAnnotatedElement : this.getInterfaces()) {
            TField field3 = ((TClass)tAnnotatedElement).findField(name, visited);
            if (field3 == null) continue;
            return field3;
        }
        TClass<T> superclass = this.getSuperclass();
        if (superclass != null && (field = superclass.findField(name, visited)) != null) {
            return field;
        }
        return null;
    }

    @InjectedBy(value=ClassGenerator.class)
    @PluggableDependency(value=ClassGenerator.class)
    public native PlatformObject newEmptyInstance();

    public TConstructor<?>[] getDeclaredConstructors() throws TSecurityException {
        if (this.isPrimitive() || this.isArray()) {
            return new TConstructor[0];
        }
        if (this.declaredConstructors == null) {
            TClass.initReflection();
            if (PlatformDetector.isJavaScript()) {
                JSClass jsClass = (JSClass)this.getPlatformClass().getMetadata();
                JSArray<JSMethodMember> jsMethods = jsClass.getMethods();
                this.declaredConstructors = new TConstructor[jsMethods.getLength()];
                int count = 0;
                for (int i = 0; i < jsMethods.getLength(); ++i) {
                    JSMethodMember jsMethod = jsMethods.get(i);
                    if (!jsMethod.getName().equals("<init>")) continue;
                    PlatformSequence<PlatformClass> jsParameterTypes = jsMethod.getParameterTypes();
                    TClass[] parameterTypes = new TClass[jsParameterTypes.getLength()];
                    for (int j = 0; j < parameterTypes.length; ++j) {
                        parameterTypes[j] = TClass.getClass(jsParameterTypes.get(j));
                    }
                    JSObject annotations = jsMethod.getAnnotations();
                    this.declaredConstructors[count++] = new TConstructor(this, jsMethod.getName(), jsMethod.getModifiers(), jsMethod.getAccessLevel(), parameterTypes, MethodCaller.forJs(jsMethod.getCallable()), !JSObjects.isUndefined(annotations) ? Platform.annotationsFromJS(jsMethod.getAnnotations()) : null);
                }
                this.declaredConstructors = Arrays.copyOf(this.declaredConstructors, count);
            } else {
                MethodInfoList methodInfoList = this.getDeclaredMethodsImpl();
                if (methodInfoList == null) {
                    this.declaredConstructors = new TConstructor[0];
                } else {
                    this.declaredConstructors = new TConstructor[methodInfoList.count()];
                    int count = 0;
                    for (int i = 0; i < methodInfoList.count(); ++i) {
                        MethodInfo methodInfo = methodInfoList.get(i);
                        if (!methodInfo.name().equals("<init>")) continue;
                        ClassList paramTypeInfoList = methodInfo.parameterTypes();
                        TClass[] parameterTypes = new TClass[paramTypeInfoList.count()];
                        for (int j = 0; j < parameterTypes.length; ++j) {
                            parameterTypes[j] = (TClass)((Object)paramTypeInfoList.get(j));
                        }
                        this.declaredConstructors[count++] = new TConstructor(this, methodInfo.name(), methodInfo.modifiers(), methodInfo.accessLevel(), parameterTypes, methodInfo.caller(), methodInfo.annotations());
                    }
                    this.declaredConstructors = Arrays.copyOf(this.declaredConstructors, count);
                }
            }
        }
        return (TConstructor[])this.declaredConstructors.clone();
    }

    public TConstructor<?>[] getConstructors() throws TSecurityException {
        TConstructor<?>[] declaredConstructors = this.getDeclaredConstructors();
        TConstructor[] constructors = new TConstructor[declaredConstructors.length];
        int sz = 0;
        for (TConstructor<?> constructor : declaredConstructors) {
            if (!TModifier.isPublic(constructor.getModifiers())) continue;
            constructors[sz++] = constructor;
        }
        if (sz < constructors.length) {
            constructors = Arrays.copyOf(constructors, sz);
        }
        return constructors;
    }

    public TConstructor<T> getDeclaredConstructor(TClass<?> ... parameterTypes) throws TSecurityException, TNoSuchMethodException {
        for (TConstructor<?> constructor : this.getDeclaredConstructors()) {
            if (!Arrays.equals(constructor.getParameterTypes(), parameterTypes)) continue;
            return constructor;
        }
        throw new TNoSuchMethodException();
    }

    public TConstructor<T> getConstructor(TClass<?> ... parameterTypes) throws TSecurityException, TNoSuchMethodException {
        for (TConstructor<?> constructor : this.getDeclaredConstructors()) {
            if (!TModifier.isPublic(constructor.getModifiers()) || !Arrays.equals(constructor.getParameterTypes(), parameterTypes)) continue;
            return constructor;
        }
        throw new TNoSuchMethodException();
    }

    private static void getFieldsOfInterfaces(TClass<?> iface, List<TField> fields, Set<TClass<?>> visited) {
        if (!visited.add(iface)) {
            return;
        }
        for (TField tField : iface.getDeclaredFields()) {
            if (!Modifier.isPublic(tField.getModifiers())) continue;
            fields.add(tField);
        }
        for (TAnnotatedElement tAnnotatedElement : iface.getInterfaces()) {
            TClass.getFieldsOfInterfaces(tAnnotatedElement, fields, visited);
        }
    }

    public TMethod[] getDeclaredMethods() {
        if (this.isPrimitive() || this.isArray()) {
            return new TMethod[0];
        }
        if (this.declaredMethods == null) {
            TClass.initReflection();
            if (PlatformDetector.isJavaScript()) {
                JSClass jsClass = (JSClass)this.getPlatformClass().getMetadata();
                JSArray<JSMethodMember> jsMethods = jsClass.getMethods();
                this.declaredMethods = new TMethod[jsMethods.getLength()];
                int count = 0;
                for (int i = 0; i < jsMethods.getLength(); ++i) {
                    JSMethodMember jsMethod = jsMethods.get(i);
                    if (jsMethod.getName().equals("<init>") || jsMethod.getName().equals("<clinit>")) continue;
                    PlatformSequence<PlatformClass> jsParameterTypes = jsMethod.getParameterTypes();
                    TClass[] parameterTypes = new TClass[jsParameterTypes.getLength()];
                    for (int j = 0; j < parameterTypes.length; ++j) {
                        parameterTypes[j] = TClass.getClass(jsParameterTypes.get(j));
                    }
                    TClass<?> returnType = TClass.getClass(jsMethod.getReturnType());
                    JSObject annotations = jsMethod.getAnnotations();
                    this.declaredMethods[count++] = new TMethod(this, jsMethod.getName(), jsMethod.getModifiers(), jsMethod.getAccessLevel(), returnType, parameterTypes, MethodCaller.forJs(jsMethod.getCallable()), !JSObjects.isUndefined(annotations) ? Platform.annotationsFromJS(annotations) : null);
                }
                this.declaredMethods = Arrays.copyOf(this.declaredMethods, count);
            } else {
                MethodInfoList methodInfoList = this.getDeclaredMethodsImpl();
                if (methodInfoList == null) {
                    this.declaredMethods = new TMethod[0];
                } else {
                    this.declaredMethods = new TMethod[methodInfoList.count()];
                    int count = 0;
                    for (int i = 0; i < methodInfoList.count(); ++i) {
                        MethodInfo methodInfo = methodInfoList.get(i);
                        if (methodInfo.name().equals("<init>") || methodInfo.name().equals("<clinit>")) continue;
                        ClassList paramTypeInfoList = methodInfo.parameterTypes();
                        TClass[] parameterTypes = new TClass[paramTypeInfoList.count()];
                        for (int j = 0; j < parameterTypes.length; ++j) {
                            parameterTypes[j] = (TClass)((Object)paramTypeInfoList.get(j));
                        }
                        Class<?> returnType = methodInfo.returnType();
                        this.declaredMethods[count++] = new TMethod(this, methodInfo.name(), methodInfo.modifiers(), methodInfo.accessLevel(), (TClass)((Object)returnType), parameterTypes, methodInfo.caller(), methodInfo.annotations());
                    }
                    this.declaredMethods = Arrays.copyOf(this.declaredMethods, count);
                }
            }
        }
        return (TMethod[])this.declaredMethods.clone();
    }

    private native MethodInfoList getDeclaredMethodsImpl();

    public TMethod getDeclaredMethod(String name, TClass<?> ... parameterTypes) throws TNoSuchMethodException, TSecurityException {
        TMethod bestFit = null;
        for (TMethod method : this.getDeclaredMethods()) {
            if (!method.getName().equals(name) || !Arrays.equals(method.getParameterTypes(), parameterTypes) || bestFit != null && !bestFit.getReturnType().isAssignableFrom(method.getReturnType())) continue;
            bestFit = method;
        }
        if (bestFit == null) {
            throw new TNoSuchMethodException();
        }
        return bestFit;
    }

    public TMethod[] getMethods() throws TSecurityException {
        HashMap<MethodSignature, TMethod> methods = new HashMap<MethodSignature, TMethod>();
        TClass.findMethods(this, methods);
        return methods.values().toArray(new TMethod[methods.size()]);
    }

    public TMethod getMethod(String name, TClass<?> ... parameterTypes) throws TNoSuchMethodException, TSecurityException {
        TMethod method = TClass.findMethod(this, null, name, parameterTypes);
        if (method == null) {
            throw new TNoSuchMethodException();
        }
        return method;
    }

    private static void findMethods(TClass<?> cls, Map<MethodSignature, TMethod> methods) {
        TClass<?> superclass;
        for (TMethod tMethod : cls.getDeclaredMethods()) {
            MethodSignature signature;
            if (!TModifier.isPublic(tMethod.getModifiers()) || methods.containsKey(signature = new MethodSignature(tMethod.getName(), tMethod.getParameterTypes(), tMethod.getReturnType()))) continue;
            methods.put(signature, tMethod);
        }
        if (!cls.isInterface() && (superclass = cls.getSuperclass()) != null) {
            TClass.findMethods(superclass, methods);
        }
        for (TAnnotatedElement tAnnotatedElement : cls.getInterfaces()) {
            TClass.findMethods(tAnnotatedElement, methods);
        }
    }

    private static TMethod findMethod(TClass<?> cls, TMethod current, String name, TClass<?>[] parameterTypes) {
        TClass<?> superclass;
        for (TMethod tMethod : cls.getDeclaredMethods()) {
            if (!TModifier.isPublic(tMethod.getModifiers()) || !tMethod.getName().equals(name) || !Arrays.equals(tMethod.getParameterTypes(), parameterTypes) || current != null && !current.getReturnType().isAssignableFrom(tMethod.getReturnType())) continue;
            current = tMethod;
        }
        if (!cls.isInterface() && (superclass = cls.getSuperclass()) != null) {
            current = TClass.findMethod(superclass, current, name, parameterTypes);
        }
        for (TAnnotatedElement tAnnotatedElement : cls.getInterfaces()) {
            current = TClass.findMethod(tAnnotatedElement, current, name, parameterTypes);
        }
        return current;
    }

    public int getModifiers() {
        if (PlatformDetector.isJavaScript()) {
            int flags = this.platformClass.getMetadata().getFlags();
            int accessLevel = this.platformClass.getMetadata().getAccessLevel();
            return Flags.getModifiers(flags, accessLevel);
        }
        if (PlatformDetector.isWebAssemblyGC()) {
            return this.getWasmGCFlags() & 0xFFF;
        }
        return 0;
    }

    public boolean desiredAssertionStatus() {
        return true;
    }

    @PluggableDependency(value=ClassGenerator.class)
    public TClass<? super T> getSuperclass() {
        return TClass.getClass(this.platformClass.getMetadata().getSuperclass());
    }

    @PluggableDependency(value=ClassGenerator.class)
    public TClass<? super T>[] getInterfaces() {
        if (PlatformDetector.isWebAssemblyGC()) {
            TClass<T>[] result = this.getInterfacesImpl();
            return result != null ? (TClass[])result.clone() : new TClass[]{};
        }
        PlatformSequence<PlatformClass> supertypes = this.platformClass.getMetadata().getSupertypes();
        TClass[] filteredSupertypes = new TClass[supertypes.getLength()];
        int j = 0;
        for (int i = 0; i < supertypes.getLength(); ++i) {
            if (supertypes.get(i) == this.platformClass.getMetadata().getSuperclass()) continue;
            filteredSupertypes[j++] = TClass.getClass(supertypes.get(i));
        }
        if (filteredSupertypes.length > j) {
            filteredSupertypes = Arrays.copyOf(filteredSupertypes, j);
        }
        return filteredSupertypes;
    }

    private native TClass<? super T>[] getInterfacesImpl();

    public T[] getEnumConstants() {
        if (!this.isEnum()) {
            return null;
        }
        if (PlatformDetector.isWebAssemblyGC()) {
            return ClassSupport.getEnumConstants((Class)((Object)this));
        }
        Platform.initClass(this.platformClass);
        return (Object[])Platform.getEnumConstants(this.platformClass).clone();
    }

    public T cast(TObject obj) {
        if (obj != null && !this.isAssignableFrom((TClass)((Object)obj.getClass()))) {
            throw new TClassCastException(obj.getClass().getName() + " is not subtype of " + this.getName());
        }
        return (T)obj;
    }

    public TClassLoader getClassLoader() {
        return TClassLoader.getSystemClassLoader();
    }

    public static TClass<?> forName(TString name) throws TClassNotFoundException {
        TClass<?> result;
        if (PlatformDetector.isJavaScript()) {
            PlatformClass cls = Platform.lookupClass(name.toString());
            if (cls == null) {
                throw new TClassNotFoundException();
            }
            return TClass.getClass(cls);
        }
        if (nameMap == null) {
            TClass.fillNameMap();
        }
        if ((result = nameMap.get((String)((Object)name))) == null) {
            throw new TClassNotFoundException((String)((Object)name));
        }
        return result;
    }

    private static void fillNameMap() {
        nameMap = new HashMap();
        for (TClass<?> cls = TClass.last(); cls != null; cls = cls.previous()) {
            String name = cls.getNameImpl();
            if (name == null) continue;
            nameMap.put(name, cls);
        }
    }

    @PluggableDependency(value=ClassDependencyListener.class)
    private static native TClass<?> last();

    @PluggableDependency(value=ClassDependencyListener.class)
    private native TClass<?> previous();

    public static TClass<?> forName(TString name, boolean initialize, TClassLoader loader) throws TClassNotFoundException {
        return TClass.forName(name);
    }

    @PluggableDependency(value=ClassDependencyListener.class)
    void initialize() {
        if (PlatformDetector.isJavaScript()) {
            Platform.initClass(this.platformClass);
        } else {
            this.initializeImpl();
        }
    }

    private native void initializeImpl();

    public T newInstance() throws TInstantiationException, TIllegalAccessException {
        Object instance;
        if (PlatformDetector.isJavaScript()) {
            instance = Platform.newInstance(this.platformClass);
        } else {
            TClass.initReflection();
            instance = this.newInstanceImpl();
        }
        if (instance == null) {
            throw new TInstantiationException();
        }
        return instance;
    }

    private native Object newInstanceImpl();

    public TClass<?> getDeclaringClass() {
        PlatformClass result = Platform.getDeclaringClass(this.getPlatformClass());
        return result != null ? TClass.getClass(result) : null;
    }

    public TClass<?> getEnclosingClass() {
        PlatformClass result = Platform.getEnclosingClass(this.getPlatformClass());
        return result != null ? TClass.getClass(result) : null;
    }

    public <U> TClass<? extends U> asSubclass(TClass<U> clazz) {
        if (!clazz.isAssignableFrom(this)) {
            throw new TClassCastException();
        }
        return this;
    }

    @Override
    public boolean isAnnotationPresent(TClass<? extends TAnnotation> annotationClass) {
        this.ensureAnnotationsByType();
        return this.annotationsByType.containsKey(annotationClass);
    }

    public <S extends TAnnotation> S getAnnotation(TClass<S> annotationClass) {
        this.ensureAnnotationsByType();
        return (S)this.annotationsByType.get(annotationClass);
    }

    @Override
    public TAnnotation[] getAnnotations() {
        if (this.annotationsCache == null) {
            boolean initial = true;
            LinkedHashMap<Class<? extends Annotation>, TAnnotation> map = new LinkedHashMap<Class<? extends Annotation>, TAnnotation>();
            for (TClass<T> cls = this; cls != null; cls = cls.getSuperclass()) {
                for (TAnnotation annot : cls.getDeclaredAnnotations()) {
                    if (!initial && !TClass.isInherited(annot)) continue;
                    map.putIfAbsent(annot.annotationType(), annot);
                }
                initial = false;
            }
            this.annotationsCache = map.values().toArray(new TAnnotation[0]);
        }
        return (TAnnotation[])this.annotationsCache.clone();
    }

    private static boolean isInherited(TAnnotation annot) {
        if (PlatformDetector.isWebAssemblyGC()) {
            int flags = ((TClass)((Object)annot.annotationType())).getWasmGCFlags();
            return (flags & 0x100000) != 0;
        }
        PlatformClass platformClass = ((TClass)((Object)annot.annotationType())).platformClass;
        return (platformClass.getMetadata().getFlags() & 0x8000) != 0;
    }

    @Override
    public TAnnotation[] getDeclaredAnnotations() {
        if (this.declaredAnnotationsCache == null) {
            this.declaredAnnotationsCache = PlatformDetector.isWebAssemblyGC() ? this.getDeclaredAnnotationsImpl() : (TAnnotation[])Platform.getAnnotations(this.getPlatformClass());
            if (this.declaredAnnotationsCache == null) {
                this.declaredAnnotationsCache = new TAnnotation[0];
            }
        }
        return (TAnnotation[])this.declaredAnnotationsCache.clone();
    }

    private native TAnnotation[] getDeclaredAnnotationsImpl();

    private void ensureAnnotationsByType() {
        if (this.annotationsByType != null) {
            return;
        }
        this.annotationsByType = new HashMap();
        for (TAnnotation annot : this.getAnnotations()) {
            this.annotationsByType.put((TClass)((Object)annot.annotationType()), annot);
        }
    }

    public InputStream getResourceAsStream(String name) {
        if (((String)name).startsWith("/")) {
            return this.getClassLoader().getResourceAsStream(((String)name).substring(1));
        }
        TClass<?> cls = this;
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        String prefix = cls.getName().toString();
        int index = prefix.lastIndexOf(46);
        if (index >= 0) {
            name = prefix.substring(0, index + 1).replace('.', '/') + (String)name;
        }
        return this.getClassLoader().getResourceAsStream((String)name);
    }

    public TPackage getPackage() {
        String name = this.getName();
        name = name.substring(0, name.lastIndexOf(46) + 1);
        return TPackage.getPackage(name);
    }

    private static final class MethodSignature {
        private final String name;
        private final TClass<?>[] parameterTypes;
        private final TClass<?> returnType;

        MethodSignature(String name, TClass<?>[] parameterTypes, TClass<?> returnType) {
            this.name = name;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodSignature)) {
                return false;
            }
            MethodSignature that = (MethodSignature)o;
            return Objects.equals(this.name, that.name) && Arrays.equals(this.parameterTypes, that.parameterTypes) && Objects.equals(this.returnType, that.returnType);
        }

        public int hashCode() {
            return Objects.hash(this.name, Arrays.hashCode(this.parameterTypes), this.returnType);
        }
    }
}

