/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.lang.annotation.Retention;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.Precedence;
import org.teavm.backend.javascript.rendering.RenderingUtil;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.javascript.spi.InjectorContext;
import org.teavm.classlib.impl.ReflectionDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MemberReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ClassGenerator
implements Generator,
Injector,
DependencyPlugin {
    private static final FieldReference platformClassField = new FieldReference(Class.class.getName(), "platformClass");
    private static final MethodDescriptor CLINIT = new MethodDescriptor("<clinit>", Void.TYPE);

    @Override
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) {
        switch (methodRef.getName()) {
            case "createMetadata": {
                this.generateCreateMetadata(context, writer);
            }
        }
    }

    @Override
    public void generate(InjectorContext context, MethodReference methodRef) {
        switch (methodRef.getName()) {
            case "newEmptyInstance": {
                context.getWriter().append("new").ws().append("(");
                context.writeExpr(context.getArgument(0), Precedence.MEMBER_ACCESS);
                context.getWriter().append('.').appendField(platformClassField);
                context.getWriter().append(")");
            }
        }
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        switch (method.getReference().getName()) {
            case "newEmptyInstance": {
                method.getVariable(0).getClassValueNode().addConsumer(type -> {
                    if (!(type.getValueType() instanceof ValueType.Object)) {
                        return;
                    }
                    String className = ((ValueType.Object)type.getValueType()).getClassName();
                    ClassReader cls = agent.getClassSource().get(className);
                    if (cls != null && !cls.hasModifier(ElementModifier.ABSTRACT) && !cls.hasModifier(ElementModifier.INTERFACE)) {
                        method.getResult().propagate(type);
                    }
                });
                break;
            }
            case "getSuperclass": {
                this.reachGetSuperclass(agent, method);
                break;
            }
            case "getInterfaces": {
                this.reachGetInterfaces(agent, method);
                break;
            }
            case "getComponentType": {
                this.reachGetComponentType(agent, method);
            }
        }
    }

    private void reachGetSuperclass(DependencyAgent agent, MethodDependency method) {
        method.getVariable(0).getClassValueNode().addConsumer(type -> {
            if (!(type.getValueType() instanceof ValueType.Object)) {
                return;
            }
            String className = ((ValueType.Object)type.getValueType()).getClassName();
            ClassReader cls = agent.getClassSource().get(className);
            if (cls != null && cls.getParent() != null) {
                method.getResult().getClassValueNode().propagate(agent.getType(ValueType.object(cls.getParent())));
            }
        });
    }

    private void reachGetInterfaces(DependencyAgent agent, MethodDependency method) {
        method.getVariable(0).getClassValueNode().addConsumer(type -> {
            if (!(type.getValueType() instanceof ValueType.Object)) {
                return;
            }
            String className = ((ValueType.Object)type.getValueType()).getClassName();
            ClassReader cls = agent.getClassSource().get(className);
            method.getResult().propagate(agent.getType(ValueType.arrayOf(ValueType.object("java.lang.Class"))));
            method.getResult().getArrayItem().propagate(agent.getType(ValueType.object("java.lang.Class")));
            if (cls != null) {
                for (String iface : cls.getInterfaces()) {
                    method.getResult().getArrayItem().getClassValueNode().propagate(agent.getType(ValueType.object(iface)));
                }
            }
        });
    }

    private void reachGetComponentType(DependencyAgent agent, MethodDependency method) {
        method.getVariable(0).getClassValueNode().addConsumer(t -> {
            if (!(t.getValueType() instanceof ValueType.Array)) {
                return;
            }
            ValueType itemType = ((ValueType.Array)t.getValueType()).getItemType();
            method.getResult().getClassValueNode().propagate(agent.getType(itemType));
        });
    }

    private void generateCreateMetadata(GeneratorContext context, SourceWriter writer) {
        ReflectionDependencyListener reflection = context.getService(ReflectionDependencyListener.class);
        for (String className : reflection.getClassesWithReflectableFields()) {
            this.generateCreateFieldsForClass(context, writer, className);
        }
        for (String className : reflection.getClassesWithReflectableMethods()) {
            this.generateCreateMethodsForClass(context, writer, className);
        }
    }

    private void generateCreateFieldsForClass(GeneratorContext context, SourceWriter writer, String className) {
        ReflectionDependencyListener reflection = context.getService(ReflectionDependencyListener.class);
        Set<String> accessibleFields = reflection.getAccessibleFields(className);
        ClassReader cls = context.getClassSource().get(className);
        if (cls == null) {
            return;
        }
        writer.appendClass(className).append(".$meta.fields").ws().append('=').ws().append('[').indent();
        Collection fieldsToExpose = accessibleFields == null ? cls.getFields() : (Collection)cls.getFields().stream().filter(f -> accessibleFields.contains(f.getName())).collect(Collectors.toSet());
        boolean skipPrivates = ReflectionDependencyListener.shouldSkipPrivates(cls);
        this.generateCreateMembers(context, writer, skipPrivates, fieldsToExpose, field -> {
            this.appendProperty(writer, "type", false, () -> context.typeToClassString(writer, field.getType()));
            this.appendProperty(writer, "getter", false, () -> {
                if (accessibleFields != null && accessibleFields.contains(field.getName()) && reflection.isRead(field.getReference())) {
                    this.renderGetter(context, writer, (FieldReader)field);
                } else {
                    writer.append("null");
                }
            });
            this.appendProperty(writer, "setter", false, () -> {
                if (accessibleFields != null && accessibleFields.contains(field.getName()) && reflection.isWritten(field.getReference())) {
                    this.renderSetter(context, writer, (FieldReader)field);
                } else {
                    writer.append("null");
                }
            });
        });
        writer.outdent().append("];").softNewLine();
    }

    private void generateCreateMethodsForClass(GeneratorContext context, SourceWriter writer, String className) {
        ReflectionDependencyListener reflection = context.getService(ReflectionDependencyListener.class);
        Set<MethodDescriptor> accessibleMethods = reflection.getAccessibleMethods(className);
        ClassReader cls = context.getInitialClassSource().get(className);
        if (cls == null) {
            return;
        }
        writer.appendClass(className).append(".$meta.methods").ws().append('=').ws().append('[').indent();
        boolean skipPrivates = ReflectionDependencyListener.shouldSkipPrivates(cls);
        Collection methodsToExpose = accessibleMethods == null ? cls.getMethods() : (Collection)cls.getMethods().stream().filter(m -> accessibleMethods.contains(m.getDescriptor())).collect(Collectors.toList());
        this.generateCreateMembers(context, writer, skipPrivates, methodsToExpose, method -> {
            this.appendProperty(writer, "parameterTypes", false, () -> {
                writer.append('[');
                for (int i = 0; i < method.parameterCount(); ++i) {
                    if (i > 0) {
                        writer.append(',').ws();
                    }
                    context.typeToClassString(writer, method.parameterType(i));
                }
                writer.append(']');
            });
            this.appendProperty(writer, "returnType", false, () -> context.typeToClassString(writer, method.getResultType()));
            this.appendProperty(writer, "callable", false, () -> {
                if (accessibleMethods != null && accessibleMethods.contains(method.getDescriptor()) && reflection.isCalled(method.getReference())) {
                    this.renderCallable(context, writer, (MethodReader)method);
                } else {
                    writer.append("null");
                }
            });
        });
        writer.outdent().append("];").softNewLine();
    }

    private <T extends MemberReader> void generateCreateMembers(GeneratorContext context, SourceWriter writer, boolean skipPrivates, Iterable<T> members, MemberRenderer<T> renderer) {
        boolean first = true;
        for (MemberReader member : members) {
            if (skipPrivates && (member.getLevel() == AccessLevel.PRIVATE || member.getLevel() == AccessLevel.PACKAGE_PRIVATE)) continue;
            if (!first) {
                writer.append(",").ws();
            } else {
                writer.softNewLine();
            }
            first = false;
            writer.append("{").indent().softNewLine();
            this.appendProperty(writer, "name", true, () -> writer.append('\"').append(RenderingUtil.escapeString(member.getName())).append('\"'));
            this.appendProperty(writer, "modifiers", false, () -> writer.append(ElementModifier.pack(member.readModifiers())));
            this.appendProperty(writer, "accessLevel", false, () -> writer.append(member.getLevel().ordinal()));
            this.generateAnnotations(context, writer, member.getAnnotations().all());
            renderer.render(member);
            writer.outdent().softNewLine().append("}");
        }
    }

    private void generateAnnotations(GeneratorContext context, SourceWriter writer, Iterable<? extends AnnotationReader> annotations) {
        ArrayList<AnnotationReader> annotationsToExpose = new ArrayList<AnnotationReader>();
        for (AnnotationReader annotationReader : annotations) {
            AnnotationReader retention;
            ClassReader annotationCls = context.getClassSource().get(annotationReader.getType());
            if (annotationCls == null || (retention = annotationCls.getAnnotations().get(Retention.class.getName())) == null || !Objects.equals(retention.getValue("value").getEnumValue().getFieldName(), "RUNTIME")) continue;
            annotationsToExpose.add(annotationReader);
        }
        if (annotationsToExpose.isEmpty()) {
            return;
        }
        writer.append(",").softNewLine();
        writer.append("annotations").append(':').ws();
        writer.appendFunction("$rt_wrapArray").append("(").appendClass("java.lang.annotation.Annotation").append(",").ws().append("[");
        if (!annotationsToExpose.isEmpty()) {
            this.generateAnnotation(context, writer, (AnnotationReader)annotationsToExpose.get(0));
            for (int i = 1; i < annotationsToExpose.size(); ++i) {
                writer.append(",").ws();
                this.generateAnnotation(context, writer, (AnnotationReader)annotationsToExpose.get(i));
            }
        }
        writer.append("])");
    }

    /*
     * WARNING - void declaration
     */
    private void generateAnnotation(GeneratorContext context, SourceWriter writer, AnnotationReader annotation) {
        ClassReader annotCls = context.getClassSource().get(annotation.getType());
        ClassReader annotImpl = context.getClassSource().get(annotation.getType() + "$$_impl");
        ArrayList<Fragment> arguments = new ArrayList<Fragment>();
        ArrayList<ValueType> signature = new ArrayList<ValueType>();
        for (MethodReader methodReader : annotCls.getMethods()) {
            if (methodReader.hasModifier(ElementModifier.STATIC)) continue;
            signature.add(methodReader.getResultType());
            AnnotationValue ownValue = annotation.getValue(methodReader.getName());
            AnnotationValue value = ownValue != null ? ownValue : methodReader.getAnnotationDefault();
            arguments.add(() -> this.generateAnnotationValue(context, writer, value, methodDecl.getResultType()));
        }
        signature.add(ValueType.VOID);
        MethodReference ctor = new MethodReference(annotImpl.getName(), "<init>", signature.toArray(new ValueType[0]));
        writer.appendInit(ctor).append("(");
        if (!arguments.isEmpty()) {
            void var9_11;
            ((Fragment)arguments.get(0)).render();
            boolean bl = true;
            while (var9_11 < arguments.size()) {
                writer.append(",").ws();
                ((Fragment)arguments.get((int)var9_11)).render();
                ++var9_11;
            }
        }
        writer.append(")");
    }

    private void generateAnnotationValue(GeneratorContext context, SourceWriter writer, AnnotationValue value, ValueType type) {
        switch (value.getType()) {
            case 0: {
                writer.append(value.getBoolean() ? "1" : "0");
                break;
            }
            case 12: {
                writer.append((int)value.getChar());
                break;
            }
            case 1: {
                writer.append(value.getByte());
                break;
            }
            case 2: {
                writer.append(value.getShort());
                break;
            }
            case 3: {
                writer.append(value.getInt());
                break;
            }
            case 4: {
                writer.append(String.valueOf(value.getLong()));
                break;
            }
            case 5: {
                writer.append(String.valueOf(value.getFloat()));
                break;
            }
            case 6: {
                writer.append(String.valueOf(value.getDouble()));
                break;
            }
            case 7: {
                writer.appendFunction("$rt_str").append("(\"").append(RenderingUtil.escapeString(value.getString())).append("\")");
                break;
            }
            case 9: {
                ValueType itemType = ((ValueType.Array)type).getItemType();
                this.appendArrayConstructor(context, writer, itemType);
                List<AnnotationValue> list = value.getList();
                writer.append("[");
                if (!list.isEmpty()) {
                    this.generateAnnotationValue(context, writer, list.get(0), itemType);
                    for (int i = 1; i < list.size(); ++i) {
                        writer.append(",").ws();
                        this.generateAnnotationValue(context, writer, list.get(i), itemType);
                    }
                }
                writer.append("])");
                break;
            }
            case 11: {
                this.generateAnnotation(context, writer, value.getAnnotation());
                return;
            }
            case 10: {
                if (context.isDynamicInitializer(value.getEnumValue().getClassName())) {
                    writer.append("(").appendClassInit(value.getEnumValue().getClassName()).append("(),").ws().appendStaticField(value.getEnumValue()).append(")");
                    break;
                }
                writer.appendStaticField(value.getEnumValue());
                break;
            }
            case 8: {
                context.typeToClassString(writer, type);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void appendArrayConstructor(GeneratorContext context, SourceWriter writer, ValueType itemType) {
        if (itemType instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)itemType).getKind()) {
                case BOOLEAN: {
                    writer.appendFunction("$rt_createBooleanArrayFromData").append("(");
                    return;
                }
                case BYTE: {
                    writer.appendFunction("$rt_createByteArrayFromData").append("(");
                    return;
                }
                case SHORT: {
                    writer.appendFunction("$rt_createShortArrayFromData").append("(");
                    return;
                }
                case CHARACTER: {
                    writer.appendFunction("$rt_createCharArrayFromData").append("(");
                    return;
                }
                case INTEGER: {
                    writer.appendFunction("$rt_createIntArrayFromData").append("(");
                    return;
                }
                case LONG: {
                    writer.appendFunction("$rt_createLongArrayFromData").append("(");
                    return;
                }
                case FLOAT: {
                    writer.appendFunction("$rt_createFloatArrayFromData").append("(");
                    return;
                }
                case DOUBLE: {
                    writer.appendFunction("$rt_createDoubleArrayFromData").append("(");
                    return;
                }
            }
        }
        writer.appendFunction("$rt_wrapArray").append("(");
        context.typeToClassString(writer, itemType);
        writer.append(",").ws();
    }

    private void appendProperty(SourceWriter writer, String name, boolean first, Fragment value) {
        if (!first) {
            writer.append(",").softNewLine();
        }
        writer.append(name).append(':').ws();
        value.render();
    }

    private void renderGetter(GeneratorContext context, SourceWriter writer, FieldReader field) {
        writer.append("function(obj)").ws().append("{").indent().softNewLine();
        this.initClass(context, writer, field);
        writer.append("return ");
        this.boxIfNecessary(writer, field.getType(), () -> this.fieldAccess(writer, field));
        writer.append(";").softNewLine();
        writer.outdent().append("}");
    }

    private void renderSetter(GeneratorContext context, SourceWriter writer, FieldReader field) {
        writer.append("function(obj,").ws().append("val)").ws().append("{").indent().softNewLine();
        this.initClass(context, writer, field);
        this.fieldAccess(writer, field);
        writer.ws().append('=').ws();
        this.unboxIfNecessary(writer, field.getType(), () -> writer.append("val"));
        writer.append(";").softNewLine();
        writer.outdent().append("}");
    }

    private void renderCallable(GeneratorContext context, SourceWriter writer, MethodReader method) {
        writer.append("function(obj,").ws().append("args)").ws().append("{").indent().softNewLine();
        this.initClass(context, writer, method);
        if (method.getResultType() != ValueType.VOID) {
            writer.append("return ");
        }
        boolean receiverWritten = false;
        if (!(method.hasModifier(ElementModifier.STATIC) || method.hasModifier(ElementModifier.FINAL) || method.getLevel() == AccessLevel.PRIVATE || method.getName().equals("<init>"))) {
            writer.append("obj.").appendVirtualMethod(method.getDescriptor());
            receiverWritten = true;
        } else {
            writer.appendMethod(method.getReference());
        }
        writer.append('(');
        boolean first = true;
        if (!receiverWritten && !method.hasModifier(ElementModifier.STATIC)) {
            writer.append("obj").ws();
            first = false;
        }
        for (int i = 0; i < method.parameterCount(); ++i) {
            if (!first) {
                writer.append(',').ws();
            }
            first = false;
            int index = i;
            this.unboxIfNecessary(writer, method.parameterType(i), () -> writer.append("args[" + index + "]"));
        }
        writer.append(");").softNewLine();
        if (method.getResultType() == ValueType.VOID) {
            writer.append("return null;").softNewLine();
        }
        writer.outdent().append("}");
    }

    private void initClass(GeneratorContext context, SourceWriter writer, MemberReader member) {
        ClassReader cls = context.getClassSource().get(member.getOwnerName());
        if (member.hasModifier(ElementModifier.STATIC) && context.isDynamicInitializer(member.getOwnerName()) && cls.getMethod(CLINIT) != null) {
            writer.appendClassInit(member.getOwnerName()).append("();").softNewLine();
        }
    }

    private void fieldAccess(SourceWriter writer, FieldReader field) {
        if (field.hasModifier(ElementModifier.STATIC)) {
            writer.appendStaticField(field.getReference());
        } else {
            writer.append("obj.").appendField(field.getReference());
        }
    }

    private void boxIfNecessary(SourceWriter writer, ValueType type, Fragment fragment) {
        boolean boxed = false;
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    writer.appendMethod(new MethodReference(Boolean.class, "valueOf", Boolean.TYPE, Boolean.class));
                    break;
                }
                case BYTE: {
                    writer.appendMethod(new MethodReference(Byte.class, "valueOf", Byte.TYPE, Byte.class));
                    break;
                }
                case SHORT: {
                    writer.appendMethod(new MethodReference(Short.class, "valueOf", Short.TYPE, Short.class));
                    break;
                }
                case CHARACTER: {
                    writer.appendMethod(new MethodReference(Character.class, "valueOf", Character.TYPE, Character.class));
                    break;
                }
                case INTEGER: {
                    writer.appendMethod(new MethodReference(Integer.class, "valueOf", Integer.TYPE, Integer.class));
                    break;
                }
                case LONG: {
                    writer.appendMethod(new MethodReference(Long.class, "valueOf", Long.TYPE, Long.class));
                    break;
                }
                case FLOAT: {
                    writer.appendMethod(new MethodReference(Float.class, "valueOf", Float.TYPE, Float.class));
                    break;
                }
                case DOUBLE: {
                    writer.appendMethod(new MethodReference(Double.class, "valueOf", Double.TYPE, Double.class));
                }
            }
            writer.append('(');
            boxed = true;
        }
        fragment.render();
        if (boxed) {
            writer.append(')');
        }
    }

    private void unboxIfNecessary(SourceWriter writer, ValueType type, Fragment fragment) {
        boolean boxed = false;
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    writer.appendMethod(new MethodReference(Boolean.class, "booleanValue", Boolean.TYPE));
                    break;
                }
                case BYTE: {
                    writer.appendMethod(new MethodReference(Byte.class, "byteValue", Byte.TYPE));
                    break;
                }
                case SHORT: {
                    writer.appendMethod(new MethodReference(Short.class, "shortValue", Short.TYPE));
                    break;
                }
                case CHARACTER: {
                    writer.appendMethod(new MethodReference(Character.class, "charValue", Character.TYPE));
                    break;
                }
                case INTEGER: {
                    writer.appendMethod(new MethodReference(Integer.class, "intValue", Integer.TYPE));
                    break;
                }
                case LONG: {
                    writer.appendMethod(new MethodReference(Long.class, "longValue", Long.TYPE));
                    break;
                }
                case FLOAT: {
                    writer.appendMethod(new MethodReference(Float.class, "floatValue", Float.TYPE));
                    break;
                }
                case DOUBLE: {
                    writer.appendMethod(new MethodReference(Double.class, "doubleValue", Double.TYPE));
                }
            }
            writer.append('(');
            boxed = true;
        }
        fragment.render();
        if (boxed) {
            writer.append(')');
        }
    }

    private static interface MemberRenderer<T extends MemberReader> {
        public void render(T var1);
    }

    private static interface Fragment {
        public void render();
    }
}

