/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import org.teavm.classlib.java.io.TReader;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.classlib.java.util.TArrays;
import org.teavm.classlib.java.util.stream.TStream;
import org.teavm.classlib.java.util.stream.impl.TBufferedReaderLinesStream;

public class TBufferedReader
extends TReader {
    private TReader innerReader;
    private char[] buffer;
    private int index;
    private int count;
    private boolean eof;
    private int mark = -1;

    public TBufferedReader(TReader innerReader, int size) {
        if (size < 0) {
            throw new TIllegalArgumentException();
        }
        this.innerReader = innerReader;
        this.buffer = new char[TMath.max(64, size)];
    }

    public TBufferedReader(TReader innerReader) {
        this(innerReader, 1024);
    }

    @Override
    public int read() throws IOException {
        this.requireOpened();
        if (this.index >= this.count && !this.fillBuffer(0, 1)) {
            return -1;
        }
        return this.buffer[this.index++];
    }

    @Override
    public void close() throws IOException {
        this.requireOpened();
        this.innerReader.close();
        this.innerReader = null;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n;
        this.requireOpened();
        if (this.index == this.count && this.eof) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        int charsRead = 0;
        do {
            n = TMath.min(this.count - this.index, len - charsRead);
            System.arraycopy(this.buffer, this.index, cbuf, off, n);
            off += n;
            this.index += n;
        } while ((charsRead += n) != len && (charsRead <= 0 || this.innerReader.ready()) && this.fillBuffer(0, len - charsRead));
        return charsRead;
    }

    public String readLine() throws IOException {
        this.requireOpened();
        if (this.eof && this.index >= this.count) {
            return null;
        }
        TStringBuilder line = new TStringBuilder();
        while (true) {
            char ch;
            if (this.index >= this.count && !this.fillBuffer(0, this.count - this.index)) {
                if (!line.isEmpty()) break;
                return null;
            }
            if ((ch = this.buffer[this.index++]) == '\n') break;
            if (ch == '\r') {
                if (this.index >= this.count && !this.fillBuffer(0, this.count - this.index) || this.buffer[this.index] != '\n') break;
                ++this.index;
                break;
            }
            line.append(ch);
        }
        return line.toString();
    }

    public TStream<String> lines() {
        return new TBufferedReaderLinesStream(this);
    }

    @Override
    public long skip(long n) throws IOException {
        this.requireOpened();
        if (n < (long)(this.count - this.index)) {
            this.index = (int)((long)this.index + n);
            return n;
        }
        long skipped = this.innerReader.skip(n -= (long)(this.count - this.index));
        if (skipped == n) {
            this.fillBuffer(0, (int)n);
        } else {
            this.eof = true;
        }
        return skipped;
    }

    @Override
    public boolean ready() {
        return this.index < this.count;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit > this.buffer.length) {
            this.buffer = TArrays.copyOf(this.buffer, readAheadLimit);
        }
        if (this.count - this.index < readAheadLimit) {
            for (int i = this.index; i < this.count; ++i) {
                this.buffer[i - this.index] = this.buffer[i];
            }
            this.fillBuffer(this.count - this.index, this.count - this.index);
        }
        this.mark = this.index;
    }

    @Override
    public void reset() throws IOException {
        if (this.mark == -1) {
            throw new IOException();
        }
        this.index = this.mark;
    }

    private boolean fillBuffer(int offset, int readLimit) throws IOException {
        int charsRead;
        if (this.eof) {
            return false;
        }
        readLimit = Math.min(readLimit, this.buffer.length - this.index);
        int totalRead = 0;
        do {
            if ((charsRead = this.innerReader.read(this.buffer, offset, this.buffer.length - offset)) != -1) continue;
            this.eof = true;
            break;
        } while ((offset += charsRead) < readLimit && this.innerReader.ready() || (totalRead += charsRead) <= 0);
        this.count = offset;
        this.index = 0;
        this.mark = -1;
        return totalRead > 0;
    }

    private void requireOpened() throws IOException {
        if (this.innerReader == null) {
            throw new IOException();
        }
    }
}

