/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.text;

import java.util.Arrays;

public final class FloatAnalyzer {
    public static final int PRECISION = 9;
    public static final int MAX_POS = 100000000;
    static final int MAX_ABS_DEC_EXP = 50;
    private static final int MAX_MANTISSA = Integer.divideUnsigned(-1, 10);
    private static final int[] mantissa10Table = new int[]{-18543760, -873828468, -1558056233, -2105438446, -791721136, -1492370368, -2052889754, -707643228, -1425108042, -1999079893, -621547450, -1356231419, -1943978595, -533385374, -1285701758, -1887554866, -443107408, -1213479385, -1829776968, -350662770, -1139523676, -1770612400, -255999462, -1063793029, -1710027882, -159064234, -986244846, -1647989336, -59802560, -906835507, -1584461865, -2126562952, -825520345, -1519409735, -2074521247, -742253618, -1452796353, -2021230542, -656988489, -1384584251, -1966660860, -569676998, -1314735058, -1910781505, -480270031, -1243209484, -1853561046, -388717296, -1169967296, -1794967296, -294967296, -1094967296, -1734967296, -198967296, -1018167296, -1673527296, -100663296, -939524096, -1610612736, Integer.MIN_VALUE, -858993460, -1546188227, -2095944041, -776530088, -1480217529, -2043167483, -692087595, -1412663535, -1989124287, -605618482, -1343488245, -1933784055, -517074110, -1272652747, -1877115657, -426404674, -1200117198, -1819087218, -333559171, -1125840796, -1759666096, -238485376, -1049781760, -1698818867, -141129810, -971897307, -1636511305, -41437710, -892143627, -1572708361, -2117160148, -810475859, -1507374147, -2064892777, -726848065, -1440471911, -2011370988, -641213203, -1371964022, -1956564688};
    private static final int[] exp10Table = new int[]{-37, -34, -31, -28, -24, -21, -18, -14, -11, -8, -4, -1, 2, 6, 9, 12, 16, 19, 22, 26, 29, 32, 36, 39, 42, 46, 49, 52, 56, 59, 62, 65, 69, 72, 75, 79, 82, 85, 89, 92, 95, 99, 102, 105, 109, 112, 115, 119, 122, 125, 129, 132, 135, 139, 142, 145, 149, 152, 155, 158, 162, 165, 168, 172, 175, 178, 182, 185, 188, 192, 195, 198, 202, 205, 208, 212, 215, 218, 222, 225, 228, 232, 235, 238, 242, 245, 248, 252, 255, 258, 261, 265, 268, 271, 275, 278, 281, 285, 288, 291};

    private FloatAnalyzer() {
    }

    public static void analyze(float d, Result result) {
        int upperPos;
        int binExponentCorrection;
        int mantissaShift;
        int decMantissa;
        int decExponent;
        int bits = Float.floatToIntBits(d);
        result.sign = (bits & Integer.MIN_VALUE) != 0;
        int mantissa = bits & 0x7FFFFF;
        int exponent = bits >> 23 & 0xFF;
        if (mantissa == 0 && exponent == 0) {
            result.mantissa = 0;
            result.exponent = 0;
            return;
        }
        if (exponent == 0) {
            mantissa <<= 1;
            while (((long)mantissa & 0x800000L) == 0L) {
                mantissa <<= 1;
                --exponent;
            }
        } else {
            mantissa |= 0x800000;
        }
        if ((decExponent = Arrays.binarySearch(exp10Table, exponent)) < 0) {
            decExponent = -decExponent;
        }
        if ((decMantissa = FloatAnalyzer.mulAndShiftRight(mantissa, mantissa10Table[decExponent + 1], mantissaShift = 9 + (binExponentCorrection = exponent - exp10Table[decExponent + 1]))) < MAX_MANTISSA) {
            while (Integer.compareUnsigned(decMantissa, MAX_MANTISSA) <= 0) {
                --decExponent;
                decMantissa = decMantissa * 10 + 9;
            }
            binExponentCorrection = exponent - exp10Table[decExponent + 1];
            mantissaShift = 9 + binExponentCorrection;
            decMantissa = FloatAnalyzer.mulAndShiftRight(mantissa, mantissa10Table[decExponent + 1], mantissaShift);
        }
        int decMantissaHi = FloatAnalyzer.mulAndShiftRight((mantissa << 1) + 1, mantissa10Table[decExponent + 1], mantissaShift - 1);
        int decMantissaLow = FloatAnalyzer.mulAndShiftRight((mantissa << 1) - 1, mantissa10Table[decExponent + 1], mantissaShift - 1);
        int lowerPos = FloatAnalyzer.findLowerDistance(decMantissa, decMantissaLow);
        int posCmp = Integer.compareUnsigned(lowerPos, upperPos = FloatAnalyzer.findUpperDistance(decMantissa, decMantissaHi));
        if (Long.compareUnsigned(decMantissa = posCmp > 0 ? Integer.divideUnsigned(decMantissa, lowerPos) * lowerPos : (posCmp < 0 ? Integer.divideUnsigned(decMantissa, upperPos) * upperPos + upperPos : Integer.divideUnsigned(decMantissa + upperPos / 2, upperPos) * upperPos), 1000000000L) >= 0) {
            do {
                ++decExponent;
            } while (Integer.compareUnsigned(decMantissa = Integer.divideUnsigned(decMantissa, 10), 1000000000) >= 0);
        } else if (Integer.compareUnsigned(decMantissa, 100000000) < 0) {
            --decExponent;
            decMantissa *= 10;
        }
        result.mantissa = decMantissa;
        result.exponent = decExponent - 50;
    }

    private static int findLowerDistance(int mantissa, int lower) {
        int pos = 1;
        while (Integer.compareUnsigned(Integer.divideUnsigned(mantissa, pos * 10), Integer.divideUnsigned(lower, pos * 10)) > 0) {
            pos *= 10;
        }
        return pos;
    }

    private static int findUpperDistance(int mantissa, int upper) {
        int pos = 1;
        while (Integer.compareUnsigned(Integer.divideUnsigned(mantissa, pos * 10), Integer.divideUnsigned(upper, pos * 10)) < 0) {
            pos *= 10;
        }
        return pos;
    }

    static int mulAndShiftRight(int a, int b, int shift) {
        long result = ((long)a & 0xFFFFFFFFL) * ((long)b & 0xFFFFFFFFL);
        return (int)(result >>> 32 - shift);
    }

    public static class Result {
        public int mantissa;
        public int exponent;
        public boolean sign;
    }
}

