/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.string;

import java.util.function.Function;
import org.teavm.backend.javascript.ProviderContext;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.javascript.spi.InjectorContext;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;

public class JSStringInjector
implements Injector,
Function<ProviderContext, Injector> {
    static final FieldReference NATIVE_FIELD = new FieldReference("java.lang.String", "nativeString");

    @Override
    public Injector apply(ProviderContext providerContext) {
        switch (providerContext.getMethod().getName()) {
            case "initWithEmptyChars": 
            case "borrowChars": 
            case "initWithCharArray": 
            case "takeCharArray": 
            case "charactersLength": 
            case "charactersGet": 
            case "copyCharsToArray": 
            case "fastCharArray": 
            case "nativeString": 
            case "substringJS": 
            case "toLowerCaseJS": 
            case "toUpperCaseJS": 
            case "intern": 
            case "stripJS": 
            case "stripLeadingJS": 
            case "stripTrailingJS": {
                return this;
            }
        }
        return null;
    }

    @Override
    public void generate(InjectorContext context, MethodReference methodRef) {
        switch (methodRef.getName()) {
            case "initWithEmptyChars": {
                this.initWithEmptyChars(context);
                break;
            }
            case "borrowChars": {
                this.borrowChars(context);
                break;
            }
            case "initWithCharArray": {
                this.initWithCharArray(context);
                break;
            }
            case "takeCharArray": {
                this.takeCharArray(context);
                break;
            }
            case "charactersLength": {
                this.charactersLength(context);
                break;
            }
            case "charactersGet": {
                this.charactersGet(context);
                break;
            }
            case "copyCharsToArray": {
                this.copyCharsToArray(context);
                break;
            }
            case "fastCharArray": {
                this.fastCharArray(context);
                break;
            }
            case "nativeString": {
                this.nativeString(context);
                break;
            }
            case "substringJS": {
                this.substringJS(context);
                break;
            }
            case "toLowerCaseJS": {
                this.toLowerCaseJS(context);
                break;
            }
            case "toUpperCaseJS": {
                this.toUpperCaseJS(context);
                break;
            }
            case "intern": {
                this.intern(context);
                break;
            }
            case "stripJS": {
                this.stripJS(context);
                break;
            }
            case "stripLeadingJS": {
                this.stripLeadingJS(context);
                break;
            }
            case "stripTrailingJS": {
                this.stripTrailingJS(context);
            }
        }
    }

    private void initWithEmptyChars(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        context.writeExpr(context.getArgument(0));
        writer.append(".").appendField(NATIVE_FIELD).ws().append("=").ws().append("\"\"");
    }

    private void borrowChars(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        context.writeExpr(context.getArgument(0));
        writer.append(".").appendField(NATIVE_FIELD).ws().append("=").ws();
        context.writeExpr(context.getArgument(1));
        writer.append(".").appendField(NATIVE_FIELD);
    }

    private void initWithCharArray(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        context.writeExpr(context.getArgument(0));
        writer.append(".").appendField(NATIVE_FIELD).ws().append("=").ws();
        writer.appendFunction("$rt_charArrayToString").append("(");
        context.writeExpr(context.getArgument(1));
        writer.append(".data,").ws();
        context.writeExpr(context.getArgument(2));
        writer.append(",").ws();
        context.writeExpr(context.getArgument(3));
        writer.append(")");
    }

    private void takeCharArray(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        context.writeExpr(context.getArgument(0));
        writer.append(".").appendField(NATIVE_FIELD).ws().append("=").ws();
        writer.appendFunction("$rt_fullArrayToString").append("(");
        context.writeExpr(context.getArgument(1));
        writer.append(".data)");
    }

    private void charactersLength(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        context.writeExpr(context.getArgument(0));
        writer.append(".").appendField(NATIVE_FIELD).append(".length");
    }

    private void charactersGet(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        context.writeExpr(context.getArgument(0));
        writer.append(".").appendField(NATIVE_FIELD).append(".charCodeAt(");
        context.writeExpr(context.getArgument(1));
        writer.append(")");
    }

    private void copyCharsToArray(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        writer.appendFunction("$rt_stringToCharArray").append("(");
        context.writeExpr(context.getArgument(0));
        writer.append(".").appendField(NATIVE_FIELD);
        writer.append(",").ws();
        context.writeExpr(context.getArgument(1));
        writer.append(",").ws();
        context.writeExpr(context.getArgument(2));
        writer.append(".data");
        writer.append(",").ws();
        context.writeExpr(context.getArgument(3));
        writer.append(",").ws();
        context.writeExpr(context.getArgument(4));
        writer.append(")");
    }

    private void substringJS(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        context.writeExpr(context.getArgument(0));
        writer.append(".substring(");
        context.writeExpr(context.getArgument(1));
        writer.append(",").ws();
        context.writeExpr(context.getArgument(2));
        writer.append(")");
    }

    private void fastCharArray(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        writer.appendFunction("$rt_fastStringToCharArray").append("(");
        context.writeExpr(context.getArgument(0));
        writer.append(".").appendField(NATIVE_FIELD);
        writer.append(")");
    }

    private void nativeString(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        context.writeExpr(context.getArgument(0));
        writer.append(".").appendField(NATIVE_FIELD);
    }

    private void toLowerCaseJS(InjectorContext context) {
        if (context.argumentCount() == 1) {
            SourceWriter writer = context.getWriter();
            context.writeExpr(context.getArgument(0));
            writer.append(".toLowerCase()");
            return;
        }
        if (context.argumentCount() == 2) {
            SourceWriter writer = context.getWriter();
            context.writeExpr(context.getArgument(0));
            writer.append(".toLocaleLowerCase(");
            context.writeExpr(context.getArgument(1));
            writer.append(")");
            return;
        }
        throw new IllegalArgumentException();
    }

    private void toUpperCaseJS(InjectorContext context) {
        if (context.argumentCount() == 1) {
            SourceWriter writer = context.getWriter();
            context.writeExpr(context.getArgument(0));
            writer.append(".toUpperCase()");
            return;
        }
        if (context.argumentCount() == 2) {
            SourceWriter writer = context.getWriter();
            context.writeExpr(context.getArgument(0));
            writer.append(".toLocaleUpperCase(");
            context.writeExpr(context.getArgument(1));
            writer.append(")");
            return;
        }
        throw new IllegalArgumentException();
    }

    private void intern(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        writer.appendFunction("$rt_intern").append("(");
        context.writeExpr(context.getArgument(0));
        writer.append(")");
    }

    private void stripJS(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        context.writeExpr(context.getArgument(0));
        writer.append(".trim()");
    }

    private void stripLeadingJS(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        context.writeExpr(context.getArgument(0));
        writer.append(".trimStart()");
    }

    private void stripTrailingJS(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        context.writeExpr(context.getArgument(0));
        writer.append(".trimEnd()");
    }
}

