/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.reflection;

import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCCustomTypeMapper;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.model.ValueType;

public class WasmGCReflectionTypeMapper
implements WasmGCCustomTypeMapper {
    private WasmGCClassInfoProvider classInfoProvider;
    private WasmFunctionTypes functionTypes;

    public WasmGCReflectionTypeMapper(WasmGCClassInfoProvider classInfoProvider, WasmFunctionTypes functionTypes) {
        this.classInfoProvider = classInfoProvider;
        this.functionTypes = functionTypes;
    }

    @Override
    public WasmType map(String className) {
        switch (className) {
            case "org.teavm.classlib.impl.reflection.FieldInfo": {
                return this.classInfoProvider.reflection().getReflectionFieldType().getReference();
            }
            case "org.teavm.classlib.impl.reflection.FieldInfoList": {
                return this.classInfoProvider.reflection().getReflectionFieldArrayType().getReference();
            }
            case "org.teavm.classlib.impl.reflection.MethodInfo": {
                return this.classInfoProvider.reflection().getReflectionMethodType().getReference();
            }
            case "org.teavm.classlib.impl.reflection.MethodInfoList": {
                return this.classInfoProvider.reflection().getReflectionMethodArrayType().getReference();
            }
            case "org.teavm.classlib.impl.reflection.ClassList": {
                return this.classInfoProvider.reflection().getClassArrayType().getReference();
            }
            case "org.teavm.classlib.impl.reflection.FieldReader": {
                WasmType.CompositeReference objType = this.classInfoProvider.getClassInfo("java.lang.Object").getType();
                return this.functionTypes.of(objType, objType).getReference();
            }
            case "org.teavm.classlib.impl.reflection.FieldWriter": {
                WasmType.CompositeReference objType = this.classInfoProvider.getClassInfo("java.lang.Object").getType();
                return this.functionTypes.of(null, objType, objType).getReference();
            }
            case "org.teavm.classlib.impl.reflection.MethodCaller": {
                WasmType.CompositeReference objType = this.classInfoProvider.getClassInfo("java.lang.Object").getType();
                WasmType.CompositeReference objArrayType = this.classInfoProvider.getClassInfo(ValueType.arrayOf(ValueType.object("java.lang.Object"))).getType();
                return this.functionTypes.of(objType, objType, objArrayType).getReference();
            }
        }
        return null;
    }
}

