/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.reflection;

import java.util.ArrayList;
import java.util.Set;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.gc.annotations.WasmGCAnnotationsHelper;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCReflectionProvider;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCVirtualCallGenerator;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringConstant;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullCondition;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmSignedType;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.transformation.gc.CoroutineTransformation;
import org.teavm.classlib.impl.ReflectionDependencyListener;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.dependency.ValueDependencyInfo;
import org.teavm.interop.Address;
import org.teavm.model.AccessLevel;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.runtime.Fiber;

public class WasmGCReflectionIntrinsics
implements WasmGCIntrinsic {
    private ReflectionDependencyListener reflection;
    private final Set<ValueType> typesToSkip = Set.of(ValueType.parse(Address.class), ValueType.parse(Fiber.PlatformObject.class), ValueType.parse(Fiber.PlatformFunction.class));
    private WasmFunction initReflectionFunction;
    private WasmFunction wrapAnnotationsFunction;

    public WasmGCReflectionIntrinsics(ReflectionDependencyListener reflection) {
        this.reflection = reflection;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getClassName()) {
            case "org.teavm.classlib.impl.reflection.FieldInfo": {
                switch (invocation.getMethod().getName()) {
                    case "name": {
                        return this.fieldInfoCall(invocation, context, 0);
                    }
                    case "modifiers": {
                        return this.fieldInfoCall(invocation, context, 1);
                    }
                    case "accessLevel": {
                        return this.fieldInfoCall(invocation, context, 2);
                    }
                    case "annotations": {
                        return this.wrapAnnotations(this.fieldInfoCall(invocation, context, 3), context);
                    }
                    case "type": {
                        return this.fieldInfoCall(invocation, context, 4);
                    }
                    case "reader": {
                        return this.fieldInfoCall(invocation, context, 5);
                    }
                    case "writer": {
                        return this.fieldInfoCall(invocation, context, 6);
                    }
                }
                break;
            }
            case "org.teavm.classlib.impl.reflection.FieldInfoList": {
                switch (invocation.getMethod().getName()) {
                    case "count": {
                        return new WasmArrayLength(context.generate(invocation.getArguments().get(0)));
                    }
                    case "get": {
                        WasmExpression arg = context.generate(invocation.getArguments().get(0));
                        WasmExpression index = context.generate(invocation.getArguments().get(1));
                        WasmArray arrayType = context.classInfoProvider().reflection().getReflectionFieldArrayType();
                        return new WasmArrayGet(arrayType, arg, index);
                    }
                }
                break;
            }
            case "org.teavm.classlib.impl.reflection.MethodInfo": {
                switch (invocation.getMethod().getName()) {
                    case "name": {
                        return this.methodInfoCall(invocation, context, 0);
                    }
                    case "modifiers": {
                        return this.methodInfoCall(invocation, context, 1);
                    }
                    case "accessLevel": {
                        return this.methodInfoCall(invocation, context, 2);
                    }
                    case "annotations": {
                        return this.wrapAnnotations(this.methodInfoCall(invocation, context, 3), context);
                    }
                    case "returnType": {
                        return this.methodInfoCall(invocation, context, 4);
                    }
                    case "parameterTypes": {
                        return this.methodInfoCall(invocation, context, 5);
                    }
                    case "caller": {
                        return this.methodInfoCall(invocation, context, 6);
                    }
                }
                break;
            }
            case "org.teavm.classlib.impl.reflection.MethodInfoList": {
                switch (invocation.getMethod().getName()) {
                    case "count": {
                        return new WasmArrayLength(context.generate(invocation.getArguments().get(0)));
                    }
                    case "get": {
                        WasmExpression arg = context.generate(invocation.getArguments().get(0));
                        WasmExpression index = context.generate(invocation.getArguments().get(1));
                        WasmArray arrayType = context.classInfoProvider().reflection().getReflectionMethodArrayType();
                        return new WasmArrayGet(arrayType, arg, index);
                    }
                }
                break;
            }
            case "org.teavm.classlib.impl.reflection.ClassList": {
                switch (invocation.getMethod().getName()) {
                    case "count": {
                        return new WasmArrayLength(context.generate(invocation.getArguments().get(0)));
                    }
                    case "get": {
                        WasmExpression arg = context.generate(invocation.getArguments().get(0));
                        WasmExpression index = context.generate(invocation.getArguments().get(1));
                        WasmArray arrayType = context.classInfoProvider().reflection().getClassArrayType();
                        return new WasmArrayGet(arrayType, arg, index);
                    }
                }
                break;
            }
            case "org.teavm.classlib.impl.reflection.FieldReader": {
                WasmExpression fn = context.generate(invocation.getArguments().get(0));
                WasmExpression arg = context.generate(invocation.getArguments().get(1));
                WasmType.CompositeReference objectType = context.classInfoProvider().getClassInfo("java.lang.Object").getType();
                WasmFunctionType type = context.functionTypes().of(objectType, objectType);
                return new WasmCallReference(fn, type, arg);
            }
            case "org.teavm.classlib.impl.reflection.FieldWriter": {
                WasmExpression fn = context.generate(invocation.getArguments().get(0));
                WasmExpression arg = context.generate(invocation.getArguments().get(1));
                WasmExpression value = context.generate(invocation.getArguments().get(2));
                WasmType.CompositeReference objectType = context.classInfoProvider().getClassInfo("java.lang.Object").getType();
                WasmFunctionType type = context.functionTypes().of(null, objectType, objectType);
                return new WasmCallReference(fn, type, arg, value);
            }
            case "org.teavm.classlib.impl.reflection.MethodCaller": {
                WasmExpression fn = context.generate(invocation.getArguments().get(0));
                WasmExpression instanceArg = context.generate(invocation.getArguments().get(1));
                WasmExpression paramsArg = context.generate(invocation.getArguments().get(2));
                WasmType.CompositeReference objectType = context.classInfoProvider().getClassInfo("java.lang.Object").getType();
                WasmType.CompositeReference objArrayType = context.classInfoProvider().getClassInfo(ValueType.arrayOf(ValueType.object("java.lang.Object"))).getType();
                WasmFunctionType type = context.functionTypes().of(objectType, objectType, objArrayType);
                return new WasmCallReference(fn, type, instanceArg, paramsArg);
            }
            case "java.lang.Class": {
                switch (invocation.getMethod().getName()) {
                    case "createMetadata": {
                        return new WasmCall(this.getInitReflectionFunction(context));
                    }
                    case "newInstanceImpl": {
                        WasmGCClassInfo classClass = context.classInfoProvider().getClassInfo("java.lang.Class");
                        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
                        WasmFunctionType functionType = context.functionTypes().of(objectClass.getType(), new WasmType[0]);
                        WasmExpression arg = context.generate(invocation.getArguments().get(0));
                        WasmStructGet instantiator = new WasmStructGet(classClass.getStructure(), arg, context.classInfoProvider().getClassInstantiatorOffset());
                        WasmBlock outerBlock = new WasmBlock(false);
                        outerBlock.setType(objectClass.getType().asBlock());
                        WasmBlock innerBlock = new WasmBlock(false);
                        innerBlock.setType(functionType.getReference().asBlock());
                        WasmNullBranch nullBranch = new WasmNullBranch(WasmNullCondition.NOT_NULL, instantiator, innerBlock);
                        innerBlock.getBody().add(nullBranch);
                        WasmBreak br = new WasmBreak(outerBlock);
                        br.setResult(new WasmNullConstant(objectClass.getType()));
                        innerBlock.getBody().add(br);
                        WasmCallReference call = new WasmCallReference(innerBlock, functionType);
                        outerBlock.getBody().add(call);
                        call.setSuspensionPoint(context.isAsync());
                        return outerBlock;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    private WasmExpression fieldInfoCall(InvocationExpr invocation, WasmGCIntrinsicContext context, int fieldIndex) {
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        return new WasmStructGet(context.classInfoProvider().reflection().getReflectionFieldType(), arg, fieldIndex);
    }

    private WasmExpression methodInfoCall(InvocationExpr invocation, WasmGCIntrinsicContext context, int fieldIndex) {
        WasmExpression arg = context.generate(invocation.getArguments().get(0));
        return new WasmStructGet(context.classInfoProvider().reflection().getReflectionMethodType(), arg, fieldIndex);
    }

    private WasmExpression wrapAnnotations(WasmExpression expression, WasmGCIntrinsicContext context) {
        return new WasmCall(this.getWrapAnnotationsFunction(context), expression);
    }

    private WasmFunction getWrapAnnotationsFunction(WasmGCIntrinsicContext context) {
        if (this.wrapAnnotationsFunction == null) {
            WasmGCClassInfo annotArrayInfo = context.classInfoProvider().getClassInfo(ValueType.arrayOf(ValueType.object("java.lang.annotation.Annotation")));
            WasmGCClassInfo annotInfo = context.classInfoProvider().getClassInfo("java.lang.annotation.Annotation");
            WasmType.CompositeReference objectArray = annotArrayInfo.getType();
            WasmType.CompositeReference arrayDataType = context.classInfoProvider().getObjectArrayType().getReference();
            WasmGCClassInfo classClass = context.classInfoProvider().getClassInfo("java.lang.Class");
            this.wrapAnnotationsFunction = new WasmFunction(context.functionTypes().of(objectArray, arrayDataType));
            this.wrapAnnotationsFunction.setName(context.names().topLevel("@teavm.wrapAnnotations"));
            context.module().functions.add(this.wrapAnnotationsFunction);
            WasmLocal param = new WasmLocal(arrayDataType);
            this.wrapAnnotationsFunction.add(param);
            WasmBlock nullCheck = new WasmBlock(false);
            nullCheck.setType(arrayDataType.composite.getNonNullReference().asBlock());
            nullCheck.getBody().add(new WasmNullBranch(WasmNullCondition.NOT_NULL, new WasmGetLocal(param), nullCheck));
            nullCheck.getBody().add(new WasmReturn(new WasmNullConstant(objectArray)));
            this.wrapAnnotationsFunction.getBody().add(new WasmDrop(nullCheck));
            WasmStructNew structNew = new WasmStructNew(annotArrayInfo.getStructure());
            WasmCall arrayCls = new WasmCall(context.classInfoProvider().getGetArrayClassFunction(), new WasmGetGlobal(annotInfo.getPointer()));
            WasmStructGet arrayVt = new WasmStructGet(classClass.getStructure(), arrayCls, context.classInfoProvider().getClassVtFieldOffset());
            structNew.getInitializers().add(arrayVt);
            structNew.getInitializers().add(new WasmNullConstant(WasmType.Reference.EQ));
            structNew.getInitializers().add(new WasmCast(new WasmGetLocal(param), arrayDataType.composite.getNonNullReference()));
            this.wrapAnnotationsFunction.getBody().add(structNew);
        }
        return this.wrapAnnotationsFunction;
    }

    private WasmFunction getInitReflectionFunction(WasmGCIntrinsicContext context) {
        if (this.initReflectionFunction == null) {
            this.initReflectionFunction = new WasmFunction(context.functionTypes().of(null, new WasmType[0]));
            this.initReflectionFunction.setName(context.names().topLevel("@teavm.initReflection"));
            context.module().functions.add(this.initReflectionFunction);
            WasmGCAnnotationsHelper helper = new WasmGCAnnotationsHelper(context.hierarchy().getClassSource(), context.classInfoProvider(), context.strings());
            this.initReflectionFields(context, this.initReflectionFunction, helper);
            this.initReflectionMethods(context, this.initReflectionFunction, helper);
            this.initReflectionInstantiator(context, this.initReflectionFunction);
        }
        return this.initReflectionFunction;
    }

    private void initReflectionFields(WasmGCIntrinsicContext context, WasmFunction function, WasmGCAnnotationsHelper annotationsHelper) {
        WasmGCReflectionProvider wasmGcReflection = context.classInfoProvider().reflection();
        WasmGCClassInfo classClass = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
        for (String className : this.reflection.getClassesWithReflectableFields()) {
            ClassReader cls = context.hierarchy().getClassSource().get(className);
            if (cls == null || cls.getFields().isEmpty()) continue;
            boolean skipPrivates = ReflectionDependencyListener.shouldSkipPrivates(cls);
            WasmArrayNewFixed array = new WasmArrayNewFixed(wasmGcReflection.getReflectionFieldArrayType());
            WasmGCClassInfo classInfo = context.classInfoProvider().getClassInfo(className);
            function.getBody().add(new WasmStructSet(classClass.getStructure(), new WasmGetGlobal(classInfo.getPointer()), context.classInfoProvider().getClassFieldsOffset(), array));
            Set<String> accessibleFields = this.reflection.getAccessibleFields(className);
            for (FieldReader fieldReader : cls.getFields()) {
                if (skipPrivates && (fieldReader.getLevel() == AccessLevel.PRIVATE || fieldReader.getLevel() == AccessLevel.PACKAGE_PRIVATE)) continue;
                WasmStructNew fieldInit = new WasmStructNew(wasmGcReflection.getReflectionFieldType());
                array.getElements().add(fieldInit);
                WasmGCStringConstant nameStr = context.strings().getStringConstant(fieldReader.getName());
                fieldInit.getInitializers().add(new WasmGetGlobal(nameStr.global));
                fieldInit.getInitializers().add(new WasmInt32Constant(ElementModifier.pack(fieldReader.readModifiers())));
                fieldInit.getInitializers().add(new WasmInt32Constant(fieldReader.getLevel().ordinal()));
                WasmExpression fieldAnnotations = annotationsHelper.generateAnnotations(fieldReader.getAnnotations().all());
                fieldInit.getInitializers().add(fieldAnnotations != null ? fieldAnnotations : new WasmNullConstant(context.classInfoProvider().getObjectArrayType().getReference()));
                fieldInit.getInitializers().add(this.renderType(context, fieldReader.getType()));
                if (accessibleFields != null && accessibleFields.contains(fieldReader.getName()) && this.reflection.isGetReached() && this.reflection.isRead(fieldReader.getReference())) {
                    WasmFunction getter = this.generateGetter(context, fieldReader);
                    fieldInit.getInitializers().add(new WasmFunctionReference(getter));
                } else {
                    WasmFunctionType getterType = context.functionTypes().of(objectClass.getType(), objectClass.getType());
                    fieldInit.getInitializers().add(new WasmNullConstant(getterType.getReference()));
                }
                if (accessibleFields != null && accessibleFields.contains(fieldReader.getName()) && this.reflection.isSetReached() && this.reflection.isWritten(fieldReader.getReference())) {
                    WasmFunction setter = this.generateSetter(context, fieldReader);
                    fieldInit.getInitializers().add(new WasmFunctionReference(setter));
                    continue;
                }
                WasmFunctionType setterType = context.functionTypes().of(null, objectClass.getType(), objectClass.getType());
                fieldInit.getInitializers().add(new WasmNullConstant(setterType.getReference()));
            }
        }
    }

    private void initReflectionMethods(WasmGCIntrinsicContext context, WasmFunction function, WasmGCAnnotationsHelper annotationsHelper) {
        WasmGCReflectionProvider wasmGcReflection = context.classInfoProvider().reflection();
        WasmGCClassInfo classClass = context.classInfoProvider().getClassInfo("java.lang.Class");
        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
        WasmGCClassInfo objectArrayClass = context.classInfoProvider().getClassInfo(ValueType.arrayOf(ValueType.object("java.lang.Object")));
        WasmFunctionType callerType = context.functionTypes().of(objectClass.getType(), objectClass.getType(), objectArrayClass.getType());
        for (String className : this.reflection.getClassesWithReflectableMethods()) {
            ClassReader cls = context.hierarchy().getClassSource().get(className);
            if (cls == null || cls.getMethods().isEmpty()) continue;
            boolean skipPrivates = ReflectionDependencyListener.shouldSkipPrivates(cls);
            WasmArrayNewFixed array = new WasmArrayNewFixed(wasmGcReflection.getReflectionMethodArrayType());
            WasmGCClassInfo classInfo = context.classInfoProvider().getClassInfo(className);
            function.getBody().add(new WasmStructSet(classClass.getStructure(), new WasmGetGlobal(classInfo.getPointer()), context.classInfoProvider().getClassMethodsOffset(), array));
            Set<MethodDescriptor> accessibleMethods = this.reflection.getAccessibleMethods(className);
            for (MethodReader methodReader : cls.getMethods()) {
                if (skipPrivates && (methodReader.getLevel() == AccessLevel.PRIVATE || methodReader.getLevel() == AccessLevel.PACKAGE_PRIVATE) || methodReader.getName().equals("<clinit>")) continue;
                WasmStructNew methodInit = new WasmStructNew(wasmGcReflection.getReflectionMethodType());
                array.getElements().add(methodInit);
                WasmGCStringConstant nameStr = context.strings().getStringConstant(methodReader.getName());
                methodInit.getInitializers().add(new WasmGetGlobal(nameStr.global));
                methodInit.getInitializers().add(new WasmInt32Constant(ElementModifier.pack(methodReader.readModifiers())));
                methodInit.getInitializers().add(new WasmInt32Constant(methodReader.getLevel().ordinal()));
                WasmExpression methodAnnotations = annotationsHelper.generateAnnotations(methodReader.getAnnotations().all());
                methodInit.getInitializers().add(methodAnnotations != null ? methodAnnotations : new WasmNullConstant(context.classInfoProvider().getObjectArrayType().getReference()));
                methodInit.getInitializers().add(this.renderType(context, methodReader.getResultType()));
                WasmArrayNewFixed parametersArray = new WasmArrayNewFixed(wasmGcReflection.getClassArrayType());
                for (ValueType param : methodReader.getParameterTypes()) {
                    parametersArray.getElements().add(this.renderType(context, param));
                }
                methodInit.getInitializers().add(parametersArray);
                if (accessibleMethods != null && accessibleMethods.contains(methodReader.getDescriptor()) && this.reflection.isCallReached() && this.reflection.isCalled(methodReader.getReference())) {
                    WasmFunction caller = this.generateCaller(context, methodReader);
                    methodInit.getInitializers().add(new WasmFunctionReference(caller));
                    continue;
                }
                methodInit.getInitializers().add(new WasmNullConstant(callerType.getReference()));
            }
        }
    }

    private void initReflectionInstantiator(WasmGCIntrinsicContext context, WasmFunction function) {
        MethodDependencyInfo dep = context.dependency().getMethod(new MethodReference(Class.class, "newInstance", Object.class));
        if (dep == null || !dep.isUsed()) {
            return;
        }
        ValueDependencyInfo node = dep.getVariable(0).getClassValueNode();
        if (node == null) {
            return;
        }
        WasmGCClassInfo classClass = context.classInfoProvider().getClassInfo("java.lang.Class");
        for (ValueType type : node.getTypes()) {
            WasmGCClassInfo classInfo;
            MethodReader method;
            ClassReader cls;
            if (!(type instanceof ValueType.Object) || this.typesToSkip.contains(type) || (cls = context.hierarchy().getClassSource().get(((ValueType.Object)type).getClassName())) == null || cls.hasModifier(ElementModifier.ABSTRACT) || (method = cls.getMethod(new MethodDescriptor("<init>", Void.TYPE))) == null || method.getProgram() == null && !method.hasModifier(ElementModifier.NATIVE) || (classInfo = context.classInfoProvider().getClassInfo(cls.getName())).getStructure() == null) continue;
            WasmFunction instantiator = this.generateInstantiator(context, method);
            function.getBody().add(new WasmStructSet(classClass.getStructure(), new WasmGetGlobal(classInfo.getPointer()), context.classInfoProvider().getClassInstantiatorOffset(), new WasmFunctionReference(instantiator)));
        }
    }

    private WasmFunction generateGetter(WasmGCIntrinsicContext context, FieldReader field) {
        WasmExpression result;
        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
        WasmFunctionType getterType = context.functionTypes().of(objectClass.getType(), objectClass.getType());
        WasmFunction function = new WasmFunction(getterType);
        function.setName(context.names().topLevel(context.names().suggestForStaticField(field.getReference()) + "@getter"));
        context.module().functions.add(function);
        function.setReferenced(true);
        WasmLocal thisVar = new WasmLocal(objectClass.getType(), "this");
        function.add(thisVar);
        WasmGCClassInfo classInfo = context.classInfoProvider().getClassInfo(field.getOwnerName());
        if (field.hasModifier(ElementModifier.STATIC)) {
            if (context.classInitInfo().isDynamicInitializer(field.getOwnerName()) && classInfo.getInitializerPointer() != null) {
                WasmGetGlobal initRef = new WasmGetGlobal(classInfo.getInitializerPointer());
                WasmFunctionType initType = context.functionTypes().of(null, new WasmType[0]);
                function.getBody().add(new WasmCallReference(initRef, initType));
            }
            WasmGlobal global = context.classInfoProvider().getStaticFieldLocation(field.getReference());
            result = new WasmGetGlobal(global);
        } else {
            WasmCast castInstance = new WasmCast(new WasmGetLocal(thisVar), classInfo.getType());
            WasmStructGet structGet = new WasmStructGet(classInfo.getStructure(), castInstance, context.classInfoProvider().getFieldIndex(field.getReference()));
            if (field.getType() instanceof ValueType.Primitive) {
                switch (((ValueType.Primitive)field.getType()).getKind()) {
                    case BYTE: 
                    case SHORT: {
                        structGet.setSignedType(WasmSignedType.SIGNED);
                        break;
                    }
                    case BOOLEAN: 
                    case CHARACTER: {
                        structGet.setSignedType(WasmSignedType.UNSIGNED);
                        break;
                    }
                }
            }
            result = structGet;
        }
        function.getBody().add(this.boxIfNecessary(context, result, field.getType()));
        return function;
    }

    private WasmFunction generateSetter(WasmGCIntrinsicContext context, FieldReader field) {
        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
        WasmFunctionType setterType = context.functionTypes().of(null, objectClass.getType(), objectClass.getType());
        WasmFunction function = new WasmFunction(setterType);
        function.setName(context.names().topLevel(context.names().suggestForStaticField(field.getReference()) + "@setter"));
        context.module().functions.add(function);
        function.setReferenced(true);
        WasmLocal thisVar = new WasmLocal(objectClass.getType(), "this");
        function.add(thisVar);
        WasmLocal valueVar = new WasmLocal(objectClass.getType(), "value");
        function.add(valueVar);
        WasmExpression value = this.unboxIfNecessary(context, new WasmGetLocal(valueVar), field.getType());
        WasmGCClassInfo classInfo = context.classInfoProvider().getClassInfo(field.getOwnerName());
        if (field.hasModifier(ElementModifier.STATIC)) {
            this.initClass(context, classInfo, field.getOwnerName(), function);
            WasmGlobal global = context.classInfoProvider().getStaticFieldLocation(field.getReference());
            function.getBody().add(new WasmSetGlobal(global, value));
        } else {
            WasmCast castInstance = new WasmCast(new WasmGetLocal(thisVar), classInfo.getType());
            WasmStructSet structSet = new WasmStructSet(classInfo.getStructure(), castInstance, context.classInfoProvider().getFieldIndex(field.getReference()), value);
            function.getBody().add(structSet);
        }
        return function;
    }

    private WasmFunction generateCaller(WasmGCIntrinsicContext context, MethodReader method) {
        WasmExpression call;
        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
        WasmGCClassInfo objectArrayClass = context.classInfoProvider().getClassInfo(ValueType.arrayOf(ValueType.object("java.lang.Object")));
        WasmFunctionType callerType = context.functionTypes().of(objectClass.getType(), objectClass.getType(), objectArrayClass.getType());
        WasmFunction function = new WasmFunction(callerType);
        function.setName(context.names().topLevel(context.names().suggestForMethod(method.getReference()) + "@caller"));
        context.module().functions.add(function);
        function.setReferenced(true);
        WasmField dataField = objectArrayClass.getStructure().getFields().get(2);
        WasmLocal thisVar = new WasmLocal(objectClass.getType(), "this");
        function.add(thisVar);
        WasmLocal argsVar = new WasmLocal(objectArrayClass.getType(), "args");
        function.add(argsVar);
        WasmLocal argsDataVar = new WasmLocal(dataField.getUnpackedType(), "argsData");
        function.add(argsDataVar);
        WasmLocal instanceVar = null;
        function.getBody().add(new WasmSetLocal(argsDataVar, new WasmStructGet(objectArrayClass.getStructure(), new WasmGetLocal(argsVar), dataField.getIndex())));
        WasmGCClassInfo classInfo = context.classInfoProvider().getClassInfo(method.getOwnerName());
        ArrayList<WasmExpression> args = new ArrayList<WasmExpression>();
        WasmFunction callee = null;
        boolean virtual = false;
        if (method.hasModifier(ElementModifier.STATIC)) {
            this.initClass(context, classInfo, method.getOwnerName(), function);
            callee = context.functions().forStaticMethod(method.getReference());
        } else {
            if (method.getName().equals("<init>")) {
                instanceVar = new WasmLocal(classInfo.getStructure().getNonNullReference(), "instance");
                function.add(instanceVar);
                function.getBody().add(new WasmSetLocal(instanceVar, new WasmStructNewDefault(classInfo.getStructure())));
                function.getBody().add(new WasmStructSet(classInfo.getStructure(), new WasmGetLocal(instanceVar), 0, new WasmGetGlobal(classInfo.getVirtualTablePointer())));
                args.add(new WasmGetLocal(instanceVar));
            } else {
                boolean bl = virtual = !method.hasModifier(ElementModifier.FINAL) && method.getLevel() != AccessLevel.PRIVATE;
                if (!virtual) {
                    WasmCast castInstance = new WasmCast(new WasmGetLocal(thisVar), classInfo.getType());
                    args.add(castInstance);
                }
            }
            if (!virtual) {
                callee = context.functions().forInstanceMethod(method.getReference());
            }
        }
        WasmType.CompositeReference dataType = (WasmType.CompositeReference)dataField.getUnpackedType();
        WasmArray dataArray = (WasmArray)dataType.composite;
        for (int i = 0; i < method.parameterCount(); ++i) {
            WasmArrayGet rawArg = new WasmArrayGet(dataArray, new WasmGetLocal(argsDataVar), new WasmInt32Constant(i));
            args.add(this.unboxIfNecessary(context, rawArg, method.parameterType(i)));
        }
        if (virtual) {
            WasmGCVirtualCallGenerator callGen = new WasmGCVirtualCallGenerator(context.virtualTables(), context.classInfoProvider());
            call = callGen.generate(method.getReference(), false, thisVar, args);
        } else {
            call = new WasmCall(callee, args.toArray(new WasmExpression[0]));
        }
        function.getBody().add(this.boxIfNecessary(context, call, method.getResultType()));
        if (method.getResultType() == ValueType.VOID) {
            if (method.getName().equals("<init>")) {
                function.getBody().add(new WasmGetLocal(instanceVar));
            } else {
                function.getBody().add(new WasmNullConstant(objectClass.getType()));
            }
        }
        return function;
    }

    private WasmFunction generateInstantiator(WasmGCIntrinsicContext context, MethodReader method) {
        String className = method.getOwnerName();
        WasmGCClassInfo objectClass = context.classInfoProvider().getClassInfo("java.lang.Object");
        WasmFunctionType instantiatorType = context.functionTypes().of(objectClass.getType(), new WasmType[0]);
        WasmFunction instantiator = new WasmFunction(instantiatorType);
        instantiator.setName(context.names().topLevel(className + "@instantiate"));
        instantiator.setReferenced(true);
        context.module().functions.add(instantiator);
        WasmGCClassInfo classInfo = context.classInfoProvider().getClassInfo(className);
        WasmLocal localVar = new WasmLocal(classInfo.getType(), "instance");
        instantiator.add(localVar);
        this.initClass(context, classInfo, method.getOwnerName(), instantiator);
        instantiator.getBody().add(new WasmSetLocal(localVar, new WasmStructNewDefault(classInfo.getStructure())));
        instantiator.getBody().add(new WasmStructSet(objectClass.getStructure(), new WasmGetLocal(localVar), 0, new WasmGetGlobal(classInfo.getVirtualTablePointer())));
        WasmCall call = new WasmCall(context.functions().forInstanceMethod(method.getReference()), new WasmGetLocal(localVar));
        instantiator.getBody().add(call);
        instantiator.getBody().add(new WasmGetLocal(localVar));
        if (context.isAsyncMethod(method.getReference())) {
            call.setSuspensionPoint(true);
            CoroutineTransformation transformation = new CoroutineTransformation(context.functionTypes(), context.functions(), context.classInfoProvider());
            transformation.transform(instantiator);
        }
        return instantiator;
    }

    private void initClass(WasmGCIntrinsicContext context, WasmGCClassInfo classInfo, String className, WasmFunction function) {
        if (context.classInitInfo().isDynamicInitializer(className) && classInfo.getInitializerPointer() != null) {
            WasmGetGlobal initRef = new WasmGetGlobal(classInfo.getInitializerPointer());
            WasmFunctionType initType = context.functionTypes().of(null, new WasmType[0]);
            function.getBody().add(new WasmCallReference(initRef, initType));
        }
    }

    private WasmExpression boxIfNecessary(WasmGCIntrinsicContext context, WasmExpression expr, ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return this.box(context, Boolean.class, type, expr);
                }
                case BYTE: {
                    return this.box(context, Byte.class, type, expr);
                }
                case SHORT: {
                    return this.box(context, Short.class, type, expr);
                }
                case CHARACTER: {
                    return this.box(context, Character.class, type, expr);
                }
                case INTEGER: {
                    return this.box(context, Integer.class, type, expr);
                }
                case LONG: {
                    return this.box(context, Long.class, type, expr);
                }
                case FLOAT: {
                    return this.box(context, Float.class, type, expr);
                }
                case DOUBLE: {
                    return this.box(context, Double.class, type, expr);
                }
            }
        }
        return expr;
    }

    private WasmExpression box(WasmGCIntrinsicContext context, Class<?> wrapperType, ValueType sourceType, WasmExpression expr) {
        MethodReference method = new MethodReference(wrapperType.getName(), "valueOf", sourceType, ValueType.object(wrapperType.getName()));
        WasmFunction function = context.functions().forStaticMethod(method);
        return new WasmCall(function, expr);
    }

    private WasmExpression unboxIfNecessary(WasmGCIntrinsicContext context, WasmExpression expr, ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return this.unbox(context, Boolean.TYPE, Boolean.class, expr);
                }
                case BYTE: {
                    return this.unbox(context, Byte.TYPE, Byte.class, expr);
                }
                case SHORT: {
                    return this.unbox(context, Short.TYPE, Short.class, expr);
                }
                case CHARACTER: {
                    return this.unbox(context, Character.TYPE, Character.class, expr);
                }
                case INTEGER: {
                    return this.unbox(context, Integer.TYPE, Integer.class, expr);
                }
                case LONG: {
                    return this.unbox(context, Long.TYPE, Long.class, expr);
                }
                case FLOAT: {
                    return this.unbox(context, Float.TYPE, Float.class, expr);
                }
                case DOUBLE: {
                    return this.unbox(context, Double.TYPE, Double.class, expr);
                }
            }
        } else if (type instanceof ValueType.Object && ((ValueType.Object)type).getClassName().equals("java.lang.Object")) {
            return expr;
        }
        WasmType targetType = context.typeMapper().mapType(type);
        if (targetType == context.typeMapper().mapType(ValueType.object("java.lang.Object"))) {
            return expr;
        }
        return new WasmCast(expr, (WasmType.Reference)targetType);
    }

    private WasmExpression unbox(WasmGCIntrinsicContext context, Class<?> primitiveType, Class<?> wrapperType, WasmExpression expr) {
        MethodReference method = new MethodReference(wrapperType.getName(), primitiveType.getName() + "Value", ValueType.parse(primitiveType));
        WasmFunction function = context.functions().forInstanceMethod(method);
        WasmCast cast = new WasmCast(expr, context.classInfoProvider().getClassInfo(wrapperType.getName()).getType());
        return new WasmCall(function, cast);
    }

    private WasmExpression renderType(WasmGCIntrinsicContext context, ValueType type) {
        ValueType itemType;
        if (type instanceof ValueType.Array && !((itemType = ((ValueType.Array)type).getItemType()) instanceof ValueType.Primitive)) {
            int degree = 0;
            while (type instanceof ValueType.Array) {
                type = ((ValueType.Array)type).getItemType();
                ++degree;
            }
            WasmExpression result = new WasmGetGlobal(context.classInfoProvider().getClassInfo(type).getPointer());
            while (degree-- > 0) {
                result = new WasmCall(context.classInfoProvider().getGetArrayClassFunction(), result);
            }
            return result;
        }
        WasmGCClassInfo classConstant = context.classInfoProvider().getClassInfo(type);
        return new WasmGetGlobal(classConstant.getPointer());
    }
}

