/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.classlib.ReflectionContext;
import org.teavm.classlib.ReflectionSupplier;
import org.teavm.classlib.impl.reflection.ClassList;
import org.teavm.classlib.impl.reflection.FieldInfo;
import org.teavm.classlib.impl.reflection.MethodInfo;
import org.teavm.classlib.java.lang.reflect.AnnotationGenerationHelper;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.AccessLevel;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MemberReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ReflectionDependencyListener
extends AbstractDependencyListener {
    private List<ReflectionSupplier> reflectionSuppliers;
    private MethodReference fieldGet = new MethodReference(Field.class, "getWithoutCheck", Object.class, Object.class);
    private MethodReference fieldSet = new MethodReference(Field.class, "setWithoutCheck", Object.class, Object.class, Void.TYPE);
    private MethodReference newInstance = new MethodReference(Constructor.class, "newInstance", Object[].class, Object.class);
    private MethodReference invokeMethod = new MethodReference(Method.class, "invoke", Object.class, Object[].class, Object.class);
    private MethodReference getFields = new MethodReference(Class.class, "getDeclaredFields", Field[].class);
    private MethodReference getConstructors = new MethodReference(Class.class, "getDeclaredConstructors", Constructor[].class);
    private MethodReference getMethods = new MethodReference(Class.class, "getDeclaredMethods", Method[].class);
    private MethodReference getFieldAnnotations = new MethodReference(Field.class, "getDeclaredAnnotations", Annotation[].class);
    private MethodReference getMethodAnnotations = new MethodReference(Method.class, "getDeclaredAnnotations", Annotation[].class);
    private MethodReference getConstructorAnnotations = new MethodReference(Constructor.class, "getDeclaredAnnotations", Annotation[].class);
    private MethodReference forName = new MethodReference(Class.class, "forName", String.class, Boolean.class, ClassLoader.class, Class.class);
    private MethodReference classNewInstance = new MethodReference(Class.class, "newInstance", Object.class);
    private MethodReference forNameShort = new MethodReference(Class.class, "forName", String.class, Class.class);
    private MethodReference fieldGetType = new MethodReference(Field.class, "getType", Class.class);
    private MethodReference fieldGetName = new MethodReference(Field.class, "getName", String.class);
    private MethodReference methodGetReturnType = new MethodReference(Method.class, "getReturnType", Class.class);
    private MethodReference methodGetParameterTypes = new MethodReference(Method.class, "getParameterTypes", Class[].class);
    private MethodReference constructorGetParameterTypes = new MethodReference(Constructor.class, "getParameterTypes", Class[].class);
    private Map<String, Set<String>> accessibleFieldCache = new LinkedHashMap<String, Set<String>>();
    private Map<String, Set<MethodDescriptor>> accessibleMethodCache = new LinkedHashMap<String, Set<MethodDescriptor>>();
    private Set<String> classesWithReflectableFields = new LinkedHashSet<String>();
    private Set<String> classesWithReflectableMethods = new LinkedHashSet<String>();
    private DependencyNode allClasses;
    private DependencyNode typesInReflectableSignaturesNode;
    private Set<MethodReference> virtualMethods = new HashSet<MethodReference>();
    private Set<MethodReference> virtualCallSites = new HashSet<MethodReference>();
    private Set<String> classesFoundByName = new HashSet<String>();
    private Set<MethodReference> calledMethods = new HashSet<MethodReference>();
    private Set<FieldReference> readFields = new HashSet<FieldReference>();
    private Set<FieldReference> writtenFields = new HashSet<FieldReference>();
    private List<FieldReader> fieldsReadViaReflection = new ArrayList<FieldReader>();
    private List<MethodReader> methodsReadViaReflection = new ArrayList<MethodReader>();
    private DependencyNode fieldsAnnotationsConsumer;
    private DependencyNode methodsAnnotationsConsumer;
    private boolean getReached;
    private boolean setReached;
    private boolean callReached;
    private AnnotationGenerationHelper annotHelper;

    public ReflectionDependencyListener(List<ReflectionSupplier> reflectionSuppliers, boolean enumsAsInts, boolean needAnnotImplCtor) {
        this.reflectionSuppliers = reflectionSuppliers;
        this.annotHelper = new AnnotationGenerationHelper(enumsAsInts, needAnnotImplCtor);
    }

    public boolean isVirtual(MethodReference methodRef) {
        return this.virtualMethods.contains(methodRef);
    }

    public Collection<MethodReference> getVirtualCallSites() {
        return this.virtualCallSites;
    }

    public boolean isCalled(MethodReference methodRef) {
        return this.calledMethods.contains(methodRef);
    }

    public boolean isRead(FieldReference fieldRef) {
        return this.readFields.contains(fieldRef);
    }

    public boolean isWritten(FieldReference fieldRef) {
        return this.writtenFields.contains(fieldRef);
    }

    @Override
    public void started(DependencyAgent agent) {
        this.allClasses = agent.createNode();
        this.typesInReflectableSignaturesNode = agent.createNode();
        DependencyNode constructorParamTypes = agent.linkField(new FieldReference(Constructor.class.getName(), "parameterTypes")).getValue();
        constructorParamTypes.getArrayItem().propagate(agent.getType(ValueType.object("java.lang.Class")));
        this.typesInReflectableSignaturesNode.connect(constructorParamTypes.getArrayItem().getClassValueNode());
        DependencyNode methodParamTypes = agent.linkField(new FieldReference(Method.class.getName(), "parameterTypes")).getValue();
        methodParamTypes.getArrayItem().propagate(agent.getType(ValueType.object("java.lang.Class")));
        this.typesInReflectableSignaturesNode.connect(methodParamTypes.getArrayItem().getClassValueNode());
        agent.linkMethod(new MethodReference(FieldInfo.class, "name", String.class)).getResult().propagate(agent.getType(ValueType.object("java.lang.String")));
        agent.linkMethod(new MethodReference(FieldInfo.class, "type", Class.class)).getResult().propagate(agent.getType(ValueType.object("java.lang.Class")));
        agent.linkMethod(new MethodReference(FieldInfo.class, "annotations", Annotation[].class)).getResult().propagate(agent.getType(ValueType.parse(Annotation[].class)));
        agent.linkMethod(new MethodReference(MethodInfo.class, "name", String.class)).getResult().propagate(agent.getType(ValueType.object("java.lang.String")));
        agent.linkMethod(new MethodReference(MethodInfo.class, "returnType", Class.class)).getResult().propagate(agent.getType(ValueType.object("java.lang.Class")));
        agent.linkMethod(new MethodReference(MethodInfo.class, "annotations", Annotation[].class)).getResult().propagate(agent.getType(ValueType.parse(Annotation[].class)));
        agent.linkMethod(new MethodReference(ClassList.class, "get", Integer.TYPE, Class.class)).getResult().propagate(agent.getType(ValueType.object("java.lang.Class")));
        ReflectionContextImpl context = new ReflectionContextImpl(agent);
        for (ReflectionSupplier reflectionSupplier : this.reflectionSuppliers) {
            for (String className : reflectionSupplier.getClassesFoundByName(context)) {
                if (!this.classesFoundByName.add(className)) continue;
                agent.linkClass(className);
            }
        }
        this.allClasses.addConsumer(type -> {
            if (type.getValueType() instanceof ValueType.Object) {
                String className = ((ValueType.Object)type.getValueType()).getClassName();
                if (this.reflectionSuppliers.stream().anyMatch(s -> s.isClassFoundByName(context, className)) && this.classesFoundByName.add(className)) {
                    agent.linkClass(className);
                }
            }
        });
        if (!this.classesFoundByName.isEmpty()) {
            MethodDependency getName = agent.linkMethod(new MethodReference(Class.class, "getName", String.class));
            getName.getVariable(0).propagate(agent.getType(ValueType.object("java.lang.Class")));
            for (String className : this.classesFoundByName) {
                getName.getVariable(0).getClassValueNode().propagate(agent.getType(ValueType.object(className)));
            }
        }
    }

    public boolean isGetReached() {
        return this.getReached;
    }

    public boolean isSetReached() {
        return this.setReached;
    }

    public boolean isCallReached() {
        return this.callReached;
    }

    public Set<String> getClassesWithReflectableFields() {
        return this.classesWithReflectableFields;
    }

    public Set<String> getClassesWithReflectableMethods() {
        return this.classesWithReflectableMethods;
    }

    public Set<String> getAccessibleFields(String className) {
        return this.accessibleFieldCache.get(className);
    }

    public Set<MethodDescriptor> getAccessibleMethods(String className) {
        return this.accessibleMethodCache.get(className);
    }

    @Override
    public void classReached(DependencyAgent agent, String className) {
        this.allClasses.propagate(agent.getType(ValueType.object(className)));
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        if (method.getReference().equals(this.fieldGet)) {
            this.handleFieldGet(agent, method);
        } else if (method.getReference().equals(this.fieldSet)) {
            this.handleFieldSet(agent, method);
        } else if (method.getReference().equals(this.newInstance)) {
            this.handleNewInstance(agent, method);
        } else if (method.getReference().equals(this.classNewInstance)) {
            this.handleClassNewInstance(agent, method);
        } else if (method.getReference().equals(this.invokeMethod)) {
            this.handleInvoke(agent, method);
        } else if (method.getReference().equals(this.getFields)) {
            method.getVariable(0).getClassValueNode().addConsumer(type -> {
                if (type.getValueType() instanceof ValueType.Object) {
                    String className = ((ValueType.Object)type.getValueType()).getClassName();
                    this.classesWithReflectableFields.add(className);
                    ClassReader cls = agent.getClassSource().get(className);
                    if (cls != null) {
                        boolean skipPrivates = ReflectionDependencyListener.shouldSkipPrivates(cls);
                        for (FieldReader fieldReader : cls.getFields()) {
                            if (skipPrivates && (fieldReader.getLevel() == AccessLevel.PRIVATE || fieldReader.getLevel() == AccessLevel.PACKAGE_PRIVATE)) continue;
                            this.linkType(agent, fieldReader.getType());
                            agent.linkField(fieldReader.getReference());
                            this.fieldsReadViaReflection.add(fieldReader);
                            if (this.fieldsAnnotationsConsumer == null) continue;
                            this.annotHelper.propagateAnnotationImplementations(agent, fieldReader.getAnnotations().all(), this.fieldsAnnotationsConsumer);
                        }
                    }
                }
            });
        } else if (method.getReference().equals(this.getFieldAnnotations)) {
            this.fieldsAnnotationsConsumer = method.getResult().getArrayItem();
            method.getResult().propagate(agent.getType(ValueType.parse(Annotation[].class)));
            for (FieldReader field : this.fieldsReadViaReflection) {
                this.annotHelper.propagateAnnotationImplementations(agent, field.getAnnotations().all(), this.fieldsAnnotationsConsumer);
            }
        } else if (method.getReference().equals(this.getConstructors) || method.getReference().equals(this.getMethods)) {
            method.getVariable(0).getClassValueNode().addConsumer(type -> {
                if (type.getValueType() instanceof ValueType.Object) {
                    String className = ((ValueType.Object)type.getValueType()).getClassName();
                    this.classesWithReflectableMethods.add(className);
                    ClassReader cls = agent.getClassSource().get(className);
                    if (cls != null) {
                        boolean skipPrivates = ReflectionDependencyListener.shouldSkipPrivates(cls);
                        for (MethodReader methodReader : cls.getMethods()) {
                            if (skipPrivates && (methodReader.getLevel() == AccessLevel.PRIVATE || methodReader.getLevel() == AccessLevel.PACKAGE_PRIVATE)) continue;
                            this.linkType(agent, methodReader.getResultType());
                            for (ValueType param : methodReader.getParameterTypes()) {
                                this.linkType(agent, param);
                            }
                            if (this.methodsAnnotationsConsumer != null) {
                                this.annotHelper.propagateAnnotationImplementations(agent, methodReader.getAnnotations().all(), this.methodsAnnotationsConsumer);
                            }
                            this.methodsReadViaReflection.add(methodReader);
                        }
                    }
                }
            });
        } else if (method.getReference().equals(this.getConstructorAnnotations) || method.getReference().equals(this.getMethodAnnotations)) {
            this.methodsAnnotationsConsumer = method.getResult().getArrayItem();
            method.getResult().propagate(agent.getType(ValueType.parse(Annotation[].class)));
            for (MethodReader reflectableMethod : this.methodsReadViaReflection) {
                this.annotHelper.propagateAnnotationImplementations(agent, reflectableMethod.getAnnotations().all(), this.methodsAnnotationsConsumer);
            }
        } else if (method.getReference().equals(this.forName) || method.getReference().equals(this.forNameShort)) {
            method.getResult().propagate(agent.getType(ValueType.object("java.lang.Class")));
            for (String className : this.classesFoundByName) {
                method.getResult().getClassValueNode().propagate(agent.getType(ValueType.object(className)));
            }
        } else if (method.getReference().equals(this.fieldGetType) || method.getReference().equals(this.methodGetReturnType)) {
            method.getResult().propagate(agent.getType(ValueType.object("java.lang.Class")));
            this.typesInReflectableSignaturesNode.connect(method.getResult().getClassValueNode());
        } else if (method.getReference().equals(this.fieldGetName)) {
            method.getResult().propagate(agent.getType(ValueType.object("java.lang.String")));
        } else if (method.getReference().equals(this.methodGetParameterTypes) || method.getReference().equals(this.constructorGetParameterTypes)) {
            method.getResult().propagate(agent.getType(ValueType.arrayOf(ValueType.object("java.lang.Class"))));
            method.getResult().getArrayItem().propagate(agent.getType(ValueType.object("java.lang.Class")));
            this.typesInReflectableSignaturesNode.connect(method.getResult().getArrayItem().getClassValueNode());
        }
    }

    public static boolean shouldSkipPrivates(ClassReader cls) {
        return cls.getName().equals("java.lang.Object") || cls.getName().equals("java.lang.Class");
    }

    private void handleFieldGet(DependencyAgent agent, MethodDependency method) {
        CallLocation location = new CallLocation(method.getReference());
        DependencyNode classValueNode = agent.linkMethod(this.getFields).addLocation(location).getVariable(0).getClassValueNode();
        this.getReached = true;
        classValueNode.addConsumer(reflectedType -> {
            if (!(reflectedType.getValueType() instanceof ValueType.Object)) {
                return;
            }
            String className = ((ValueType.Object)reflectedType.getValueType()).getClassName();
            Set<String> accessibleFields = this.getAccessibleFields(agent, className);
            ClassReader cls = agent.getClassSource().get(className);
            for (String fieldName : accessibleFields) {
                FieldReader field = cls.getField(fieldName);
                FieldDependency fieldDep = agent.linkField(field.getReference()).addLocation(location);
                if (field.hasModifier(ElementModifier.STATIC)) {
                    this.readFields.add(field.getReference());
                    this.propagateGet(agent, field.getType(), fieldDep.getValue(), method.getResult(), location);
                } else {
                    method.getVariable(1).addConsumer(new InstanceGetConsumer(agent, field.getReference(), method, location));
                }
                this.linkClassIfNecessary(agent, field, location);
            }
        });
    }

    private void handleFieldSet(DependencyAgent agent, MethodDependency method) {
        CallLocation location = new CallLocation(method.getReference());
        DependencyNode classValueNode = agent.linkMethod(this.getFields).addLocation(location).getVariable(0).getClassValueNode();
        this.setReached = true;
        classValueNode.addConsumer(reflectedType -> {
            if (!(reflectedType.getValueType() instanceof ValueType.Object)) {
                return;
            }
            String className = ((ValueType.Object)reflectedType.getValueType()).getClassName();
            Set<String> accessibleFields = this.getAccessibleFields(agent, className);
            ClassReader cls = agent.getClassSource().get(className);
            for (String fieldName : accessibleFields) {
                FieldReader field = cls.getField(fieldName);
                FieldDependency fieldDep = agent.linkField(field.getReference()).addLocation(location);
                if (field.hasModifier(ElementModifier.STATIC)) {
                    this.writtenFields.add(field.getReference());
                    this.propagateSet(agent, field.getType(), method.getVariable(2), fieldDep.getValue(), location);
                } else {
                    method.getVariable(1).addConsumer(new InstanceSetConsumer(agent, field.getReference(), method, location));
                }
                this.linkClassIfNecessary(agent, field, location);
            }
        });
    }

    private void handleNewInstance(DependencyAgent agent, MethodDependency method) {
        CallLocation location = new CallLocation(method.getReference());
        DependencyNode classValueNode = agent.linkMethod(this.getConstructors).addLocation(location).getVariable(0).getClassValueNode();
        this.callReached = true;
        classValueNode.addConsumer(reflectedType -> {
            if (!(reflectedType.getValueType() instanceof ValueType.Object)) {
                return;
            }
            String className = ((ValueType.Object)reflectedType.getValueType()).getClassName();
            ClassReader cls = agent.getClassSource().get(className);
            if (cls == null || cls.hasModifier(ElementModifier.ABSTRACT) || cls.hasModifier(ElementModifier.INTERFACE)) {
                return;
            }
            Set<MethodDescriptor> accessibleMethods = this.getAccessibleMethods(agent, className);
            boolean hasConstructors = false;
            for (MethodDescriptor methodDescriptor : accessibleMethods) {
                if (!methodDescriptor.getName().equals("<init>")) continue;
                MethodReader calledMethod = cls.getMethod(methodDescriptor);
                MethodDependency calledMethodDep = agent.linkMethod(calledMethod.getReference()).addLocation(location);
                calledMethodDep.use();
                for (int i = 0; i < calledMethod.parameterCount(); ++i) {
                    this.propagateSet(agent, methodDescriptor.parameterType(i), method.getVariable(1).getArrayItem(), calledMethodDep.getVariable(i + 1), location);
                }
                calledMethodDep.getVariable(0).propagate(reflectedType);
                this.calledMethods.add(calledMethod.getReference());
                hasConstructors = true;
            }
            if (hasConstructors) {
                method.getResult().propagate(reflectedType);
            }
        });
    }

    private void handleClassNewInstance(DependencyAgent agent, MethodDependency method) {
        CallLocation location = new CallLocation(method.getReference());
        DependencyNode classValueNode = method.getVariable(0).getClassValueNode();
        classValueNode.addConsumer(reflectedType -> {
            if (!(reflectedType.getValueType() instanceof ValueType.Object)) {
                return;
            }
            String className = ((ValueType.Object)reflectedType.getValueType()).getClassName();
            ClassReader cls = agent.getClassSource().get(className);
            if (cls == null || cls.hasModifier(ElementModifier.ABSTRACT) || cls.hasModifier(ElementModifier.INTERFACE)) {
                return;
            }
            MethodReader constructor = cls.getMethod(new MethodDescriptor("<init>", Void.TYPE));
            if (constructor == null || constructor.getProgram() == null) {
                return;
            }
            MethodDependency constructorDep = agent.linkMethod(constructor.getReference()).addLocation(location);
            constructorDep.getVariable(0).propagate(reflectedType);
            constructorDep.use();
            method.getResult().propagate(reflectedType);
        });
    }

    private void handleInvoke(DependencyAgent agent, MethodDependency method) {
        CallLocation location = new CallLocation(method.getReference());
        DependencyNode classValueNode = agent.linkMethod(this.getMethods).addLocation(location).getVariable(0).getClassValueNode();
        this.callReached = true;
        classValueNode.addConsumer(reflectedType -> {
            if (!(reflectedType.getValueType() instanceof ValueType.Object)) {
                return;
            }
            String className = ((ValueType.Object)reflectedType.getValueType()).getClassName();
            Set<MethodDescriptor> accessibleMethods = this.getAccessibleMethods(agent, className);
            ClassReader cls = agent.getClassSource().get(className);
            for (MethodDescriptor methodDescriptor : accessibleMethods) {
                if (methodDescriptor.getName().equals("<init>")) continue;
                MethodReader calledMethod = cls.getMethod(methodDescriptor);
                if (calledMethod.hasModifier(ElementModifier.STATIC)) {
                    MethodDependency calledMethodDep = agent.linkMethod(calledMethod.getReference()).addLocation(location);
                    calledMethodDep.use();
                    for (int i = 0; i < calledMethod.parameterCount(); ++i) {
                        this.propagateSet(agent, methodDescriptor.parameterType(i), method.getVariable(2).getArrayItem(), calledMethodDep.getVariable(i + 1), location);
                    }
                    this.propagateSet(agent, ValueType.object(className), method.getVariable(1), calledMethodDep.getVariable(0), location);
                    this.propagateGet(agent, calledMethod.getResultType(), calledMethodDep.getResult(), method.getResult(), location);
                    this.linkClassIfNecessary(agent, calledMethod, location);
                    this.calledMethods.add(calledMethod.getReference());
                    continue;
                }
                boolean virtual = !calledMethod.hasModifier(ElementModifier.FINAL) && calledMethod.getLevel() != AccessLevel.PRIVATE;
                method.getVariable(1).addConsumer(new InstanceCallConsumer(agent, calledMethod.getReference(), method, location, virtual));
            }
        });
    }

    private void linkType(DependencyAgent agent, ValueType type) {
        this.typesInReflectableSignaturesNode.propagate(agent.getType(type));
        this.linkClass(agent, type);
    }

    private void linkClass(DependencyAgent agent, ValueType type) {
        if (type instanceof ValueType.Object) {
            agent.linkClass(((ValueType.Object)type).getClassName());
        } else if (type instanceof ValueType.Array) {
            this.linkClass(agent, ((ValueType.Array)type).getItemType());
        }
    }

    private void linkClassIfNecessary(DependencyAgent agent, MemberReader member, CallLocation location) {
        if (member.hasModifier(ElementModifier.STATIC)) {
            agent.linkClass(member.getOwnerName()).initClass(location);
        }
    }

    private Set<String> getAccessibleFields(DependencyAgent agent, String className) {
        return this.accessibleFieldCache.computeIfAbsent(className, key -> this.gatherAccessibleFields(agent, (String)key));
    }

    private Set<MethodDescriptor> getAccessibleMethods(DependencyAgent agent, String className) {
        return this.accessibleMethodCache.computeIfAbsent(className, key -> this.gatherAccessibleMethods(agent, (String)key));
    }

    private Set<String> gatherAccessibleFields(DependencyAgent agent, String className) {
        ReflectionContextImpl context = new ReflectionContextImpl(agent);
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        for (ReflectionSupplier supplier : this.reflectionSuppliers) {
            fields.addAll(supplier.getAccessibleFields(context, className));
        }
        return fields;
    }

    private Set<MethodDescriptor> gatherAccessibleMethods(DependencyAgent agent, String className) {
        ReflectionContextImpl context = new ReflectionContextImpl(agent);
        LinkedHashSet<MethodDescriptor> methods = new LinkedHashSet<MethodDescriptor>();
        for (ReflectionSupplier supplier : this.reflectionSuppliers) {
            methods.addAll(supplier.getAccessibleMethods(context, className));
        }
        return methods;
    }

    private void propagateGet(DependencyAgent agent, ValueType type, DependencyNode sourceNode, DependencyNode targetNode, CallLocation location) {
        if (type instanceof ValueType.Primitive) {
            MethodReference boxMethod;
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    boxMethod = new MethodReference(Boolean.class, "valueOf", Boolean.TYPE, Boolean.class);
                    break;
                }
                case BYTE: {
                    boxMethod = new MethodReference(Byte.class, "valueOf", Byte.TYPE, Byte.class);
                    break;
                }
                case SHORT: {
                    boxMethod = new MethodReference(Short.class, "valueOf", Short.TYPE, Short.class);
                    break;
                }
                case CHARACTER: {
                    boxMethod = new MethodReference(Character.class, "valueOf", Character.TYPE, Character.class);
                    break;
                }
                case INTEGER: {
                    boxMethod = new MethodReference(Integer.class, "valueOf", Integer.TYPE, Integer.class);
                    break;
                }
                case LONG: {
                    boxMethod = new MethodReference(Long.class, "valueOf", Long.TYPE, Long.class);
                    break;
                }
                case FLOAT: {
                    boxMethod = new MethodReference(Float.class, "valueOf", Float.TYPE, Float.class);
                    break;
                }
                case DOUBLE: {
                    boxMethod = new MethodReference(Double.class, "valueOf", Double.TYPE, Double.class);
                    break;
                }
                default: {
                    throw new AssertionError((Object)type.toString());
                }
            }
            MethodDependency boxMethodDep = agent.linkMethod(boxMethod).addLocation(location);
            boxMethodDep.use();
            boxMethodDep.getResult().connect(targetNode);
        } else if (type instanceof ValueType.Array || type instanceof ValueType.Object) {
            sourceNode.connect(targetNode);
        }
    }

    private void propagateSet(DependencyAgent agent, ValueType type, DependencyNode sourceNode, DependencyNode targetNode, CallLocation location) {
        if (type instanceof ValueType.Primitive) {
            MethodReference unboxMethod;
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    unboxMethod = new MethodReference(Boolean.class, "booleanValue", Boolean.TYPE);
                    break;
                }
                case BYTE: {
                    unboxMethod = new MethodReference(Byte.class, "byteValue", Byte.TYPE);
                    break;
                }
                case SHORT: {
                    unboxMethod = new MethodReference(Short.class, "shortValue", Short.TYPE);
                    break;
                }
                case CHARACTER: {
                    unboxMethod = new MethodReference(Character.class, "charValue", Character.TYPE);
                    break;
                }
                case INTEGER: {
                    unboxMethod = new MethodReference(Integer.class, "intValue", Integer.TYPE);
                    break;
                }
                case LONG: {
                    unboxMethod = new MethodReference(Long.class, "longValue", Long.TYPE);
                    break;
                }
                case FLOAT: {
                    unboxMethod = new MethodReference(Float.class, "floatValue", Float.TYPE);
                    break;
                }
                case DOUBLE: {
                    unboxMethod = new MethodReference(Double.class, "doubleValue", Double.TYPE);
                    break;
                }
                default: {
                    throw new AssertionError((Object)type.toString());
                }
            }
            MethodDependency unboxMethodDep = agent.linkMethod(unboxMethod).addLocation(location);
            unboxMethodDep.propagateClass(0, unboxMethod.getClassName());
            unboxMethodDep.use();
            sourceNode.connect(unboxMethodDep.getResult());
        } else if (type instanceof ValueType.Array || type instanceof ValueType.Object) {
            sourceNode.connect(targetNode);
        }
    }

    private static class ReflectionContextImpl
    implements ReflectionContext {
        private DependencyAgent agent;

        public ReflectionContextImpl(DependencyAgent agent) {
            this.agent = agent;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.agent.getClassLoader();
        }

        @Override
        public ClassReaderSource getClassSource() {
            return this.agent.getClassSource();
        }
    }

    private class InstanceCallConsumer
    implements DependencyConsumer {
        private final DependencyAgent agent;
        private final MethodReference methodRef;
        private final MethodDependency invokeDep;
        private final CallLocation location;
        private final boolean virtual;
        private Set<DependencyType> knownTypes = new HashSet<DependencyType>();
        private Set<MethodReference> knownMethods = new HashSet<MethodReference>();

        InstanceCallConsumer(DependencyAgent agent, MethodReference methodRef, MethodDependency invokeDep, CallLocation location, boolean virtual) {
            this.agent = agent;
            this.methodRef = methodRef;
            this.invokeDep = invokeDep;
            this.location = location;
            this.virtual = virtual;
        }

        @Override
        public void consume(DependencyType type) {
            String className;
            if (!this.knownTypes.add(type)) {
                return;
            }
            ValueType valueType = type.getValueType();
            if (valueType instanceof ValueType.Object) {
                className = ((ValueType.Object)valueType).getClassName();
            } else if (valueType instanceof ValueType.Array) {
                className = "java.lang.Object";
            } else {
                return;
            }
            if (!this.agent.getClassHierarchy().isSuperType(this.methodRef.getClassName(), className, false)) {
                return;
            }
            MethodDependency methodDep = this.virtual ? this.agent.linkMethod(className, this.methodRef.getDescriptor()) : this.agent.linkMethod(this.methodRef);
            methodDep.addLocation(this.location);
            if (!this.knownMethods.add(methodDep.getReference())) {
                return;
            }
            if (!methodDep.isMissing()) {
                ReflectionDependencyListener.this.virtualCallSites.add(this.methodRef);
                ReflectionDependencyListener.this.calledMethods.add(this.methodRef);
                methodDep.use();
                ReflectionDependencyListener.this.virtualMethods.add(methodDep.getReference());
                this.invokeDep.getVariable(1).connect(methodDep.getVariable(0));
                for (int i = 0; i < this.methodRef.parameterCount(); ++i) {
                    ReflectionDependencyListener.this.propagateSet(this.agent, this.methodRef.parameterType(i), this.invokeDep.getVariable(2).getArrayItem(), methodDep.getVariable(i + 1), this.location);
                }
                if (methodDep.getResult() != null) {
                    ReflectionDependencyListener.this.propagateGet(this.agent, this.methodRef.getReturnType(), methodDep.getResult(), this.invokeDep.getResult(), this.location);
                }
            }
        }
    }

    private class InstanceSetConsumer
    implements DependencyConsumer {
        private final DependencyAgent agent;
        private final FieldReference fieldRef;
        private final MethodDependency readDep;
        private final CallLocation location;
        private Set<DependencyType> knownTypes = new HashSet<DependencyType>();
        private boolean done;

        InstanceSetConsumer(DependencyAgent agent, FieldReference fieldRef, MethodDependency readDep, CallLocation location) {
            this.agent = agent;
            this.fieldRef = fieldRef;
            this.readDep = readDep;
            this.location = location;
        }

        @Override
        public void consume(DependencyType type) {
            String className;
            if (this.done || !this.knownTypes.add(type)) {
                return;
            }
            ValueType valueType = type.getValueType();
            if (valueType instanceof ValueType.Object) {
                className = ((ValueType.Object)valueType).getClassName();
            } else if (valueType instanceof ValueType.Array) {
                className = "java.lang.Object";
            } else {
                return;
            }
            if (!this.agent.getClassHierarchy().isSuperType(this.fieldRef.getClassName(), className, false)) {
                return;
            }
            FieldDependency fieldDep = this.agent.linkField(this.fieldRef);
            this.done = true;
            if (!fieldDep.isMissing()) {
                ReflectionDependencyListener.this.writtenFields.add(this.fieldRef);
                ReflectionDependencyListener.this.propagateSet(this.agent, fieldDep.getField().getType(), this.readDep.getVariable(2), fieldDep.getValue(), this.location);
            }
        }
    }

    private class InstanceGetConsumer
    implements DependencyConsumer {
        private final DependencyAgent agent;
        private final FieldReference fieldRef;
        private final MethodDependency readDep;
        private final CallLocation location;
        private Set<DependencyType> knownTypes = new HashSet<DependencyType>();
        private boolean done;

        InstanceGetConsumer(DependencyAgent agent, FieldReference fieldRef, MethodDependency readDep, CallLocation location) {
            this.agent = agent;
            this.fieldRef = fieldRef;
            this.readDep = readDep;
            this.location = location;
        }

        @Override
        public void consume(DependencyType type) {
            String className;
            if (this.done || !this.knownTypes.add(type)) {
                return;
            }
            ValueType valueType = type.getValueType();
            if (valueType instanceof ValueType.Object) {
                className = ((ValueType.Object)valueType).getClassName();
            } else if (valueType instanceof ValueType.Array) {
                className = "java.lang.Object";
            } else {
                return;
            }
            if (!this.agent.getClassHierarchy().isSuperType(this.fieldRef.getClassName(), className, false)) {
                return;
            }
            FieldDependency fieldDep = this.agent.linkField(this.fieldRef);
            this.done = true;
            if (!fieldDep.isMissing()) {
                ReflectionDependencyListener.this.readFields.add(this.fieldRef);
                ReflectionDependencyListener.this.propagateGet(this.agent, fieldDep.getField().getType(), fieldDep.getValue(), this.readDep.getResult(), this.location);
            }
        }
    }
}

