/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.nio.Buffer;
import org.teavm.classlib.impl.nio.Buffers;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;

public class BuffersTransformer
implements ClassHolderTransformer {
    private static final String NATIVE_BUFFER = "java.nio.NativeBuffer";

    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        if (cls.getName().equals(Buffers.class.getName())) {
            MethodHolder method = cls.getMethod(new MethodDescriptor("releaseNative", Buffer.class, Void.TYPE));
            method.getModifiers().remove((Object)ElementModifier.NATIVE);
            ProgramEmitter pe = ProgramEmitter.create(method, context.getHierarchy());
            ValueEmitter bufferVar = pe.var(1, Buffer.class);
            pe.when(bufferVar.instanceOf(ValueType.object(NATIVE_BUFFER)).isTrue()).thenDo(() -> bufferVar.cast(ValueType.object(NATIVE_BUFFER)).invokeVirtual("release", new ValueEmitter[0]));
            pe.exit();
        }
    }
}

