/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.runtime;

import java.nio.charset.StandardCharsets;
import org.teavm.backend.wasm.runtime.WasiBuffer;
import org.teavm.backend.wasm.runtime.math.WasmPow;
import org.teavm.backend.wasm.wasi.IOVec;
import org.teavm.backend.wasm.wasi.IntResult;
import org.teavm.backend.wasm.wasi.LongResult;
import org.teavm.backend.wasm.wasi.SizeResult;
import org.teavm.backend.wasm.wasi.Wasi;
import org.teavm.interop.Address;
import org.teavm.interop.Structure;
import org.teavm.interop.Unmanaged;

public class WasiSupport {
    private static long nextRandom;
    private static boolean randomInitialized;

    private WasiSupport() {
    }

    @Unmanaged
    public static void putCharsStdout(Address address, int count) {
        WasiSupport.putChars(1, address, count);
    }

    @Unmanaged
    public static void putCharsStderr(Address address, int count) {
        WasiSupport.putChars(2, address, count);
    }

    @Unmanaged
    public static void putChars(int fd, Address address, int count) {
        Address argsAddress = WasiBuffer.getBuffer();
        IOVec ioVec = (IOVec)argsAddress.toStructure();
        SizeResult result = (SizeResult)Address.align(argsAddress.add(Structure.sizeOf(IOVec.class)), 16).toStructure();
        ioVec.buffer = address;
        ioVec.bufferLength = count;
        Wasi.fdWrite(fd, ioVec, 1, result);
    }

    @Unmanaged
    public static long currentTimeMillis() {
        LongResult result = (LongResult)WasiBuffer.getBuffer().toStructure();
        Wasi.clockTimeGet(0, 10L, result);
        return result.value / 1000000L;
    }

    @Unmanaged
    public static void printString(String s) {
        int charsInChunk = 128;
        int offsetInBuffer = 128;
        Address buffer = WasiBuffer.getBuffer().add(offsetInBuffer);
        for (int i = 0; i < s.length(); i += charsInChunk) {
            int end = Math.min(s.length(), i + charsInChunk);
            int count = end - i;
            for (int j = 0; j < count; ++j) {
                buffer.add(j).putByte((byte)s.charAt(i + j));
            }
            WasiSupport.putCharsStderr(buffer, count);
        }
    }

    @Unmanaged
    public static void printInt(int i) {
        int count = 0;
        boolean negative = i < 0;
        i = Math.abs(i);
        Address buffer = WasiBuffer.getBuffer().add(WasiBuffer.getBufferSize());
        do {
            ++count;
            buffer = buffer.add(-1);
            buffer.putByte((byte)(i % 10 + 48));
        } while ((i /= 10) > 0);
        if (negative) {
            ++count;
            buffer = buffer.add(-1);
            buffer.putByte((byte)45);
        }
        WasiSupport.putCharsStderr(buffer, count);
    }

    @Unmanaged
    public static void printOutOfMemory() {
        WasiSupport.printString("Out of memory");
    }

    public static String[] getArgs() {
        IntResult bufferSizeReceiver;
        Address buffer = WasiBuffer.getBuffer();
        IntResult sizesReceiver = (IntResult)buffer.toStructure();
        short errno = Wasi.argsSizesGet(sizesReceiver, bufferSizeReceiver = (IntResult)Address.align(buffer.add(Structure.sizeOf(IntResult.class)), 16).toStructure());
        if (errno != 0) {
            throw new RuntimeException("Could not get command line arguments");
        }
        int argvSize = sizesReceiver.value;
        int argvBufSize = bufferSizeReceiver.value;
        int[] argvOffsets = new int[argvSize];
        byte[] argvBuffer = new byte[argvBufSize];
        errno = Wasi.argsGet(Address.ofData(argvOffsets), Address.ofData(argvBuffer));
        if (errno != 0) {
            throw new RuntimeException("Could not get command line arguments");
        }
        String[] args = new String[argvSize - 1];
        for (int i = 1; i < argvSize; ++i) {
            int offset = argvOffsets[i] - Address.ofData(argvBuffer).toInt();
            int length = (i == argvSize - 1 ? argvBufSize - offset : argvOffsets[i + 1] - argvOffsets[i]) - 1;
            args[i - 1] = new String(argvBuffer, offset, length, StandardCharsets.UTF_8);
        }
        return args;
    }

    public static double random() {
        return (double)(((long)WasiSupport.nextRandom(26) << 27) + (long)WasiSupport.nextRandom(27)) / 9.007199254740992E15;
    }

    private static int nextRandom(int bits) {
        if (!randomInitialized) {
            randomInitialized = true;
            short errno = Wasi.randomGet(WasiBuffer.getBuffer(), 8);
            if (errno != 0) {
                throw new RuntimeException("random_get: " + errno);
            }
            nextRandom = WasiBuffer.getBuffer().getLong();
        }
        nextRandom = nextRandom * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(nextRandom >>> 48 - bits);
    }

    public static double pow(double x, double y) {
        return WasmPow.pow(x, y);
    }
}

