/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmNumType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayCopy;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmCastBranch;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmCopy;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmExternConversion;
import org.teavm.backend.wasm.model.expression.WasmFill;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatType;
import org.teavm.backend.wasm.model.expression.WasmFloatUnary;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt31Get;
import org.teavm.backend.wasm.model.expression.WasmInt31Reference;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIsNull;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmMemoryGrow;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmPop;
import org.teavm.backend.wasm.model.expression.WasmPush;
import org.teavm.backend.wasm.model.expression.WasmReferencesEqual;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmTest;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.model.expression.WasmTry;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.backend.wasm.render.CBlock;
import org.teavm.backend.wasm.render.CExpression;
import org.teavm.backend.wasm.render.CLine;
import org.teavm.backend.wasm.render.CSingleLine;
import org.teavm.model.TextLocation;

class WasmCRenderingVisitor
implements WasmExpressionVisitor {
    private CExpression value;
    private Map<WasmBlock, BlockInfo> blockInfoMap = new HashMap<WasmBlock, BlockInfo>();
    private WasmType requiredType;
    private int temporaryIndex;
    private int blockIndex;
    private WasmType functionType;
    private WasmModule module;
    private String[] localVariableNames;
    private Set<String> usedVariableNames = new HashSet<String>();
    private boolean memoryAccessChecked;

    WasmCRenderingVisitor(WasmType functionType, int variableCount, WasmModule module) {
        this.localVariableNames = new String[variableCount];
        this.functionType = functionType;
        this.module = module;
    }

    public boolean isMemoryAccessChecked() {
        return this.memoryAccessChecked;
    }

    public void setMemoryAccessChecked(boolean memoryAccessChecked) {
        this.memoryAccessChecked = memoryAccessChecked;
    }

    public CExpression getValue() {
        return this.value;
    }

    void setRequiredType(WasmType requiredType) {
        this.requiredType = requiredType;
    }

    @Override
    public void visit(WasmBlock expression) {
        BlockInfo info = new BlockInfo();
        info.type = this.requiredType;
        info.index = this.blockInfoMap.size();
        this.blockInfoMap.put(expression, info);
        List<WasmExpression> body = expression.getBody();
        CExpression result = new CExpression();
        if (!body.isEmpty()) {
            for (int i = 0; i < body.size() - 1; ++i) {
                this.requiredType = null;
                body.get(i).acceptVisitor(this);
                result.getLines().addAll(this.value.getLines());
            }
            this.requiredType = info.type;
            WasmExpression last = body.get(body.size() - 1);
            last.acceptVisitor(this);
            result.getLines().addAll(this.value.getLines());
            if (info.type != null) {
                if (info.temporaryVariable != null) {
                    result.getLines().add(new CSingleLine(info.temporaryVariable + " = " + this.value.getText() + ";"));
                    result.setText(info.temporaryVariable);
                } else {
                    result.setText(this.value.getText());
                }
            }
            if (info.temporaryVariable != null) {
                result.getLines().add(0, this.declareVariable(info.temporaryVariable, info.type));
            }
            if (expression.isLoop()) {
                ArrayList<CLine> lines = new ArrayList<CLine>();
                lines.add(new CSingleLine(this.getLabel(info) + ": do {"));
                lines.add(new CBlock(result.getLines()));
                lines.add(new CSingleLine("} while(0);"));
                result.getLines().clear();
                result.getLines().addAll(lines);
            } else if (info.label != null) {
                result.getLines().add(new CSingleLine(info.label + ": ;"));
            }
        }
        this.blockInfoMap.remove(expression);
        this.value = result;
    }

    @Override
    public void visit(WasmBranch expression) {
        CExpression result = new CExpression();
        this.requiredType = WasmType.INT32;
        expression.getCondition().acceptVisitor(this);
        result.getLines().addAll(this.value.getLines());
        result.addLine("if (" + this.value.getText() + ") {", expression.getLocation());
        CBlock breakBlock = new CBlock(this.generateBreak(expression.getResult(), expression.getTarget(), expression.getLocation()));
        result.getLines().add(breakBlock);
        result.getLines().add(new CSingleLine("}"));
        this.value = result;
    }

    @Override
    public void visit(WasmNullBranch expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmCastBranch expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmBreak expression) {
        CExpression result = new CExpression();
        result.getLines().addAll(this.generateBreak(expression.getResult(), expression.getTarget(), expression.getLocation()));
        this.value = result;
    }

    private List<CLine> generateBreak(WasmExpression result, WasmBlock target, TextLocation location) {
        ArrayList<CLine> lines = new ArrayList<CLine>();
        BlockInfo targetInfo = this.blockInfoMap.get(target);
        if (result != null) {
            if (targetInfo.temporaryVariable == null) {
                targetInfo.temporaryVariable = "tmp_" + this.temporaryIndex++;
            }
            this.requiredType = targetInfo.type;
            result.acceptVisitor(this);
            lines.addAll(this.value.getLines());
            lines.add(new CSingleLine(targetInfo.temporaryVariable + " = " + this.value.getText() + ";", result.getLocation()));
        }
        lines.add(new CSingleLine("goto " + this.getLabel(targetInfo) + ";", location));
        return lines;
    }

    private String getLabel(BlockInfo blockInfo) {
        if (blockInfo.label == null) {
            blockInfo.label = "block_" + this.blockIndex++;
        }
        return blockInfo.label;
    }

    @Override
    public void visit(WasmSwitch expression) {
        CExpression result = new CExpression();
        this.requiredType = WasmType.INT32;
        expression.getSelector().acceptVisitor(this);
        result.getLines().addAll(this.value.getLines());
        result.addLine("switch (" + this.value.getText() + ") {", expression.getLocation());
        CBlock switchBlock = new CBlock();
        result.getLines().add(switchBlock);
        for (int i = 0; i < expression.getTargets().size(); ++i) {
            BlockInfo targetInfo = this.blockInfoMap.get(expression.getTargets().get(i));
            switchBlock.getLines().add(new CSingleLine("case " + i + ": goto " + this.getLabel(targetInfo) + ";"));
        }
        BlockInfo defaultTargetInfo = this.blockInfoMap.get(expression.getDefaultTarget());
        switchBlock.getLines().add(new CSingleLine("default: goto " + this.getLabel(defaultTargetInfo) + ";"));
        result.getLines().add(new CSingleLine("}"));
        this.value = result;
    }

    @Override
    public void visit(WasmConditional expression) {
        WasmType type = this.requiredType;
        this.requiredType = WasmType.INT32;
        expression.getCondition().acceptVisitor(this);
        CExpression condition = this.value;
        this.requiredType = type;
        expression.getThenBlock().acceptVisitor(this);
        CExpression thenExpression = this.value;
        this.requiredType = type;
        expression.getElseBlock().acceptVisitor(this);
        CExpression elseExpression = this.value;
        CExpression result = new CExpression();
        result.getLines().addAll(condition.getLines());
        if (type != null && thenExpression.getLines().isEmpty() && elseExpression.getLines().isEmpty() && elseExpression.getText() != null) {
            result.setText("(" + condition.getText() + " ? " + thenExpression.getText() + " : " + elseExpression.getText() + ")");
        } else {
            String temporary = null;
            if (type != null) {
                temporary = "tmp_" + this.temporaryIndex++;
                result.setText(temporary);
                result.getLines().add(this.declareVariable(temporary, type));
            }
            result.getLines().add(new CSingleLine("if (" + condition.getText() + ") {"));
            CBlock thenBlock = new CBlock();
            thenBlock.getLines().addAll(thenExpression.getLines());
            if (temporary != null) {
                thenBlock.getLines().add(new CSingleLine(temporary + " = " + thenExpression.getText() + ";"));
            }
            result.getLines().add(thenBlock);
            if (elseExpression.getText() != null || !elseExpression.getLines().isEmpty()) {
                result.getLines().add(new CSingleLine("} else {"));
                CBlock elseBlock = new CBlock();
                elseBlock.getLines().addAll(elseExpression.getLines());
                if (temporary != null) {
                    elseBlock.getLines().add(new CSingleLine(temporary + " = " + elseExpression.getText() + ";"));
                }
                result.getLines().add(elseBlock);
            }
            result.getLines().add(new CSingleLine("}"));
        }
        this.value = result;
    }

    @Override
    public void visit(WasmReturn expression) {
        CExpression result = new CExpression();
        if (expression.getValue() != null) {
            this.requiredType = this.functionType;
            expression.getValue().acceptVisitor(this);
            result.getLines().addAll(this.value.getLines());
            result.addLine("return " + this.value.getText() + ";", expression.getLocation());
        } else {
            result.addLine("return;", expression.getLocation());
        }
        this.value = result;
    }

    @Override
    public void visit(WasmUnreachable expression) {
        CExpression result = new CExpression();
        result.addLine("assert(0);", expression.getLocation());
        this.value = result;
    }

    @Override
    public void visit(WasmInt32Constant expression) {
        this.value = CExpression.relocatable("INT32_C(" + String.valueOf(expression.getValue()) + ")");
    }

    @Override
    public void visit(WasmInt64Constant expression) {
        this.value = CExpression.relocatable("INT64_C(" + String.valueOf(expression.getValue()) + ")");
    }

    @Override
    public void visit(WasmFloat32Constant expression) {
        this.value = Float.isInfinite(expression.getValue()) ? CExpression.relocatable(expression.getValue() < 0.0f ? "-INFINITY" : "INFINITY") : (Float.isNaN(expression.getValue()) ? CExpression.relocatable("NAN") : CExpression.relocatable(Float.toHexString(expression.getValue()) + "F"));
    }

    @Override
    public void visit(WasmFloat64Constant expression) {
        this.value = Double.isInfinite(expression.getValue()) ? CExpression.relocatable(expression.getValue() < 0.0 ? "-INFINITY" : "INFINITY") : (Double.isNaN(expression.getValue()) ? CExpression.relocatable("NAN") : CExpression.relocatable(Double.toHexString(expression.getValue())));
    }

    @Override
    public void visit(WasmNullConstant expression) {
        this.value = CExpression.relocatable("/* can't produce ref.null */");
    }

    @Override
    public void visit(WasmIsNull expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmGetLocal expression) {
        this.value = new CExpression(this.getVariableName(expression.getLocal()));
    }

    @Override
    public void visit(WasmSetLocal expression) {
        CExpression result = new CExpression();
        this.requiredType = expression.getLocal().getType();
        expression.getValue().acceptVisitor(this);
        result.getLines().addAll(this.value.getLines());
        result.addLine(this.getVariableName(expression.getLocal()) + " = " + this.value.getText() + ";", expression.getLocation());
        this.value = result;
    }

    @Override
    public void visit(WasmGetGlobal expression) {
        this.value = new CExpression(this.getVariableName(expression.getGlobal()));
    }

    @Override
    public void visit(WasmSetGlobal expression) {
        CExpression result = new CExpression();
        this.requiredType = expression.getGlobal().getType();
        expression.getValue().acceptVisitor(this);
        result.getLines().addAll(this.value.getLines());
        result.addLine(this.getVariableName(expression.getGlobal()) + " = " + this.value.getText() + ";", expression.getLocation());
        this.value = result;
    }

    @Override
    public void visit(WasmIntBinary expression) {
        WasmType type = this.requiredType;
        WasmType opType = WasmCRenderingVisitor.asWasmType(expression.getType());
        CExpression result = new CExpression();
        this.requiredType = opType;
        expression.getFirst().acceptVisitor(this);
        CExpression first = this.value;
        this.requiredType = opType;
        expression.getSecond().acceptVisitor(this);
        CExpression second = this.value;
        if (type == null) {
            result.getLines().addAll(first.getLines());
            result.getLines().addAll(second.getLines());
        } else {
            result.getLines().addAll(first.getLines());
            if (!second.getLines().isEmpty()) {
                first = this.cacheIfNeeded(opType, first, result);
                result.getLines().addAll(second.getLines());
            }
            String firstOp = first.getText();
            String secondOp = second.getText();
            String typeText = WasmCRenderingVisitor.mapType(opType);
            String unsignedType = "u" + typeText;
            String firstOpUnsigned = "(" + unsignedType + ") " + firstOp;
            String secondOpUnsigned = "(" + unsignedType + ") " + secondOp;
            switch (expression.getOperation()) {
                case ADD: {
                    result.setText("(" + firstOp + " + " + secondOp + ")");
                    break;
                }
                case SUB: {
                    result.setText("(" + firstOp + " - " + secondOp + ")");
                    break;
                }
                case MUL: {
                    result.setText("(" + firstOp + " * " + secondOp + ")");
                    break;
                }
                case DIV_SIGNED: {
                    result.setText("(" + firstOp + " / " + secondOp + ")");
                    break;
                }
                case DIV_UNSIGNED: {
                    result.setText("(" + typeText + ") (" + firstOpUnsigned + " / " + secondOpUnsigned + ")");
                    break;
                }
                case REM_SIGNED: {
                    result.setText("(" + firstOp + " % " + secondOp + ")");
                    break;
                }
                case REM_UNSIGNED: {
                    result.setText("(" + typeText + ") (" + firstOpUnsigned + " % " + secondOpUnsigned + ")");
                    break;
                }
                case AND: {
                    result.setText("(" + firstOp + " & " + secondOp + ")");
                    break;
                }
                case OR: {
                    result.setText("(" + firstOp + " | " + secondOp + ")");
                    break;
                }
                case XOR: {
                    result.setText("(" + firstOp + " ^ " + secondOp + ")");
                    break;
                }
                case SHL: {
                    result.setText("(" + firstOp + " << " + secondOp + ")");
                    break;
                }
                case SHR_SIGNED: {
                    result.setText("(" + firstOp + " >> " + secondOp + ")");
                    break;
                }
                case SHR_UNSIGNED: {
                    result.setText("(" + typeText + ") (" + firstOpUnsigned + " >> " + secondOp + ")");
                    break;
                }
                case EQ: {
                    result.setText("(" + firstOp + " == " + secondOp + ")");
                    break;
                }
                case NE: {
                    result.setText("(" + firstOp + " != " + secondOp + ")");
                    break;
                }
                case GT_SIGNED: {
                    result.setText("(" + firstOp + " > " + secondOp + ")");
                    break;
                }
                case GT_UNSIGNED: {
                    result.setText("(" + firstOpUnsigned + " > " + secondOpUnsigned + ")");
                    break;
                }
                case GE_SIGNED: {
                    result.setText("(" + firstOp + " >= " + secondOp + ")");
                    break;
                }
                case GE_UNSIGNED: {
                    result.setText("(" + typeText + ") (" + firstOpUnsigned + " >= " + secondOpUnsigned + ")");
                    break;
                }
                case LT_SIGNED: {
                    result.setText("(" + firstOp + " < " + secondOp + ")");
                    break;
                }
                case LT_UNSIGNED: {
                    result.setText("(" + typeText + ") (" + firstOpUnsigned + " < " + secondOpUnsigned + ")");
                    break;
                }
                case LE_SIGNED: {
                    result.setText("(" + firstOp + " <= " + secondOp + ")");
                    break;
                }
                case LE_UNSIGNED: {
                    result.setText("(" + typeText + ") (" + firstOpUnsigned + " <= " + secondOpUnsigned + ")");
                    break;
                }
                case ROTL: {
                    result.setText("rotl(" + firstOp + ", " + secondOp + ")");
                    break;
                }
                case ROTR: {
                    result.setText("rotr(" + firstOp + ", " + secondOp + ")");
                }
            }
            result.setRelocatable(first.isRelocatable() && second.isRelocatable());
        }
        this.value = result;
    }

    @Override
    public void visit(WasmFloatBinary expression) {
        WasmType type = this.requiredType;
        WasmType opType = WasmCRenderingVisitor.asWasmType(expression.getType());
        CExpression result = new CExpression();
        this.requiredType = opType;
        expression.getFirst().acceptVisitor(this);
        CExpression first = this.value;
        this.requiredType = opType;
        expression.getSecond().acceptVisitor(this);
        CExpression second = this.value;
        if (type == null) {
            result.getLines().addAll(first.getLines());
            result.getLines().addAll(second.getLines());
        } else {
            result.getLines().addAll(first.getLines());
            if (!second.getLines().isEmpty()) {
                first = this.cacheIfNeeded(opType, first, result);
                result.getLines().addAll(second.getLines());
            }
            String firstOp = first.getText();
            String secondOp = second.getText();
            switch (expression.getOperation()) {
                case ADD: {
                    result.setText("(" + firstOp + " + " + secondOp + ")");
                    break;
                }
                case SUB: {
                    result.setText("(" + firstOp + " - " + secondOp + ")");
                    break;
                }
                case MUL: {
                    result.setText("(" + firstOp + " * " + secondOp + ")");
                    break;
                }
                case DIV: {
                    result.setText("(" + firstOp + " / " + secondOp + ")");
                    break;
                }
                case EQ: {
                    result.setText("(" + firstOp + " == " + secondOp + ")");
                    break;
                }
                case NE: {
                    result.setText("(" + firstOp + " != " + secondOp + ")");
                    break;
                }
                case GT: {
                    result.setText("(" + firstOp + " > " + secondOp + ")");
                    break;
                }
                case GE: {
                    result.setText("(" + firstOp + " >= " + secondOp + ")");
                    break;
                }
                case LT: {
                    result.setText("(" + firstOp + " < " + secondOp + ")");
                    break;
                }
                case LE: {
                    result.setText("(" + firstOp + " <= " + secondOp + ")");
                    break;
                }
                case MIN: {
                    String function = expression.getType() == WasmFloatType.FLOAT32 ? "fminf" : "fmin";
                    result.setText(function + "(" + firstOp + ", " + secondOp + ")");
                    break;
                }
                case MAX: {
                    String function = expression.getType() == WasmFloatType.FLOAT32 ? "fmaxf" : "fmax";
                    result.setText(function + "(" + firstOp + ", " + secondOp + ")");
                    break;
                }
            }
            result.setRelocatable(first.isRelocatable() && second.isRelocatable());
        }
        this.value = result;
    }

    private CExpression cacheIfNeeded(WasmType type, CExpression expression, CExpression target) {
        if (expression.isRelocatable()) {
            return expression;
        }
        String var = "tmp_" + this.temporaryIndex++;
        target.getLines().add(new CSingleLine(WasmCRenderingVisitor.mapType(type) + " " + var + " = " + expression.getText() + ";"));
        return CExpression.relocatable(var);
    }

    @Override
    public void visit(WasmIntUnary expression) {
        WasmType type = this.requiredType;
        WasmType opType = WasmCRenderingVisitor.asWasmType(expression.getType());
        CExpression result = new CExpression();
        this.requiredType = opType;
        expression.getOperand().acceptVisitor(this);
        CExpression operand = this.value;
        result.getLines().addAll(operand.getLines());
        if (type != null) {
            switch (expression.getOperation()) {
                case POPCNT: {
                    result.setText("popcnt(" + operand.getText() + ")");
                    break;
                }
                case CLZ: {
                    result.setText("clz(" + operand.getText() + ")");
                    break;
                }
                case CTZ: {
                    result.setText("ctz(" + operand.getText() + ")");
                }
            }
            result.setRelocatable(operand.isRelocatable());
        }
        this.value = result;
    }

    @Override
    public void visit(WasmFloatUnary expression) {
        WasmType type = this.requiredType;
        WasmType opType = WasmCRenderingVisitor.asWasmType(expression.getType());
        CExpression result = new CExpression();
        this.requiredType = opType;
        expression.getOperand().acceptVisitor(this);
        CExpression operand = this.value;
        result.getLines().addAll(operand.getLines());
        if (type != null) {
            switch (expression.getOperation()) {
                case ABS: {
                    String functionName = expression.getType() == WasmFloatType.FLOAT32 ? "fabsf" : "fabs";
                    result.setText(functionName + "(" + operand.getText() + ")");
                    break;
                }
                case CEIL: {
                    String functionName = expression.getType() == WasmFloatType.FLOAT32 ? "ceilf" : "ceil";
                    result.setText(functionName + "(" + operand.getText() + ")");
                    break;
                }
                case FLOOR: {
                    String functionName = expression.getType() == WasmFloatType.FLOAT32 ? "floorf" : "floor";
                    result.setText(functionName + "(" + operand.getText() + ")");
                    break;
                }
                case TRUNC: {
                    String functionName = expression.getType() == WasmFloatType.FLOAT32 ? "truncf" : "trunc";
                    result.setText(functionName + "(" + operand.getText() + ")");
                    break;
                }
                case NEAREST: {
                    String functionName = expression.getType() == WasmFloatType.FLOAT32 ? "roundf" : "round";
                    result.setText(functionName + "(" + operand.getText() + ")");
                    break;
                }
                case SQRT: {
                    String functionName = expression.getType() == WasmFloatType.FLOAT32 ? "sqrtf" : "sqrt";
                    result.setText(functionName + "(" + operand.getText() + ")");
                    break;
                }
                case NEG: {
                    result.setText("(-" + operand.getText() + ")");
                    break;
                }
                case COPYSIGN: {
                    String functionName = expression.getType() == WasmFloatType.FLOAT32 ? "copysignf" : "copysign";
                    result.setText(functionName + "(" + operand.getText() + ")");
                    break;
                }
            }
            result.setRelocatable(operand.isRelocatable());
        }
        this.value = result;
    }

    @Override
    public void visit(WasmConversion expression) {
        CExpression result = new CExpression();
        WasmType type = this.requiredType;
        expression.getOperand().acceptVisitor(this);
        CExpression operand = this.value;
        result.getLines().addAll(operand.getLines());
        if (type != null && expression.getSourceType() != expression.getTargetType()) {
            switch (expression.getTargetType()) {
                case INT32: {
                    if (expression.getSourceType() == WasmNumType.FLOAT32 && expression.isReinterpret()) {
                        result.setText("reinterpret_float32(" + operand.getText() + ")");
                        break;
                    }
                    if (expression.isSigned()) {
                        result.setText("(int32_t) " + operand.getText());
                        break;
                    }
                    result.setText("(uint32_t) " + operand.getText());
                    break;
                }
                case INT64: {
                    if (expression.getSourceType() == WasmNumType.FLOAT64 && expression.isReinterpret()) {
                        result.setText("reinterpret_float64(" + operand.getText() + ")");
                        break;
                    }
                    if (expression.isSigned()) {
                        result.setText("(int64_t) " + operand.getText());
                        break;
                    }
                    result.setText("(uint64_t) " + operand.getText());
                    break;
                }
                case FLOAT32: {
                    if (expression.getSourceType() == WasmNumType.INT32 && expression.isReinterpret()) {
                        result.setText("reinterpret_int32(" + operand.getText() + ")");
                        break;
                    }
                    if (expression.getSourceType() == WasmNumType.FLOAT64) {
                        result.setText("(float) " + operand.getText());
                        break;
                    }
                    if (expression.isSigned()) {
                        result.setText("(float) (int64_t) " + operand.getText());
                        break;
                    }
                    result.setText("(float) (uint64_t) " + operand.getText());
                    break;
                }
                case FLOAT64: {
                    if (expression.getSourceType() == WasmNumType.INT64 && expression.isReinterpret()) {
                        result.setText("reinterpret_int64(" + operand.getText() + ")");
                        break;
                    }
                    if (expression.getSourceType() == WasmNumType.FLOAT32) {
                        result.setText("(double) " + operand.getText());
                        break;
                    }
                    if (expression.isSigned()) {
                        result.setText("(double) (int64_t) " + operand.getText());
                        break;
                    }
                    result.setText("(double) (uint64_t) " + operand.getText());
                }
            }
        }
        this.value = result;
    }

    @Override
    public void visit(WasmCall expression) {
        WasmFunction function = expression.getFunction();
        CExpression result = new CExpression();
        WasmType type = this.requiredType;
        StringBuilder sb = new StringBuilder();
        sb.append((String)(function.getImportModule() != null && !function.getImportModule().isEmpty() ? function.getImportModule() + "_" + function.getImportName() : function.getImportName()));
        sb.append('(');
        this.translateArguments(expression.getArguments(), function.getType().getParameterTypes(), result, sb);
        sb.append(')');
        result.setText(sb.toString());
        if (type == null) {
            result.addLine(result.getText() + ";", expression.getLocation());
            result.setText(null);
        }
        this.value = result;
    }

    @Override
    public void visit(WasmIndirectCall expression) {
        CExpression result = new CExpression();
        WasmType type = this.requiredType;
        StringBuilder sb = new StringBuilder();
        sb.append("(*(" + WasmCRenderingVisitor.mapType(expression.getType().getSingleReturnType()) + " (*)(");
        for (int i = 0; i < expression.getType().getParameterTypes().size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(WasmCRenderingVisitor.mapType(expression.getType().getParameterTypes().get(i)));
        }
        sb.append(")) ");
        this.requiredType = WasmType.INT32;
        expression.getSelector().acceptVisitor(this);
        result.getLines().addAll(this.value.getLines());
        this.value = this.cacheIfNeeded(WasmType.INT32, this.value, result);
        sb.append("wasm_table[" + this.value.getText() + "])(");
        this.translateArguments(expression.getArguments(), expression.getType().getParameterTypes(), result, sb);
        sb.append(")");
        result.setText(sb.toString());
        if (type == null) {
            result.addLine(result.getText() + ";", expression.getLocation());
            result.setText(null);
        }
        this.value = result;
    }

    @Override
    public void visit(WasmCallReference expression) {
        this.unsupported();
    }

    private void translateArguments(List<? extends WasmExpression> wasmArguments, List<? extends WasmType> signature, CExpression result, StringBuilder sb) {
        int i;
        if (wasmArguments.isEmpty()) {
            return;
        }
        ArrayList<CExpression> arguments = new ArrayList<CExpression>();
        int needsCachingUntil = 0;
        for (i = wasmArguments.size() - 1; i >= 0; --i) {
            this.requiredType = signature.get(i);
            wasmArguments.get(i).acceptVisitor(this);
            arguments.add(this.value);
            if (this.value.getLines().isEmpty() || needsCachingUntil != 0) continue;
            needsCachingUntil = i;
        }
        Collections.reverse(arguments);
        for (i = 0; i < arguments.size(); ++i) {
            CExpression argument = (CExpression)arguments.get(i);
            result.getLines().addAll(argument.getLines());
            if (i < needsCachingUntil) {
                argument = this.cacheIfNeeded(signature.get(i), argument, result);
            }
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(argument.getText());
        }
        this.value = result;
    }

    @Override
    public void visit(WasmDrop expression) {
        CExpression result = new CExpression();
        this.requiredType = null;
        expression.getOperand().acceptVisitor(this);
        result.getLines().addAll(this.value.getLines());
        this.value = result;
    }

    @Override
    public void visit(WasmLoadInt32 expression) {
        CExpression result = new CExpression();
        WasmType type = this.requiredType;
        this.requiredType = WasmType.INT32;
        expression.getIndex().acceptVisitor(this);
        CExpression index = this.checkAddress(this.value);
        if (type == null) {
            this.value = index;
            return;
        }
        result.getLines().addAll(index.getLines());
        String base = "&wasm_heap[" + index.getText() + " + " + expression.getOffset() + "]";
        switch (expression.getConvertFrom()) {
            case INT8: {
                result.setText("(int32_t) (int8_t) " + base.substring(1));
                break;
            }
            case UINT8: {
                result.setText("(int32_t) (uint8_t) " + base.substring(1));
                break;
            }
            case INT16: {
                result.setText("(int32_t) *((int16_t *) " + base + ")");
                break;
            }
            case UINT16: {
                result.setText("(int32_t) *((uint16_t *) " + base + ")");
                break;
            }
            case INT32: {
                result.setText("*((int32_t *) " + base + ")");
            }
        }
        this.value = result;
    }

    @Override
    public void visit(WasmLoadInt64 expression) {
        CExpression result = new CExpression();
        WasmType type = this.requiredType;
        this.requiredType = WasmType.INT32;
        expression.getIndex().acceptVisitor(this);
        CExpression index = this.checkAddress(this.value);
        if (type == null) {
            this.value = index;
            return;
        }
        result.getLines().addAll(index.getLines());
        String base = "&wasm_heap[" + index.getText() + " + " + expression.getOffset() + "]";
        switch (expression.getConvertFrom()) {
            case INT8: {
                result.setText("(int64_t) (int8_t) " + base.substring(1));
                break;
            }
            case UINT8: {
                result.setText("(int64_t) (uint8_t) " + base.substring(1));
                break;
            }
            case INT16: {
                result.setText("(int64_t) *((int16_t *) " + base + ")");
                break;
            }
            case UINT16: {
                result.setText("(int64_t) *((uint16_t *) " + base + ")");
                break;
            }
            case INT32: {
                result.setText("(int64_t) *((int32_t *) " + base + ")");
                break;
            }
            case UINT32: {
                result.setText("(int64_t) *((uint32_t *) " + base + ")");
                break;
            }
            case INT64: {
                result.setText("*((int64_t *) " + base + ")");
            }
        }
        this.value = result;
    }

    @Override
    public void visit(WasmLoadFloat32 expression) {
        CExpression result = new CExpression();
        WasmType type = this.requiredType;
        this.requiredType = WasmType.INT32;
        expression.getIndex().acceptVisitor(this);
        CExpression index = this.checkAddress(this.value);
        if (type == null) {
            this.value = index;
            return;
        }
        result.getLines().addAll(index.getLines());
        result.setText("*((float *) &wasm_heap[" + index.getText() + " + " + expression.getOffset() + "])");
        this.value = result;
    }

    @Override
    public void visit(WasmLoadFloat64 expression) {
        CExpression result = new CExpression();
        WasmType type = this.requiredType;
        this.requiredType = WasmType.INT32;
        expression.getIndex().acceptVisitor(this);
        CExpression index = this.checkAddress(this.value);
        if (type == null) {
            this.value = index;
            return;
        }
        result.getLines().addAll(index.getLines());
        result.setText("*((double *) &wasm_heap[" + index.getText() + " + " + expression.getOffset() + "])");
        this.value = result;
    }

    @Override
    public void visit(WasmStoreInt32 expression) {
        String line;
        CExpression result = new CExpression();
        this.requiredType = WasmType.INT32;
        expression.getIndex().acceptVisitor(this);
        CExpression index = this.checkAddress(this.value);
        this.requiredType = WasmType.INT32;
        expression.getValue().acceptVisitor(this);
        CExpression valueToStore = this.value;
        result.getLines().addAll(index.getLines());
        result.getLines().addAll(valueToStore.getLines());
        String base = "&wasm_heap[" + index.getText() + " + " + expression.getOffset() + "]";
        switch (expression.getConvertTo()) {
            case INT8: {
                line = base.substring(1) + " = " + valueToStore.getText() + ";";
                break;
            }
            case UINT8: {
                line = "*((uint8_t *) " + base + ") = " + valueToStore.getText() + ";";
                break;
            }
            case INT16: {
                line = "*((int16_t *) " + base + ") = " + valueToStore.getText() + ";";
                break;
            }
            case UINT16: {
                line = "*((uint16_t *) " + base + ") = " + valueToStore.getText() + ";";
                break;
            }
            case INT32: {
                line = "*((int32_t *) " + base + ") = " + valueToStore.getText() + ";";
                break;
            }
            default: {
                throw new AssertionError((Object)expression.getConvertTo().toString());
            }
        }
        result.addLine(line, expression.getLocation());
        this.value = result;
    }

    @Override
    public void visit(WasmStoreInt64 expression) {
        String line;
        CExpression result = new CExpression();
        this.requiredType = WasmType.INT32;
        expression.getIndex().acceptVisitor(this);
        CExpression index = this.checkAddress(this.value);
        this.requiredType = WasmType.INT64;
        expression.getValue().acceptVisitor(this);
        CExpression valueToStore = this.value;
        result.getLines().addAll(index.getLines());
        result.getLines().addAll(valueToStore.getLines());
        String base = "&wasm_heap[" + index.getText() + " + " + expression.getOffset() + "]";
        switch (expression.getConvertTo()) {
            case INT8: {
                line = base.substring(1) + " = " + valueToStore.getText();
                break;
            }
            case UINT8: {
                line = "*((uint8_t *) " + base + ") = " + valueToStore.getText() + ";";
                break;
            }
            case INT16: {
                line = "*((int16_t *) " + base + ") = " + valueToStore.getText() + ";";
                break;
            }
            case UINT16: {
                line = "*((uint16_t *) " + base + ") = " + valueToStore.getText() + ";";
                break;
            }
            case INT32: {
                line = "*((int32_t *) " + base + ") = " + valueToStore.getText() + ";";
                break;
            }
            case UINT32: {
                line = "*((uint32_t *) " + base + ") = " + valueToStore.getText() + ";";
                break;
            }
            case INT64: {
                line = "*((int64_t *) " + base + ") = " + valueToStore.getText() + ";";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        result.addLine(line, expression.getLocation());
        this.value = result;
    }

    @Override
    public void visit(WasmStoreFloat32 expression) {
        CExpression result = new CExpression();
        this.requiredType = WasmType.INT32;
        expression.getIndex().acceptVisitor(this);
        CExpression index = this.checkAddress(this.value);
        this.requiredType = WasmType.FLOAT32;
        expression.getValue().acceptVisitor(this);
        CExpression valueToStore = this.value;
        result.getLines().addAll(index.getLines());
        result.getLines().addAll(valueToStore.getLines());
        result.addLine("*((float *) &wasm_heap[" + index.getText() + " + " + expression.getOffset() + "]) = " + valueToStore.getText() + ";", expression.getLocation());
        this.value = result;
    }

    @Override
    public void visit(WasmStoreFloat64 expression) {
        CExpression result = new CExpression();
        this.requiredType = WasmType.INT32;
        expression.getIndex().acceptVisitor(this);
        CExpression index = this.checkAddress(this.value);
        this.requiredType = WasmType.FLOAT64;
        expression.getValue().acceptVisitor(this);
        CExpression valueToStore = this.value;
        result.getLines().addAll(index.getLines());
        result.getLines().addAll(valueToStore.getLines());
        result.addLine("*((double *) &wasm_heap[" + index.getText() + " + " + expression.getOffset() + "]) = " + valueToStore.getText() + ";", expression.getLocation());
        this.value = result;
    }

    @Override
    public void visit(WasmMemoryGrow expression) {
        CExpression result = new CExpression();
        this.requiredType = WasmType.INT32;
        expression.getAmount().acceptVisitor(this);
        CExpression amount = this.value;
        if (amount.getLines().isEmpty()) {
            result.addLine("wasm_heap_size += 65536 * (" + amount.getText() + ");", expression.getLocation());
        } else {
            result.addLine("wasm_heap_size += 65536 * (" + amount.getText(), expression.getLocation());
            result.getLines().addAll(amount.getLines());
            result.addLine(");", expression.getLocation());
        }
        result.addLine("wasm_heap = realloc(wasm_heap, wasm_heap_size);");
        this.value = result;
    }

    @Override
    public void visit(WasmFill expression) {
        CExpression result = new CExpression();
        this.requiredType = WasmType.INT32;
        expression.getIndex().acceptVisitor(this);
        CExpression dest = this.value;
        this.requiredType = WasmType.INT32;
        expression.getValue().acceptVisitor(this);
        CExpression v = this.value;
        this.requiredType = WasmType.INT32;
        expression.getCount().acceptVisitor(this);
        CExpression num = this.value;
        result.getLines().addAll(dest.getLines());
        result.getLines().addAll(v.getLines());
        result.getLines().addAll(num.getLines());
        result.addLine("memset(wasm_heap + " + dest.getText() + ", " + v.getText() + ", " + num.getText() + ");");
        this.value = result;
    }

    @Override
    public void visit(WasmCopy expression) {
        CExpression result = new CExpression();
        this.requiredType = WasmType.INT32;
        expression.getDestinationIndex().acceptVisitor(this);
        CExpression dest = this.value;
        this.requiredType = WasmType.INT32;
        expression.getSourceIndex().acceptVisitor(this);
        CExpression src = this.value;
        this.requiredType = WasmType.INT32;
        expression.getCount().acceptVisitor(this);
        CExpression num = this.value;
        result.getLines().addAll(dest.getLines());
        result.getLines().addAll(src.getLines());
        result.getLines().addAll(num.getLines());
        result.addLine("memcpy(wasm_heap + " + dest.getText() + ", wasm_heap + " + src.getText() + ", " + num.getText() + ");");
        this.value = result;
    }

    @Override
    public void visit(WasmTry expression) {
        this.value = new CExpression("/* TRY */");
    }

    @Override
    public void visit(WasmThrow expression) {
        this.value = new CExpression("/* THROW */");
    }

    @Override
    public void visit(WasmReferencesEqual expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmCast expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmTest expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmExternConversion expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmStructNew expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmStructNewDefault expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmStructGet expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmStructSet expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmArrayNewDefault expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmArrayNewFixed expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmArrayGet expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmArraySet expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmArrayLength expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmArrayCopy expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmFunctionReference expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmInt31Reference expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmInt31Get expression) {
        this.unsupported();
    }

    @Override
    public void visit(WasmPush expression) {
    }

    @Override
    public void visit(WasmPop expression) {
    }

    private void unsupported() {
        this.value = new CExpression("/* unsupported */");
    }

    private CExpression checkAddress(CExpression index) {
        Object var;
        if (!this.memoryAccessChecked) {
            return index;
        }
        CExpression checked = new CExpression();
        checked.getLines().addAll(index.getLines());
        if (!index.isRelocatable()) {
            var = "tmp_" + this.temporaryIndex++;
            checked.addLine("int32_t " + (String)var + " = " + index.getText() + ";");
        } else {
            var = index.getText();
        }
        checked.addLine("assert(" + (String)var + " < " + this.module.getMinMemorySize() * 65536 + ");");
        checked.setText((String)var);
        checked.setRelocatable(index.isRelocatable());
        return checked;
    }

    private CLine declareVariable(String name, WasmType type) {
        return new CSingleLine(WasmCRenderingVisitor.mapType(type) + " " + name + ";");
    }

    static String mapType(WasmType type) {
        if (type instanceof WasmType.Number) {
            return WasmCRenderingVisitor.mapType(((WasmType.Number)type).number);
        }
        if (type instanceof WasmType.Reference) {
            return "/* unknown type */";
        }
        if (type == null) {
            return "void";
        }
        throw new IllegalArgumentException();
    }

    static String mapType(WasmNumType type) {
        switch (type) {
            case INT32: {
                return "int32_t";
            }
            case INT64: {
                return "int64_t";
            }
            case FLOAT32: {
                return "float";
            }
            case FLOAT64: {
                return "double";
            }
        }
        throw new AssertionError((Object)type.toString());
    }

    private static WasmType asWasmType(WasmIntType type) {
        switch (type) {
            case INT32: {
                return WasmType.INT32;
            }
            case INT64: {
                return WasmType.INT64;
            }
        }
        throw new AssertionError((Object)type.toString());
    }

    private static WasmType asWasmType(WasmFloatType type) {
        switch (type) {
            case FLOAT32: {
                return WasmType.FLOAT32;
            }
            case FLOAT64: {
                return WasmType.FLOAT64;
            }
        }
        throw new AssertionError((Object)type.toString());
    }

    String getVariableName(WasmLocal local) {
        Object result = this.localVariableNames[local.getIndex()];
        if (result == null) {
            result = local.getName() != null ? "_" + local.getName() : "localVar" + local.getIndex();
            if (!this.usedVariableNames.add((String)result)) {
                Object base = result;
                int suffix = 1;
                while (!this.usedVariableNames.add((String)base + suffix)) {
                    ++suffix;
                }
                result = (String)base + suffix;
            }
            this.localVariableNames[local.getIndex()] = result;
        }
        return result;
    }

    String getVariableName(WasmGlobal global) {
        return "wasm_global_" + this.module.globals.indexOf(global);
    }

    private static class BlockInfo {
        int index;
        String label;
        String temporaryVariable;
        WasmType type;

        private BlockInfo() {
        }
    }
}

