/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model;

import org.teavm.backend.wasm.model.WasmBlockType;
import org.teavm.backend.wasm.model.WasmCompositeType;
import org.teavm.backend.wasm.model.WasmNumType;
import org.teavm.backend.wasm.model.WasmStorageType;

public abstract class WasmType {
    public static final Number INT32 = new Number(WasmNumType.INT32);
    public static final Number INT64 = new Number(WasmNumType.INT64);
    public static final Number FLOAT32 = new Number(WasmNumType.FLOAT32);
    public static final Number FLOAT64 = new Number(WasmNumType.FLOAT64);
    private WasmStorageType.Regular storageType;
    private WasmBlockType.Value blockType;

    private WasmType() {
    }

    public WasmStorageType.Regular asStorage() {
        if (this.storageType == null) {
            this.storageType = new WasmStorageType.Regular(this);
        }
        return this.storageType;
    }

    public WasmBlockType.Value asBlock() {
        if (this.blockType == null) {
            this.blockType = new WasmBlockType.Value(this);
        }
        return this.blockType;
    }

    public static Number num(WasmNumType number) {
        switch (number) {
            case INT32: {
                return INT32;
            }
            case INT64: {
                return INT64;
            }
            case FLOAT32: {
                return FLOAT32;
            }
            case FLOAT64: {
                return FLOAT64;
            }
        }
        throw new IllegalArgumentException();
    }

    public static final class Number
    extends WasmType {
        public final WasmNumType number;

        private Number(WasmNumType number) {
            this.number = number;
        }
    }

    public static enum SpecialReferenceKind {
        FUNC,
        ANY,
        EQ,
        EXTERN,
        STRUCT,
        ARRAY,
        I31;

        private SpecialReference type;
        private SpecialReference nonNullType;

        public final SpecialReference asType() {
            if (this.type == null) {
                this.type = new SpecialReference(this, true);
            }
            return this.type;
        }

        public final SpecialReference asNonNullType() {
            if (this.nonNullType == null) {
                this.nonNullType = new SpecialReference(this, false);
            }
            return this.nonNullType;
        }
    }

    public static final class SpecialReference
    extends Reference {
        public final SpecialReferenceKind kind;

        private SpecialReference(SpecialReferenceKind kind, boolean nullable) {
            super(nullable);
            this.kind = kind;
        }
    }

    public static final class CompositeReference
    extends Reference {
        public final WasmCompositeType composite;

        CompositeReference(WasmCompositeType composite, boolean nullable) {
            super(nullable);
            this.composite = composite;
        }
    }

    public static abstract class Reference
    extends WasmType {
        public static final SpecialReference FUNC = SpecialReferenceKind.FUNC.asType();
        public static final SpecialReference ANY = SpecialReferenceKind.ANY.asType();
        public static final SpecialReference EQ = SpecialReferenceKind.EQ.asType();
        public static final SpecialReference EXTERN = SpecialReferenceKind.EXTERN.asType();
        public static final SpecialReference STRUCT = SpecialReferenceKind.STRUCT.asType();
        public static final SpecialReference ARRAY = SpecialReferenceKind.ARRAY.asType();
        public static final SpecialReference I31 = SpecialReferenceKind.I31.asType();
        private final boolean nullable;

        Reference(boolean nullable) {
            this.nullable = nullable;
        }

        public boolean isNullable() {
            return this.nullable;
        }
    }
}

