/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model;

import org.teavm.backend.wasm.model.WasmPackedType;
import org.teavm.backend.wasm.model.WasmType;

public abstract class WasmStorageType {
    public static final Packed INT16 = new Packed(WasmPackedType.INT16);
    public static final Packed INT8 = new Packed(WasmPackedType.INT8);

    private WasmStorageType() {
    }

    public abstract WasmType asUnpackedType();

    public static Packed packed(WasmPackedType type) {
        switch (type) {
            case INT8: {
                return INT8;
            }
            case INT16: {
                return INT16;
            }
        }
        throw new IllegalArgumentException();
    }

    public static final class Packed
    extends WasmStorageType {
        public final WasmPackedType type;

        private Packed(WasmPackedType type) {
            this.type = type;
        }

        @Override
        public WasmType asUnpackedType() {
            return WasmType.INT32;
        }
    }

    public static final class Regular
    extends WasmStorageType {
        public final WasmType type;

        Regular(WasmType type) {
            this.type = type;
        }

        @Override
        public WasmType asUnpackedType() {
            return this.type;
        }
    }
}

