/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import org.teavm.ast.ConstantExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.model.ValueType;

public class StructureIntrinsic
implements WasmGCIntrinsic {
    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getName()) {
            case "toAddress": 
            case "cast": {
                return context.generate(invocation.getArguments().get(0));
            }
            case "sizeOf": {
                ValueType.Object type = (ValueType.Object)((ConstantExpr)invocation.getArguments().get(0)).getValue();
                return new WasmInt32Constant(context.classInfoProvider().getHeapSize(type.getClassName()));
            }
            case "add": {
                WasmExpression base = context.generate(invocation.getArguments().get(1));
                WasmExpression offset = context.generate(invocation.getArguments().get(2));
                Object type = ((ConstantExpr)invocation.getArguments().get(0)).getValue();
                String className = ((ValueType.Object)type).getClassName();
                int size = context.classInfoProvider().getHeapSize(className);
                int alignment = context.classInfoProvider().getHeapAlignment(className);
                size = WasmClassGenerator.align(size, alignment);
                offset = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.MUL, offset, new WasmInt32Constant(size));
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, base, offset);
            }
        }
        throw new IllegalArgumentException(invocation.getMethod().toString());
    }
}

