/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.generate.CachedExpression;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.runtime.StringInternPool;
import org.teavm.model.ValueType;

class StringInternPoolIntrinsic
implements WasmGCIntrinsic {
    StringInternPoolIntrinsic() {
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmStructure entryStruct = context.classInfoProvider().getClassInfo(StringInternPool.class.getName() + "$Entry").getStructure();
        switch (invocation.getMethod().getName()) {
            case "getValue": {
                WasmStructGet weakRef = new WasmStructGet(entryStruct, context.generate(invocation.getArguments().get(0)), 5);
                return new WasmCall(this.createDerefFunction(context), weakRef);
            }
            case "setValue": {
                WasmBlock block = new WasmBlock(false);
                CachedExpression instance = context.exprCache().create(context.generate(invocation.getArguments().get(0)), entryStruct.getReference(), invocation.getLocation(), block.getBody());
                WasmExpression value = context.generate(invocation.getArguments().get(1));
                WasmCall ref = new WasmCall(this.createRefFunction(context), value, instance.expr());
                block.getBody().add(new WasmStructSet(entryStruct, instance.expr(), 5, ref));
                instance.release();
                return block;
            }
        }
        throw new IllegalArgumentException();
    }

    private WasmFunction createRefFunction(WasmGCIntrinsicContext context) {
        WasmFunction function = new WasmFunction(context.functionTypes().of(WasmType.Reference.EXTERN, context.typeMapper().mapType(ValueType.parse(String.class)), context.typeMapper().mapType(ValueType.object(StringInternPool.class.getName() + "$Entry"))));
        function.setName(context.names().topLevel("teavm@stringRef"));
        function.setImportModule("teavm");
        function.setImportName("createStringWeakRef");
        context.module().functions.add(function);
        return function;
    }

    private WasmFunction createDerefFunction(WasmGCIntrinsicContext context) {
        WasmFunction function = new WasmFunction(context.functionTypes().of(context.typeMapper().mapType(ValueType.parse(String.class)), WasmType.Reference.EXTERN));
        function.setName(context.names().topLevel("teavm@stringDeref"));
        function.setImportModule("teavm");
        function.setImportName("stringDeref");
        context.module().functions.add(function);
        return function;
    }
}

